/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchColumnFormat;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesFormat;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesItem;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesRegister;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesRegisterBigEndian;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesTreeTable;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesVariable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="LiveWatchesService", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0005\u001c\u001d\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00180\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$State;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "<init>", "()V", "state", "getState", "loadState", "", "value", "", "samplingTimeMs", "getSamplingTimeMs", "()I", "setSamplingTimeMs", "(I)V", "", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "expressions", "getExpressions", "()Ljava/util/List;", "setExpressions", "(Ljava/util/List;)V", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchColumnFormat;", "columnFormats", "getColumnFormats", "setColumnFormats", "LiveItemProducer", "Expression", "Register", "RegisterBigEndian", "State", "intellij.clion.embedded"})
public final class LiveWatchesService
extends SimpleModificationTracker
implements PersistentStateComponent<State> {
    @NotNull
    private State state = new State(500, CollectionsKt.emptyList(), null, 4, null);

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    public final int getSamplingTimeMs() {
        return this.state.getSamplingTimeMs();
    }

    public final void setSamplingTimeMs(int value) {
        if (this.state.getSamplingTimeMs() != value) {
            this.state.setSamplingTimeMs(value);
            this.incModificationCount();
        }
    }

    @NotNull
    public final List<LiveItemProducer> getExpressions() {
        return this.state.getExpressions();
    }

    public final void setExpressions(@NotNull List<? extends LiveItemProducer> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.state.getExpressions(), value)) {
            this.state.setExpressions(value);
            this.incModificationCount();
        }
    }

    @NotNull
    public final List<LiveWatchColumnFormat> getColumnFormats() {
        return this.state.getColumnInfo();
    }

    public final void setColumnFormats(@NotNull List<LiveWatchColumnFormat> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.state.setColumnInfo(value);
        this.incModificationCount();
    }

    @Tag(value="expr")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$Expression;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "expression", "", "format", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "<init>", "(Ljava/lang/String;Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "getExpression", "()Ljava/lang/String;", "getFormat", "()Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "setFormat", "(Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "newLiveItem", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "exprId", "", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.clion.embedded"})
    public static final class Expression
    implements LiveItemProducer {
        @Text
        @NotNull
        private final String expression;
        @Attribute
        @NotNull
        private LiveWatchesFormat format;

        public Expression(@NotNull String expression, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this.expression = expression;
            this.format = format;
        }

        public /* synthetic */ Expression(String string, LiveWatchesFormat liveWatchesFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                liveWatchesFormat = LiveWatchesFormat.DEFAULT;
            }
            this(string, liveWatchesFormat);
        }

        @NotNull
        public final String getExpression() {
            return this.expression;
        }

        @NotNull
        public final LiveWatchesFormat getFormat() {
            return this.format;
        }

        public final void setFormat(@NotNull LiveWatchesFormat liveWatchesFormat) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesFormat), (String)"<set-?>");
            this.format = liveWatchesFormat;
        }

        @Override
        @NotNull
        public LiveWatchesItem newLiveItem(int exprId, @NotNull LiveWatchesTreeTable liveWatchesTreeTable) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesTreeTable), (String)"liveWatchesTreeTable");
            return new LiveWatchesVariable(exprId, this.expression, this.format, liveWatchesTreeTable);
        }

        @NotNull
        public final String component1() {
            return this.expression;
        }

        @NotNull
        public final LiveWatchesFormat component2() {
            return this.format;
        }

        @NotNull
        public final Expression copy(@NotNull String expression, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return new Expression(expression, format);
        }

        public static /* synthetic */ Expression copy$default(Expression expression, String string, LiveWatchesFormat liveWatchesFormat, int n, Object object) {
            if ((n & 1) != 0) {
                string = expression.expression;
            }
            if ((n & 2) != 0) {
                liveWatchesFormat = expression.format;
            }
            return expression.copy(string, liveWatchesFormat);
        }

        @NotNull
        public String toString() {
            return "Expression(expression=" + this.expression + ", format=" + this.format + ")";
        }

        public int hashCode() {
            int result = this.expression.hashCode();
            result = result * 31 + this.format.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Expression)) {
                return false;
            }
            Expression expression = (Expression)other;
            if (!Intrinsics.areEqual((Object)this.expression, (Object)expression.expression)) {
                return false;
            }
            return this.format == expression.format;
        }

        public Expression() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "", "newLiveItem", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "exprId", "", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "intellij.clion.embedded"})
    public static interface LiveItemProducer {
        @NotNull
        public LiveWatchesItem newLiveItem(int var1, @NotNull LiveWatchesTreeTable var2);
    }

    @Tag(value="reg")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$Register;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "expression", "", "address", "description", "size", "", "format", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "getExpression", "()Ljava/lang/String;", "getAddress", "getDescription", "getSize", "()I", "getFormat", "()Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "setFormat", "(Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "newLiveItem", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "exprId", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.clion.embedded"})
    public static final class Register
    implements LiveItemProducer {
        @Text
        @NotNull
        private final String expression;
        @Attribute
        @NotNull
        private final String address;
        @Attribute
        @NotNull
        private final String description;
        @Attribute
        private final int size;
        @Attribute
        @NotNull
        private LiveWatchesFormat format;

        public Register(@NotNull String expression, @NotNull String address, @NotNull String description, int size, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this.expression = expression;
            this.address = address;
            this.description = description;
            this.size = size;
            this.format = format;
        }

        public /* synthetic */ Register(String string, String string2, String string3, int n, LiveWatchesFormat liveWatchesFormat, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = "";
            }
            if ((n2 & 2) != 0) {
                string2 = "";
            }
            if ((n2 & 4) != 0) {
                string3 = "";
            }
            if ((n2 & 8) != 0) {
                n = 4;
            }
            if ((n2 & 0x10) != 0) {
                liveWatchesFormat = LiveWatchesFormat.DEFAULT;
            }
            this(string, string2, string3, n, liveWatchesFormat);
        }

        @NotNull
        public final String getExpression() {
            return this.expression;
        }

        @NotNull
        public final String getAddress() {
            return this.address;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final LiveWatchesFormat getFormat() {
            return this.format;
        }

        public final void setFormat(@NotNull LiveWatchesFormat liveWatchesFormat) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesFormat), (String)"<set-?>");
            this.format = liveWatchesFormat;
        }

        @Override
        @NotNull
        public LiveWatchesItem newLiveItem(int exprId, @NotNull LiveWatchesTreeTable liveWatchesTreeTable) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesTreeTable), (String)"liveWatchesTreeTable");
            return new LiveWatchesRegister(exprId, this.expression, Address.Companion.parseHexString(this.address), this.size, this.description, this.format, liveWatchesTreeTable);
        }

        @NotNull
        public final String component1() {
            return this.expression;
        }

        @NotNull
        public final String component2() {
            return this.address;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        public final int component4() {
            return this.size;
        }

        @NotNull
        public final LiveWatchesFormat component5() {
            return this.format;
        }

        @NotNull
        public final Register copy(@NotNull String expression, @NotNull String address, @NotNull String description, int size, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return new Register(expression, address, description, size, format);
        }

        public static /* synthetic */ Register copy$default(Register register, String string, String string2, String string3, int n, LiveWatchesFormat liveWatchesFormat, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = register.expression;
            }
            if ((n2 & 2) != 0) {
                string2 = register.address;
            }
            if ((n2 & 4) != 0) {
                string3 = register.description;
            }
            if ((n2 & 8) != 0) {
                n = register.size;
            }
            if ((n2 & 0x10) != 0) {
                liveWatchesFormat = register.format;
            }
            return register.copy(string, string2, string3, n, liveWatchesFormat);
        }

        @NotNull
        public String toString() {
            return "Register(expression=" + this.expression + ", address=" + this.address + ", description=" + this.description + ", size=" + this.size + ", format=" + this.format + ")";
        }

        public int hashCode() {
            int result = this.expression.hashCode();
            result = result * 31 + this.address.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + this.format.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Register)) {
                return false;
            }
            Register register = (Register)other;
            if (!Intrinsics.areEqual((Object)this.expression, (Object)register.expression)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.address, (Object)register.address)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)register.description)) {
                return false;
            }
            if (this.size != register.size) {
                return false;
            }
            return this.format == register.format;
        }

        public Register() {
            this(null, null, null, 0, null, 31, null);
        }
    }

    @Tag(value="reg-be")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$RegisterBigEndian;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "expression", "", "address", "description", "size", "", "format", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "getExpression", "()Ljava/lang/String;", "getAddress", "getDescription", "getSize", "()I", "getFormat", "()Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "setFormat", "(Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "newLiveItem", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "exprId", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.clion.embedded"})
    public static final class RegisterBigEndian
    implements LiveItemProducer {
        @Text
        @NotNull
        private final String expression;
        @Attribute
        @NotNull
        private final String address;
        @Attribute
        @NotNull
        private final String description;
        @Attribute
        private final int size;
        @Attribute
        @NotNull
        private LiveWatchesFormat format;

        public RegisterBigEndian(@NotNull String expression, @NotNull String address, @NotNull String description, int size, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this.expression = expression;
            this.address = address;
            this.description = description;
            this.size = size;
            this.format = format;
        }

        public /* synthetic */ RegisterBigEndian(String string, String string2, String string3, int n, LiveWatchesFormat liveWatchesFormat, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = "";
            }
            if ((n2 & 2) != 0) {
                string2 = "";
            }
            if ((n2 & 4) != 0) {
                string3 = "";
            }
            if ((n2 & 8) != 0) {
                n = 4;
            }
            if ((n2 & 0x10) != 0) {
                liveWatchesFormat = LiveWatchesFormat.DEFAULT;
            }
            this(string, string2, string3, n, liveWatchesFormat);
        }

        @NotNull
        public final String getExpression() {
            return this.expression;
        }

        @NotNull
        public final String getAddress() {
            return this.address;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final LiveWatchesFormat getFormat() {
            return this.format;
        }

        public final void setFormat(@NotNull LiveWatchesFormat liveWatchesFormat) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesFormat), (String)"<set-?>");
            this.format = liveWatchesFormat;
        }

        @Override
        @NotNull
        public LiveWatchesItem newLiveItem(int exprId, @NotNull LiveWatchesTreeTable liveWatchesTreeTable) {
            Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesTreeTable), (String)"liveWatchesTreeTable");
            return new LiveWatchesRegisterBigEndian(exprId, this.expression, Address.Companion.parseHexString(this.address), this.size, this.description, this.format, liveWatchesTreeTable);
        }

        @NotNull
        public final String component1() {
            return this.expression;
        }

        @NotNull
        public final String component2() {
            return this.address;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        public final int component4() {
            return this.size;
        }

        @NotNull
        public final LiveWatchesFormat component5() {
            return this.format;
        }

        @NotNull
        public final RegisterBigEndian copy(@NotNull String expression, @NotNull String address, @NotNull String description, int size, @NotNull LiveWatchesFormat format) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return new RegisterBigEndian(expression, address, description, size, format);
        }

        public static /* synthetic */ RegisterBigEndian copy$default(RegisterBigEndian registerBigEndian, String string, String string2, String string3, int n, LiveWatchesFormat liveWatchesFormat, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = registerBigEndian.expression;
            }
            if ((n2 & 2) != 0) {
                string2 = registerBigEndian.address;
            }
            if ((n2 & 4) != 0) {
                string3 = registerBigEndian.description;
            }
            if ((n2 & 8) != 0) {
                n = registerBigEndian.size;
            }
            if ((n2 & 0x10) != 0) {
                liveWatchesFormat = registerBigEndian.format;
            }
            return registerBigEndian.copy(string, string2, string3, n, liveWatchesFormat);
        }

        @NotNull
        public String toString() {
            return "RegisterBigEndian(expression=" + this.expression + ", address=" + this.address + ", description=" + this.description + ", size=" + this.size + ", format=" + this.format + ")";
        }

        public int hashCode() {
            int result = this.expression.hashCode();
            result = result * 31 + this.address.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + this.format.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegisterBigEndian)) {
                return false;
            }
            RegisterBigEndian registerBigEndian = (RegisterBigEndian)other;
            if (!Intrinsics.areEqual((Object)this.expression, (Object)registerBigEndian.expression)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.address, (Object)registerBigEndian.address)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)registerBigEndian.description)) {
                return false;
            }
            if (this.size != registerBigEndian.size) {
                return false;
            }
            return this.format == registerBigEndian.format;
        }

        public RegisterBigEndian() {
            this(null, null, null, 0, null, 31, null);
        }
    }

    @Tag(value="live-watches")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$State;", "", "samplingTimeMs", "", "expressions", "", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "columnInfo", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchColumnFormat;", "<init>", "(ILjava/util/List;Ljava/util/List;)V", "getSamplingTimeMs", "()I", "setSamplingTimeMs", "(I)V", "getExpressions", "()Ljava/util/List;", "setExpressions", "(Ljava/util/List;)V", "getColumnInfo", "setColumnInfo", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.clion.embedded"})
    public static final class State {
        @Attribute(value="sampling-time-ms")
        private int samplingTimeMs;
        @XCollection(propertyElementName="items", elementTypes={Expression.class, Register.class, RegisterBigEndian.class}, style=XCollection.Style.v2)
        @NotNull
        private List<? extends LiveItemProducer> expressions;
        @XCollection(propertyElementName="columns", elementName="column", style=XCollection.Style.v2)
        @NotNull
        private List<LiveWatchColumnFormat> columnInfo;

        public State(int samplingTimeMs, @NotNull List<? extends LiveItemProducer> expressions, @NotNull List<LiveWatchColumnFormat> columnInfo) {
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            Intrinsics.checkNotNullParameter(columnInfo, (String)"columnInfo");
            this.samplingTimeMs = samplingTimeMs;
            this.expressions = expressions;
            this.columnInfo = columnInfo;
        }

        public /* synthetic */ State(int n, List list, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 500;
            }
            if ((n2 & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(n, list, list2);
        }

        public final int getSamplingTimeMs() {
            return this.samplingTimeMs;
        }

        public final void setSamplingTimeMs(int n) {
            this.samplingTimeMs = n;
        }

        @NotNull
        public final List<LiveItemProducer> getExpressions() {
            return this.expressions;
        }

        public final void setExpressions(@NotNull List<? extends LiveItemProducer> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.expressions = list;
        }

        @NotNull
        public final List<LiveWatchColumnFormat> getColumnInfo() {
            return this.columnInfo;
        }

        public final void setColumnInfo(@NotNull List<LiveWatchColumnFormat> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.columnInfo = list;
        }

        public final int component1() {
            return this.samplingTimeMs;
        }

        @NotNull
        public final List<LiveItemProducer> component2() {
            return this.expressions;
        }

        @NotNull
        public final List<LiveWatchColumnFormat> component3() {
            return this.columnInfo;
        }

        @NotNull
        public final State copy(int samplingTimeMs, @NotNull List<? extends LiveItemProducer> expressions, @NotNull List<LiveWatchColumnFormat> columnInfo) {
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            Intrinsics.checkNotNullParameter(columnInfo, (String)"columnInfo");
            return new State(samplingTimeMs, expressions, columnInfo);
        }

        public static /* synthetic */ State copy$default(State state, int n, List list, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = state.samplingTimeMs;
            }
            if ((n2 & 2) != 0) {
                list = state.expressions;
            }
            if ((n2 & 4) != 0) {
                list2 = state.columnInfo;
            }
            return state.copy(n, list, list2);
        }

        @NotNull
        public String toString() {
            return "State(samplingTimeMs=" + this.samplingTimeMs + ", expressions=" + this.expressions + ", columnInfo=" + this.columnInfo + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.samplingTimeMs);
            result = result * 31 + ((Object)this.expressions).hashCode();
            result = result * 31 + ((Object)this.columnInfo).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.samplingTimeMs != state.samplingTimeMs) {
                return false;
            }
            if (!Intrinsics.areEqual(this.expressions, state.expressions)) {
                return false;
            }
            return Intrinsics.areEqual(this.columnInfo, state.columnInfo);
        }

        public State() {
            this(0, null, null, 7, null);
        }
    }
}

