/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.CLionEmbeddedIcons;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.debugger.peripheralview.SvdRegister;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesFormat;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesItem;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesService;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesSubProcess;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesTreeTable;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesRegister;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "exprId", "", "expression", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "size", "description", "format", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "<init>", "(ILjava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;ILjava/lang/String;Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;)V", "getExpression", "()Ljava/lang/String;", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getSize", "()I", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "addressRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "liveExpression", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "readValue", "", "hunk", "Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "doSample", "", "debugProcess", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesSubProcess;", "evaluator", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nLiveWatchesItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveWatchesItem.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesRegister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,360:1\n1#2:361\n23#3:362\n23#3:363\n*S KotlinDebug\n*F\n+ 1 LiveWatchesItem.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesRegister\n*L\n285#1:362\n293#1:363\n*E\n"})
public class LiveWatchesRegister
extends LiveWatchesItem {
    @NotNull
    private final String expression;
    @NotNull
    private final Address address;
    private final int size;
    @NotNull
    private final Icon icon;
    @NotNull
    private final AddressRange addressRange;

    /*
     * WARNING - void declaration
     */
    public LiveWatchesRegister(int exprId, @NotNull String expression, @NotNull Address address, int size, @NotNull String description, @NotNull LiveWatchesFormat format, @NotNull LiveWatchesTreeTable liveWatchesTreeTable) {
        void it;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesTreeTable), (String)"liveWatchesTreeTable");
        super(exprId, format, description, liveWatchesTreeTable);
        this.expression = expression;
        this.address = address;
        this.size = size;
        Icon icon = CLionEmbeddedIcons.CustomGdbRunConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CustomGdbRunConfiguration");
        this.icon = icon;
        Address address2 = this.address;
        LiveWatchesRegister liveWatchesRegister = this;
        boolean bl = false;
        liveWatchesRegister.addressRange = new AddressRange((Address)it, it.plus((Number)this.getSize()).minus((Number)1));
    }

    @Override
    @NotNull
    public String getExpression() {
        return this.expression;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public LiveWatchesService.LiveItemProducer liveExpression() {
        return new LiveWatchesService.Register(this.getExpression(), this.address.toStringNoZeroPad(), this.getDescription(), this.getSize(), this.getFormat());
    }

    public long readValue(@NotNull LLMemoryHunk hunk) {
        Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
        return SvdRegister.readLittleEndianValue(hunk, 0, this.getSize());
    }

    @Override
    protected void doSample(@NotNull LiveWatchesSubProcess debugProcess, @NotNull CidrEvaluator evaluator) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        debugProcess.postCommand((CidrDebugProcess.DebuggerCommand)((CidrDebugProcess.SuspendedDebuggerCommand)arg_0 -> LiveWatchesRegister.doSample$lambda$0(this, arg_0))).whenComplete((arg_0, arg_1) -> LiveWatchesRegister.doSample$lambda$2((arg_0, arg_1) -> LiveWatchesRegister.doSample$lambda$1(this, arg_0, arg_1), arg_0, arg_1));
    }

    private static final List doSample$lambda$0(LiveWatchesRegister this$0, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        List list = driver.dumpMemory(this$0.addressRange);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dumpMemory(...)");
        return list;
    }

    private static final Unit doSample$lambda$1(LiveWatchesRegister this$0, List hunks, Throwable exception) {
        if (exception != null) {
            String string = exception.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            this$0.samplingError(string);
        } else {
            LLMemoryHunk hunk;
            List list = hunks;
            Object object = hunk = list != null ? (LLMemoryHunk)CollectionsKt.singleOrNull((List)list) : null;
            if (hunk == null) {
                LiveWatchesRegister $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(LiveWatchesRegister.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Address range " + this$0.addressRange + " was not read");
                String string = EmbeddedBundle.message("label.type.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this$0.samplingError(string);
            } else if (hunk.getRange().contains(this$0.addressRange)) {
                this$0.newSample(this$0.readValue(hunk));
            } else {
                LiveWatchesRegister $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(LiveWatchesRegister.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Address range " + this$0.addressRange + " was read inconsistently");
                String string = EmbeddedBundle.message("label.type.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this$0.samplingError(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void doSample$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

