/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesFormat;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesService;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesSubProcess;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesTreeTable;
import com.intellij.clion.embedded.execution.debugtargets.live.NoData;
import com.intellij.clion.embedded.execution.debugtargets.live.NumberStringValue;
import com.intellij.clion.embedded.execution.debugtargets.live.ValueState;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H&J\u0019\u00107\u001a\u00070\u0007\u00a2\u0006\u0002\b82\f\u00109\u001a\b\u0012\u0004\u0012\u00020&0\u001fJ\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020?H\u0002J\"\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00072\b\u0010C\u001a\u0004\u0018\u00010\u0007H\u0004J\u0010\u0010@\u001a\u00020?2\u0006\u0010D\u001a\u00020EH\u0004J(\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\u00072\f\u0010F\u001a\b\u0012\u0004\u0012\u00020&0G2\b\u0010H\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010I\u001a\u00020?2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH$J\u0016\u0010N\u001a\u00020?2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MJ\u0015\u0010O\u001a\u00020?2\u000b\u0010P\u001a\u00070\u0007\u00a2\u0006\u0002\bQH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0013R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\"R \u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010+R \u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\"\"\u0004\b.\u0010+R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0012\u00105\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "exprId", "", "format", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "description", "", "liveWatchesTreeTable", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "<init>", "(ILcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;Ljava/lang/String;Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;)V", "getExprId", "()I", "getFormat", "()Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;", "setFormat", "(Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesFormat;)V", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "getLiveWatchesTreeTable", "()Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "liveExpression", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesService$LiveItemProducer;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/clion/embedded/execution/debugtargets/live/ValueState;", "getState", "()Ljava/util/concurrent/atomic/AtomicReference;", "expression", "getExpression", "lastValue", "Lcom/intellij/clion/embedded/execution/debugtargets/live/NumberStringValue;", "getLastValue$intellij_clion_embedded", "max", "getMax$intellij_clion_embedded", "setMax$intellij_clion_embedded", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "min", "getMin$intellij_clion_embedded", "setMin$intellij_clion_embedded", "changeCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getChangeCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setChangeCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "size", "getSize", "formatText", "Lcom/intellij/openapi/util/NlsSafe;", "value", "busy", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkFreeAndMarkBusy", "", "free", "", "newSample", "text", "numberText", "dataType", "number", "", "newValueOnDemand", "Lkotlin/Function0;", "dataTypeUpdate", "doSample", "debugProcess", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesSubProcess;", "evaluator", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "sample", "samplingError", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nLiveWatchesItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveWatchesItem.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,360:1\n23#2:361\n*S KotlinDebug\n*F\n+ 1 LiveWatchesItem.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesItem\n*L\n188#1:361\n*E\n"})
public abstract class LiveWatchesItem
extends DefaultMutableTreeNode {
    private final int exprId;
    @NotNull
    private volatile LiveWatchesFormat format;
    @NotNull
    private volatile String description;
    @NotNull
    private final LiveWatchesTreeTable liveWatchesTreeTable;
    @Nullable
    private final Icon icon;
    @NotNull
    private final AtomicReference<ValueState> state;
    @NotNull
    private final AtomicReference<NumberStringValue> lastValue;
    @NotNull
    private AtomicReference<NumberStringValue> max;
    @NotNull
    private AtomicReference<NumberStringValue> min;
    @NotNull
    private AtomicInteger changeCount;
    @NotNull
    private final AtomicBoolean busy;

    public LiveWatchesItem(int exprId, @NotNull LiveWatchesFormat format, @NotNull String description, @NotNull LiveWatchesTreeTable liveWatchesTreeTable) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesTreeTable), (String)"liveWatchesTreeTable");
        this.exprId = exprId;
        this.format = format;
        this.description = description;
        this.liveWatchesTreeTable = liveWatchesTreeTable;
        this.state = new AtomicReference<ValueState>(ValueState.UNCHANGED);
        this.lastValue = new AtomicReference<NoData>(new NoData(""));
        this.max = new AtomicReference<NoData>(new NoData(""));
        this.min = new AtomicReference<NoData>(new NoData(""));
        this.changeCount = new AtomicInteger(0);
        this.busy = new AtomicBoolean(false);
    }

    public final int getExprId() {
        return this.exprId;
    }

    @NotNull
    public final LiveWatchesFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull LiveWatchesFormat liveWatchesFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)liveWatchesFormat), (String)"<set-?>");
        this.format = liveWatchesFormat;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.description = string;
    }

    @NotNull
    public final LiveWatchesTreeTable getLiveWatchesTreeTable() {
        return this.liveWatchesTreeTable;
    }

    @Nullable
    public abstract LiveWatchesService.LiveItemProducer liveExpression();

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final AtomicReference<ValueState> getState() {
        return this.state;
    }

    @NotNull
    public abstract String getExpression();

    @NotNull
    public final AtomicReference<NumberStringValue> getLastValue$intellij_clion_embedded() {
        return this.lastValue;
    }

    @NotNull
    public final AtomicReference<NumberStringValue> getMax$intellij_clion_embedded() {
        return this.max;
    }

    public final void setMax$intellij_clion_embedded(@NotNull AtomicReference<NumberStringValue> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.max = atomicReference;
    }

    @NotNull
    public final AtomicReference<NumberStringValue> getMin$intellij_clion_embedded() {
        return this.min;
    }

    public final void setMin$intellij_clion_embedded(@NotNull AtomicReference<NumberStringValue> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.min = atomicReference;
    }

    @NotNull
    public final AtomicInteger getChangeCount() {
        return this.changeCount;
    }

    public final void setChangeCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.changeCount = atomicInteger;
    }

    public abstract int getSize();

    @NotNull
    public final String formatText(@NotNull AtomicReference<NumberStringValue> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        NumberStringValue numberStringValue = value.get();
        Intrinsics.checkNotNullExpressionValue((Object)numberStringValue, (String)"get(...)");
        return this.format.format$intellij_clion_embedded(numberStringValue, this.getSize());
    }

    private final boolean checkFreeAndMarkBusy() {
        return this.busy.compareAndSet(false, true);
    }

    private final void free() {
        if (!this.busy.compareAndSet(true, false)) {
            LiveWatchesItem $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LiveWatchesItem.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Possible race condition: free() called on a variable '" + this.getExpression() + "' that was not busy before");
        }
    }

    protected final void newSample(@NotNull String text, @NotNull String numberText, @Nullable String dataType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)numberText, (String)"numberText");
        this.newSample(text, (Function0<? extends NumberStringValue>)((Function0)() -> LiveWatchesItem.newSample$lambda$0(numberText, text)), dataType);
    }

    protected final void newSample(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String text = this.format.formatNumber$intellij_clion_embedded(number, this.getSize());
        this.newSample(text, (Function0<? extends NumberStringValue>)((Function0)() -> LiveWatchesItem.newSample$lambda$1(number, text)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void newSample(String text, Function0<? extends NumberStringValue> newValueOnDemand, String dataTypeUpdate) {
        try {
            if (Intrinsics.areEqual((Object)this.lastValue.get().getText(), (Object)text)) {
                if (this.state.getAndSet(ValueState.UNCHANGED) != ValueState.UNCHANGED) {
                    this.liveWatchesTreeTable.repaint();
                }
                this.liveWatchesTreeTable.historyUpdate(this.exprId, this.formatText(this.lastValue));
                return;
            }
            NumberStringValue newValue = (NumberStringValue)newValueOnDemand.invoke();
            this.lastValue.set(newValue);
            this.liveWatchesTreeTable.historyUpdate(this.exprId, this.formatText(this.lastValue));
            if (dataTypeUpdate != null) {
                this.description = dataTypeUpdate;
            }
            this.state.set(ValueState.CHANGED);
            this.changeCount.incrementAndGet();
            this.min.updateAndGet(arg_0 -> LiveWatchesItem.newSample$lambda$2(newValue, arg_0));
            this.max.updateAndGet(arg_0 -> LiveWatchesItem.newSample$lambda$3(newValue, arg_0));
        }
        finally {
            this.free();
        }
        this.liveWatchesTreeTable.repaint();
    }

    protected abstract void doSample(@NotNull LiveWatchesSubProcess var1, @NotNull CidrEvaluator var2);

    public final void sample(@NotNull LiveWatchesSubProcess debugProcess, @NotNull CidrEvaluator evaluator) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        if (this.checkFreeAndMarkBusy()) {
            this.doSample(debugProcess, evaluator);
        } else {
            this.liveWatchesTreeTable.samplingOverlap();
        }
    }

    protected final void samplingError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.liveWatchesTreeTable.historyUpdate(this.exprId, errorMessage);
        this.state.set(ValueState.ERROR);
        this.lastValue.set(new NumberStringValue(Double.NaN, errorMessage));
        this.free();
    }

    private static final NumberStringValue newSample$lambda$0(String $numberText, String $text) {
        return new NumberStringValue($numberText, $text);
    }

    private static final NumberStringValue newSample$lambda$1(Number $number, String $text) {
        return new NumberStringValue($number, $text);
    }

    private static final NumberStringValue newSample$lambda$2(NumberStringValue $newValue, NumberStringValue it) {
        return it.min($newValue);
    }

    private static final NumberStringValue newSample$lambda$3(NumberStringValue $newValue, NumberStringValue it) {
        return it.max($newValue);
    }
}

