/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesColumnInfo;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesItem;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesTreeTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.LineSeparator;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/CopyCellsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "table", "Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;", "<init>", "(Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesTreeTable;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 actions.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/CopyCellsAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n19#2:236\n11879#3,9:237\n13805#3:246\n13806#3:248\n11888#3:249\n1#4:247\n*S KotlinDebug\n*F\n+ 1 actions.kt\ncom/intellij/clion/embedded/execution/debugtargets/live/CopyCellsAction\n*L\n187#1:236\n193#1:237,9\n193#1:246\n193#1:248\n193#1:249\n193#1:247\n*E\n"})
public final class CopyCellsAction
extends DumbAwareAction {
    @NotNull
    private final LiveWatchesTreeTable table;

    public CopyCellsAction(@NotNull LiveWatchesTreeTable table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        super(CopyCellsAction::_init_$lambda$0, AllIcons.Actions.Copy);
        this.table = table;
        this.registerCustomShortcutSet(CommonShortcuts.getCopy(), (JComponent)((Object)this.table), this.table);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        switch (this.table.getSelectedRowCount()) {
            case 0: {
                e.getPresentation().setEnabled(false);
                break;
            }
            case 1: {
                e.getPresentation().setText(EmbeddedBundle.message("action.copy.cell.value.text", new Object[0]));
                break;
            }
            default: {
                e.getPresentation().setText(EmbeddedBundle.message("action.copy.cells.values.text", new Object[0]));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int selectedColumn = this.table.getSelectedColumn();
        if (selectedColumn < 0) {
            Serializable serializable;
            InputEvent $this$asSafely$iv = e.getInputEvent();
            boolean $i$f$asSafely = false;
            InputEvent inputEvent = $this$asSafely$iv;
            if (!(inputEvent instanceof MouseEvent)) {
                inputEvent = null;
            }
            if ((serializable = (MouseEvent)inputEvent) == null || (serializable = serializable.getPoint()) == null) {
                return;
            }
            Serializable point = serializable;
            selectedColumn = this.table.columnAtPoint((Point)point);
        }
        int columnIndexModel = this.table.convertColumnIndexToModel(selectedColumn);
        Object[] $i$f$asSafely = this.table.getTableModel().getColumns()[columnIndexModel];
        LiveWatchesColumnInfo liveWatchesColumnInfo = $i$f$asSafely instanceof LiveWatchesColumnInfo ? (LiveWatchesColumnInfo)$i$f$asSafely : null;
        if (liveWatchesColumnInfo == null) {
            return;
        }
        LiveWatchesColumnInfo columnInfo = liveWatchesColumnInfo;
        TreePath[] treePathArray = this.table.getTree().getSelectionPaths();
        Intrinsics.checkNotNullExpressionValue((Object)treePathArray, (String)"getSelectionPaths(...)");
        $i$f$asSafely = treePathArray;
        boolean $i$f$mapNotNull = false;
        void var8_10 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            LiveWatchesItem it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            TreePath it = (TreePath)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getLastPathComponent();
            if ((object instanceof LiveWatchesItem ? (LiveWatchesItem)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        String string = LineSeparator.getSystemLineSeparator().getSeparatorString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparatorString(...)");
        String result = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, arg_0 -> CopyCellsAction.actionPerformed$lambda$1(columnInfo, arg_0), (int)30, null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(result));
    }

    private static final String _init_$lambda$0() {
        return EmbeddedBundle.message("action.copy.cell.value.text", new Object[0]);
    }

    private static final CharSequence actionPerformed$lambda$1(LiveWatchesColumnInfo $columnInfo, LiveWatchesItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $columnInfo.getText(it);
    }
}

