/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.espidf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.execution.ExecutionException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/espidf/EspIdfProjectDescription;", "", "toolPrefix", "", "connectionScript", "", "openOcdParameters", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getToolPrefix", "()Ljava/lang/String;", "getConnectionScript", "()Ljava/util/List;", "getOpenOcdParameters", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.clion.embedded"})
public final class EspIdfProjectDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toolPrefix;
    @NotNull
    private final List<String> connectionScript;
    @NotNull
    private final String openOcdParameters;

    public EspIdfProjectDescription(@NotNull String toolPrefix, @NotNull List<String> connectionScript, @NotNull String openOcdParameters) {
        Intrinsics.checkNotNullParameter((Object)toolPrefix, (String)"toolPrefix");
        Intrinsics.checkNotNullParameter(connectionScript, (String)"connectionScript");
        Intrinsics.checkNotNullParameter((Object)openOcdParameters, (String)"openOcdParameters");
        this.toolPrefix = toolPrefix;
        this.connectionScript = connectionScript;
        this.openOcdParameters = openOcdParameters;
    }

    @NotNull
    public final String getToolPrefix() {
        return this.toolPrefix;
    }

    @NotNull
    public final List<String> getConnectionScript() {
        return this.connectionScript;
    }

    @NotNull
    public final String getOpenOcdParameters() {
        return this.openOcdParameters;
    }

    @NotNull
    public final String component1() {
        return this.toolPrefix;
    }

    @NotNull
    public final List<String> component2() {
        return this.connectionScript;
    }

    @NotNull
    public final String component3() {
        return this.openOcdParameters;
    }

    @NotNull
    public final EspIdfProjectDescription copy(@NotNull String toolPrefix, @NotNull List<String> connectionScript, @NotNull String openOcdParameters) {
        Intrinsics.checkNotNullParameter((Object)toolPrefix, (String)"toolPrefix");
        Intrinsics.checkNotNullParameter(connectionScript, (String)"connectionScript");
        Intrinsics.checkNotNullParameter((Object)openOcdParameters, (String)"openOcdParameters");
        return new EspIdfProjectDescription(toolPrefix, connectionScript, openOcdParameters);
    }

    public static /* synthetic */ EspIdfProjectDescription copy$default(EspIdfProjectDescription espIdfProjectDescription, String string, List list, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = espIdfProjectDescription.toolPrefix;
        }
        if ((n & 2) != 0) {
            list = espIdfProjectDescription.connectionScript;
        }
        if ((n & 4) != 0) {
            string2 = espIdfProjectDescription.openOcdParameters;
        }
        return espIdfProjectDescription.copy(string, list, string2);
    }

    @NotNull
    public String toString() {
        return "EspIdfProjectDescription(toolPrefix=" + this.toolPrefix + ", connectionScript=" + this.connectionScript + ", openOcdParameters=" + this.openOcdParameters + ")";
    }

    public int hashCode() {
        int result = this.toolPrefix.hashCode();
        result = result * 31 + ((Object)this.connectionScript).hashCode();
        result = result * 31 + this.openOcdParameters.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EspIdfProjectDescription)) {
            return false;
        }
        EspIdfProjectDescription espIdfProjectDescription = (EspIdfProjectDescription)other;
        if (!Intrinsics.areEqual((Object)this.toolPrefix, (Object)espIdfProjectDescription.toolPrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.connectionScript, espIdfProjectDescription.connectionScript)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.openOcdParameters, (Object)espIdfProjectDescription.openOcdParameters);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/espidf/EspIdfProjectDescription$Companion;", "", "<init>", "()V", "parse", "Lcom/intellij/clion/embedded/execution/debugtargets/espidf/EspIdfProjectDescription;", "workingDirectory", "Ljava/nio/file/Path;", "intellij.clion.embedded"})
    @SourceDebugExtension(value={"SMAP\nEspIdfProjectDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EspIdfProjectDescription.kt\ncom/intellij/clion/embedded/execution/debugtargets/espidf/EspIdfProjectDescription$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n774#2:46\n865#2,2:47\n1056#2:49\n1563#2:50\n1634#2,3:51\n*S KotlinDebug\n*F\n+ 1 EspIdfProjectDescription.kt\ncom/intellij/clion/embedded/execution/debugtargets/espidf/EspIdfProjectDescription$Companion\n*L\n33#1:46\n33#1:47,2\n33#1:49\n33#1:50\n33#1:51,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final EspIdfProjectDescription parse(@NotNull Path workingDirectory) {
            JsonObject jsonObject;
            Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
            try {
                jsonObject = JsonParser.parseString((String)Files.readString(workingDirectory.resolve("project_description.json"))).getAsJsonObject();
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof kotlin.io.NoSuchFileException || exception instanceof NoSuchFileException) {
                    throw new ExecutionException(EmbeddedBundle.message("dialog.message.project_description.json.not.found", new Object[0]), (Throwable)e);
                }
                Object[] objectArray = new Object[]{e.getClass().getSimpleName(), e.getLocalizedMessage()};
                throw new ExecutionException(EmbeddedBundle.message("dialog.message.failed.to.parse.project.description.json", objectArray), (Throwable)e);
            }
            JsonObject jsonObject2 = jsonObject;
            String fieldName = "monitor_toolprefix";
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $this$sortedBy$iv;
                Map.Entry it;
                void $this$filterTo$iv$iv;
                JsonElement jsonElement = jsonObject2.get(fieldName);
                Intrinsics.checkNotNull((Object)jsonElement);
                String toolPrefix = jsonElement.getAsString();
                fieldName = "gdbinit_files";
                Map connectionScriptMap = jsonObject2.get(fieldName).getAsJsonObject().asMap();
                Iterable $this$filter$iv = connectionScriptMap.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    Object k = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                    if (!(!StringsKt.endsWith$default((String)((String)k), (String)"_connect", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                });
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("source " + ((JsonElement)it.getValue()).getAsString());
                }
                List connectionScript = (List)destination$iv$iv;
                fieldName = "debug_arguments_openocd";
                JsonElement jsonElement2 = jsonObject2.get(fieldName);
                Intrinsics.checkNotNull((Object)jsonElement2);
                String openOcdParameters = jsonElement2.getAsString();
                Intrinsics.checkNotNull((Object)toolPrefix);
                Intrinsics.checkNotNull((Object)openOcdParameters);
                return new EspIdfProjectDescription(toolPrefix, connectionScript, openOcdParameters);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{fieldName, e.getLocalizedMessage()};
                throw new ExecutionException(EmbeddedBundle.message("dialog.message.failed.to.read.project.description", objectArray), (Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

