/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets;

import com.intellij.clion.embedded.debugger.peripheralview.SvdPanel;
import com.intellij.clion.embedded.execution.debugtargets.DebugTargetDebuggerActionsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetData;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsCounterUsagesCollector;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.GdbServerService;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.ProcessFusData;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u00060\u001aR\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\u00182\n\u0010 \u001a\u00060\u001aR\u00020\u001b2\u0006\u0010!\u001a\u00020\u000eH\u0014J\b\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "parameters", "Lcom/jetbrains/cidr/execution/RunParameters;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "backendConsoleFilterProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "", "Lcom/intellij/execution/filters/Filter;", "emulateTerminal", "", "debugTargetData", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetData;", "fusData", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ProcessFusData;", "<init>", "(Lcom/jetbrains/cidr/execution/RunParameters;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/execution/filters/TextConsoleBuilder;Lkotlin/jvm/functions/Function1;ZLcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetData;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/ProcessFusData;)V", "getDebugTargetData", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetData;", "stop", "", "doLoadTarget", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Inferior;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "driver", "gdbServerService", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/GdbServerService;", "doDisconnectTarget", "inferior", "shouldDestroy", "sessionInitialized", "createTabLayouter", "Lcom/intellij/xdebugger/ui/XDebugTabLayouter;", "Companion", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nDebugTargetProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTargetProcess.kt\ncom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n30#2,2:114\n122#3,4:116\n13#3:120\n*S KotlinDebug\n*F\n+ 1 DebugTargetProcess.kt\ncom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess\n*L\n53#1:114,2\n76#1:116,4\n111#1:120\n*E\n"})
public class DebugTargetProcess
extends CidrDebugProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebugTargetData debugTargetData;
    @NotNull
    private final ProcessFusData fusData;
    @NotNull
    private static final Logger LOG;

    public DebugTargetProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull Function1<? super Project, Filter[]> backendConsoleFilterProvider, boolean emulateTerminal, @NotNull DebugTargetData debugTargetData, @NotNull ProcessFusData fusData) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        Intrinsics.checkNotNullParameter(backendConsoleFilterProvider, (String)"backendConsoleFilterProvider");
        Intrinsics.checkNotNullParameter((Object)debugTargetData, (String)"debugTargetData");
        Intrinsics.checkNotNullParameter((Object)fusData, (String)"fusData");
        super(parameters, session, consoleBuilder, arg_0 -> DebugTargetProcess._init_$lambda$0(backendConsoleFilterProvider, arg_0), emulateTerminal);
        this.debugTargetData = debugTargetData;
        this.fusData = fusData;
    }

    @NotNull
    protected final DebugTargetData getDebugTargetData() {
        return this.debugTargetData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DebugTargetsCounterUsagesCollector.INSTANCE.stopDebugger(this.fusData);
        try {
            if (!this.debugTargetData.getPersistentSession() && !this.gdbServerService().isTerminating(this.debugTargetData.getDebugTargetUniqueId())) {
                this.gdbServerService().stop(this.debugTargetData.getDebugTargetUniqueId());
            }
        }
        finally {
            super.stop();
        }
    }

    @NotNull
    public DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DebuggerDriver.Inferior inferior = ((GDBDriver)driver).loadForRemote(this.debugTargetData.getConnectionScript(), this.debugTargetData.getName(), this.debugTargetData.getBinaryFile(), null, CollectionsKt.emptyList(), false);
        Intrinsics.checkNotNullExpressionValue((Object)inferior, (String)"loadForRemote(...)");
        return inferior;
    }

    private final GdbServerService gdbServerService() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GdbServerService> serviceClass$iv = GdbServerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GdbServerService)object;
    }

    /*
     * WARNING - void declaration
     */
    protected void doDisconnectTarget(@NotNull DebuggerDriver.Inferior inferior, boolean shouldDestroy) {
        Intrinsics.checkNotNullParameter((Object)inferior, (String)"inferior");
        if (!this.debugTargetData.getPersistentSession()) {
            void $this$getOrHandleException$iv;
            Object object;
            DebuggerDriver debuggerDriver;
            Object object2 = this;
            try {
                DebugTargetProcess $this$doDisconnectTarget_u24lambda_u240 = object2;
                boolean bl = false;
                debuggerDriver = inferior.getDriver();
                GDBDriver gDBDriver = debuggerDriver instanceof GDBDriver ? (GDBDriver)debuggerDriver : null;
                if (gDBDriver != null) {
                    GDBDriver driver = gDBDriver;
                    driver.interruptAndExecuteConsole("monitor shutdown");
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            object = LOG;
            boolean $i$f$getOrHandleException = false;
            debuggerDriver = $this$getOrHandleException$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)debuggerDriver);
            if (throwable != null) {
                Throwable e$iv = throwable;
                boolean bl = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                Throwable p0 = e$iv;
                boolean bl2 = false;
                object.warnWithDebug(p0);
            }
            if (Result.isFailure-impl((Object)debuggerDriver)) {
                // empty if block
            }
        }
        try {
            super.doDisconnectTarget(inferior, true);
        }
        catch (ExecutionException e) {
            block11: {
                block10: {
                    if (e instanceof ExecutionFinishedException) break block10;
                    String string = e.getMessage();
                    boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Remote connection closed", (boolean)false, (int)2, null) : false;
                    if (!bl) break block11;
                }
                LOG.infoWithDebug("GDB server finished after `monitor shutdown` and terminated the debug session", (Throwable)e);
            }
            throw e;
        }
    }

    public void sessionInitialized() {
        block0: {
            super.sessionInitialized();
            RunnerLayoutUi runnerLayoutUi = this.getSession().getUI();
            if (runnerLayoutUi == null || (runnerLayoutUi = runnerLayoutUi.getContentManager()) == null) break block0;
            runnerLayoutUi.addUiDataProvider(arg_0 -> DebugTargetProcess.sessionInitialized$lambda$0(this, arg_0));
        }
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = super.createTabLayouter();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugTabLayouter, (String)"createTabLayouter(...)");
        XDebugTabLayouter superLayouter = xDebugTabLayouter;
        return new XDebugTabLayouter(superLayouter, this){
            final /* synthetic */ XDebugTabLayouter $superLayouter;
            final /* synthetic */ DebugTargetProcess this$0;
            {
                this.$superLayouter = $superLayouter;
                this.this$0 = $receiver;
            }

            public void registerAdditionalContent(RunnerLayoutUi ui) {
                Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
                this.$superLayouter.registerAdditionalContent(ui);
                SvdPanel.Companion.registerPeripheralTab$default(SvdPanel.Companion, this.this$0, ui, null, 4, null);
            }
        };
    }

    private static final Filter[] _init_$lambda$0(Function1 $tmp0, Project p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Filter[])$tmp0.invoke((Object)p0);
    }

    private static final void sessionInitialized$lambda$0(DebugTargetProcess this$0, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Object object = this$0.debugTargetData.getDebugTargetUniqueId();
        sink.set(DebugTargetDebuggerActionsKt.getDEBUG_TARGET_ID(), (Object)(object instanceof String ? (String)object : null));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DebugTargetProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

