/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.custom;

import com.intellij.clion.embedded.execution.custom.CustomGdbServerConfigurationHelper;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerLauncher;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfigurationSettingsEditor;
import com.intellij.clion.embedded.execution.custom.TargetResetType;
import com.intellij.clion.embedded.execution.debugtargets.generic.GenericDebugTargetParameters;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetsCounterUsagesCollector;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.ExportableToGenericDebugTarget;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import java.util.LinkedHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGdbServerRunConfiguration
extends GdbServerRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction,
ExportableToGenericDebugTarget {
    private static final String ATTR_RESET_COMMAND = "reset-cmd";
    private static final String ATTR_RESET_AFTER_DOWNLOAD = "reset-after-download";
    private static final String ATTR_RESET_TYPE = "reset-type";
    private static final String DEFAULT_RESET_COMMAND = "monitor reset";
    private static final TargetResetType DEFAULT_RESET_TYPE = TargetResetType.AFTER_DOWNLOAD;
    private String myResetCommand = "monitor reset";
    private TargetResetType myResetType = DEFAULT_RESET_TYPE;

    public CustomGdbServerRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new CustomGdbServerRunConfigurationSettingsEditor(this.getProject(), this.getHelper());
    }

    @NotNull
    public CidrCompoundConfigurationHelper getHelper() {
        return new CustomGdbServerConfigurationHelper(this.getProject());
    }

    public void readExternal(@NotNull Element parentElement) throws InvalidDataException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        if (element != null) {
            this.myResetCommand = element.getAttributeValue(ATTR_RESET_COMMAND, DEFAULT_RESET_COMMAND);
            TargetResetType defaultResetType = DEFAULT_RESET_TYPE;
            String myResetAfterDownload = element.getAttributeValue(ATTR_RESET_AFTER_DOWNLOAD);
            if (myResetAfterDownload != null) {
                defaultResetType = Boolean.FALSE.toString().equals(myResetAfterDownload) ? TargetResetType.NEVER : TargetResetType.AFTER_DOWNLOAD;
            }
            this.myResetType = (TargetResetType)Utils.readEnumAttr((Element)element, (String)ATTR_RESET_TYPE, (Enum)defaultResetType);
        }
    }

    public void writeExternal(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        assert (element != null);
        element.setAttribute(ATTR_RESET_COMMAND, this.myResetCommand);
        element.setAttribute(ATTR_RESET_TYPE, this.myResetType.name());
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(3);
        }
        CustomGdbServerLauncher launcher = new CustomGdbServerLauncher(environment, this, this.getDebuggerData().getOrCreateDebuggerToolchain());
        return new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    @NotNull
    public String getResetCommand() {
        String string = this.myResetCommand;
        if (string == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setResetCommand(@NotNull String resetCommand) {
        if (resetCommand == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myResetCommand = resetCommand;
    }

    public TargetResetType getResetType() {
        return this.myResetType;
    }

    public void setResetType(TargetResetType resetType) {
        this.myResetType = resetType;
    }

    @NotNull
    public GenericDebugTargetParameters exportToGenericDebugTargetParameters(@NotNull Project project) {
        if (project == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(6);
        }
        GenericDebugTargetParameters parameters = new GenericDebugTargetParameters();
        parameters.setName(this.getName());
        parameters.setDebuggerData(ExportableToGenericDebugTarget.copyDebuggerData((DebuggerData)this.getDebuggerData()));
        parameters.setGdbServerEnabled(true);
        parameters.setGdbServerParameters(Strings.notNullize((String)this.getProgramParameters()));
        parameters.setGdbServerExecutable(Strings.notNullize((String)this.getServerExecutable()));
        parameters.setGdbServerWorkingDirectory(Strings.notNullize((String)this.getWorkingDirectory()));
        parameters.setGdbServerEnvironmentFile(Strings.notNullize((String)this.getEnvironmentFile()));
        parameters.setGdbServerEnvVariables(new LinkedHashMap<String, String>(this.getEnvs()));
        parameters.setGdbServerEnvPassParent(this.isPassParentEnvs());
        parameters.setDownloadType(this.getDownloadType());
        parameters.setResetCommand(this.getResetCommand());
        switch (this.getResetType()) {
            case NEVER: {
                parameters.setResetBeforeLoad(false);
                parameters.setResetAfterLoad(false);
                break;
            }
            case AFTER_DOWNLOAD: {
                parameters.setResetBeforeLoad(false);
                parameters.setResetAfterLoad(true);
                break;
            }
            case BEFORE_DOWNLOAD: {
                parameters.setResetBeforeLoad(true);
                parameters.setResetAfterLoad(false);
                break;
            }
            case BOTH_TIMES: {
                parameters.setResetBeforeLoad(true);
                parameters.setResetAfterLoad(true);
            }
        }
        parameters.setGdbConnectionExtendedMode(false);
        parameters.setGdbUseConnectionCustomScript(false);
        parameters.setGdbRemoteString(this.getGdbRemoteString());
        parameters.setWarmUpMs(this.getWarmUpMs());
        parameters.setConsoleEnabled(false);
        DebugTargetsCounterUsagesCollector.logConvertToGeneric((DebugTargetsCounterUsagesCollector.SourceConvertedToGenericType)DebugTargetsCounterUsagesCollector.SourceConvertedToGenericType.GDBSERVER_RUN_CONFIGURATION);
        GenericDebugTargetParameters genericDebugTargetParameters = parameters;
        if (genericDebugTargetParameters == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(7);
        }
        return genericDebugTargetParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetCommand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "exportToGenericDebugTargetParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setResetCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportToGenericDebugTargetParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

