/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.execution.OpenOcdConfiguration;
import com.intellij.clion.embedded.execution.OpenOcdGdbProcess;
import com.intellij.clion.embedded.execution.custom.McuResetAction;
import com.intellij.clion.embedded.execution.ui.EmbeddedMessages;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

class OpenOcdLauncher
extends GdbServerLauncher {
    OpenOcdLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull OpenOcdConfiguration configuration, @NotNull CPPToolchains.Toolchain debuggerToolchain) {
        if (executionEnvironment == null) {
            OpenOcdLauncher.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            OpenOcdLauncher.$$$reportNull$$$0(1);
        }
        if (debuggerToolchain == null) {
            OpenOcdLauncher.$$$reportNull$$$0(2);
        }
        super(executionEnvironment, (GdbServerRunConfiguration)configuration, debuggerToolchain);
    }

    @NotNull
    public OpenOcdConfiguration getConfiguration() {
        OpenOcdConfiguration openOcdConfiguration = (OpenOcdConfiguration)super.getConfiguration();
        if (openOcdConfiguration == null) {
            OpenOcdLauncher.$$$reportNull$$$0(3);
        }
        return openOcdConfiguration;
    }

    @NotNull
    public ProcessHandler createProcess(@NotNull CommandLineState commandLineState) throws ExecutionException {
        if (commandLineState == null) {
            OpenOcdLauncher.$$$reportNull$$$0(4);
        }
        OpenOcdConfiguration configuration = this.getConfiguration();
        File openOcdBinary = new File(configuration.getServerExecutable());
        File runFile = (File)this.getRunFileAndEnvironment().getFirst();
        if (!runFile.exists()) {
            throw new ExecutionException(EmbeddedBundle.message("openocd.invalid.run.file", runFile.getPath()));
        }
        if (StringUtil.isEmpty((String)configuration.getBoardConfigFile())) {
            throw new ExecutionException(EmbeddedBundle.message("openocd.board.config.not.defined", new Object[0]));
        }
        File ocdScripts = OpenOcdConfiguration.requireAndReport(this.getProject(), OpenOcdConfiguration.findOcdScripts(openOcdBinary));
        String command = "program \"" + runFile.getAbsolutePath().replace(File.separatorChar, '/') + "\"";
        GeneralCommandLine commandLine = new PtyCommandLine().withExePath(openOcdBinary.getAbsolutePath()).withWorkingDirectory(openOcdBinary.getParentFile().toPath()).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withParameters(new String[]{"-s", ocdScripts.getAbsolutePath(), "-f", configuration.getBoardConfigFile()}).withParameters(new String[]{"-c", "tcl_port disabled", "-c", "gdb_port disabled", "-c", "tcl_port disabled"}).withParameters(new String[]{"-c", command, "-c", "reset", "-c", "shutdown"});
        OSProcessHandler osProcessHandler = new OSProcessHandler(commandLine);
        osProcessHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getExitCode() == 0) {
                    EmbeddedMessages.showSuccessfulDownloadNotification(OpenOcdLauncher.this.getProject());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/embedded/execution/OpenOcdLauncher$1", "processTerminated"));
            }
        });
        OSProcessHandler oSProcessHandler = osProcessHandler;
        if (oSProcessHandler == null) {
            OpenOcdLauncher.$$$reportNull$$$0(5);
        }
        return oSProcessHandler;
    }

    @NotNull
    protected String getGdbServerParameters(@NotNull GdbServerRunConfiguration configuration) throws ExecutionException {
        String resetCommand;
        String symbolFilePath;
        if (configuration == null) {
            OpenOcdLauncher.$$$reportNull$$$0(6);
        }
        OpenOcdConfiguration ocdConfiguration = (OpenOcdConfiguration)configuration;
        File openOcdBinary = new File(configuration.getServerExecutable());
        Object commandLine = String.format(Locale.ROOT, "-c \"tcl_port disabled\"  -c \"gdb_port %d\"  -c \"telnet_port %d\" -s \"%s\" -f \"%s\"", ocdConfiguration.getGdbPort(), ocdConfiguration.getTelnetPort(), OpenOcdConfiguration.findOcdScripts(openOcdBinary).getAbsolutePath(), ocdConfiguration.getBoardConfigFile());
        File fileToLoad = (File)this.getRunFileAndEnvironment().getFirst();
        switch (configuration.getDownloadType()) {
            case ALWAYS: {
                String string = fileToLoad.getAbsolutePath();
                break;
            }
            case UPDATED_ONLY: {
                String string;
                if (!Utils.isLatestUploaded((File)fileToLoad)) {
                    string = fileToLoad.getAbsolutePath();
                    break;
                }
                string = null;
                break;
            }
            default: {
                String string = symbolFilePath = null;
            }
        }
        if (symbolFilePath != null) {
            String fileParam = symbolFilePath.replace(File.separatorChar, '/');
            commandLine = (String)commandLine + String.format(Locale.ROOT, " -c \"program %s\"", fileParam);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(resetCommand = this.getConfiguration().getResetType().getCommand()))) {
            commandLine = (String)commandLine + String.format(Locale.ROOT, " -c \"%s\"", resetCommand);
        }
        Object object = commandLine = (String)commandLine + " -c \"echo (((READY)))\"";
        if (object == null) {
            OpenOcdLauncher.$$$reportNull$$$0(7);
        }
        return object;
    }

    @NotNull
    protected OpenOcdGdbProcess createGdbServerProcess(@NotNull RunParameters runParameters, @NotNull CidrRemoteDebugParameters remoteParameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        if (runParameters == null) {
            OpenOcdLauncher.$$$reportNull$$$0(8);
        }
        if (remoteParameters == null) {
            OpenOcdLauncher.$$$reportNull$$$0(9);
        }
        if (session == null) {
            OpenOcdLauncher.$$$reportNull$$$0(10);
        }
        if (consoleBuilder == null) {
            OpenOcdLauncher.$$$reportNull$$$0(11);
        }
        EmbeddedUsagesCollector.triggerGdbServerRun(this.getProject(), "openocd");
        return new OpenOcdGdbProcess(runParameters, remoteParameters, session, consoleBuilder);
    }

    protected void collectAdditionalActions(@NotNull CommandLineState commandLineState, @NotNull ProcessHandler processHandler2, @NotNull ExecutionConsole console, @NotNull List<? super AnAction> actions) throws ExecutionException {
        if (commandLineState == null) {
            OpenOcdLauncher.$$$reportNull$$$0(12);
        }
        if (processHandler2 == null) {
            OpenOcdLauncher.$$$reportNull$$$0(13);
        }
        if (console == null) {
            OpenOcdLauncher.$$$reportNull$$$0(14);
        }
        if (actions == null) {
            OpenOcdLauncher.$$$reportNull$$$0(15);
        }
        super.collectAdditionalActions(commandLineState, processHandler2, console, actions);
        McuResetAction.addResetMcuAction(actions, processHandler2, "monitor reset halt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerToolchain";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/OpenOcdLauncher";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteParameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/OpenOcdLauncher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGdbServerParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGdbServerParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGdbServerProcess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

