/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.debugtargets.st.STLinkDebugTargetEditor;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0003\u001a\u000e\u0010\u000b\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0086@\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0086@\u00a2\u0006\u0002\u0010\f\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"DEFAULT_OPENOCD_LOCATION", "Ljava/nio/file/Path;", "DEFAULT_STM32CUBEMX_LOCATION", "STM32CUBECLT_BASE_LOCATION", "STM32CUBECLT_BASE_LINUX_ALTERNATIVE", "getSTM32CUBECLT_BASE_LINUX_ALTERNATIVE", "()Ljava/nio/file/Path;", "findExecutableInPath", "", "name", "defaultPath", "detectOpenOCD", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "detectSTM32CubeMX", "detectSTM32CubeCLTFromEnv", "detectSTM32CubeCLT", "intellij.clion.embedded"})
public final class EmbeddedSettingsDetectionKt {
    @JvmField
    @NotNull
    public static final Path DEFAULT_OPENOCD_LOCATION;
    @JvmField
    @NotNull
    public static final Path DEFAULT_STM32CUBEMX_LOCATION;
    @JvmField
    @NotNull
    public static final Path STM32CUBECLT_BASE_LOCATION;
    @NotNull
    private static final Path STM32CUBECLT_BASE_LINUX_ALTERNATIVE;

    @NotNull
    public static final Path getSTM32CUBECLT_BASE_LINUX_ALTERNATIVE() {
        return STM32CUBECLT_BASE_LINUX_ALTERNATIVE;
    }

    @Contract(value="_, !null -> !null")
    private static final String findExecutableInPath(String name, String defaultPath) {
        File file;
        if (SystemInfo.isWindows) {
            return PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)name, (String)defaultPath);
        }
        File file2 = file = PathEnvironmentVariableUtil.findInPath((String)name);
        return file2 == null ? defaultPath : file2.getAbsolutePath();
    }

    @Nullable
    public static final Object detectOpenOCD(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String string = ((Object)EmbeddedSettingsDetectionKt.DEFAULT_OPENOCD_LOCATION).toString();
                        String string2 = EmbeddedSettingsDetectionKt.access$findExecutableInPath("openocd", string);
                        Intrinsics.checkNotNull((Object)string2);
                        Path path = Paths.get(string2, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        return path;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public static final Object detectSTM32CubeMX(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (Files.isExecutable(EmbeddedSettingsDetectionKt.DEFAULT_STM32CUBEMX_LOCATION)) {
                            return EmbeddedSettingsDetectionKt.DEFAULT_STM32CUBEMX_LOCATION;
                        }
                        if (OS.CURRENT == OS.Windows) {
                            Path path = Paths.get("C:\\Program Files\\STMicroelectronics\\STM32Cube\\STM32CubeMX\\STM32CubeMX.exe", new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                            Path fallback = path;
                            if (Files.isExecutable(fallback)) {
                                return fallback;
                            }
                        }
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final Path detectSTM32CubeCLTFromEnv() {
        String fromEnv = EnvironmentUtil.getValue((String)"STM32CLT_PATH");
        if (fromEnv != null) {
            Path path = Paths.get(fromEnv, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        String fromPath = EmbeddedSettingsDetectionKt.findExecutableInPath(STLinkDebugTargetEditor.Companion.getGDBSERVER_EXECUTABLE(), null);
        if (fromPath != null) {
            Path path = Paths.get(fromPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    @Nullable
    public static final Object detectSTM32CubeCLT(@NotNull Continuation<? super Path> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        T element$iv;
                        LinkOption[] linkOptionArray;
                        Path it;
                        Iterable $this$flatMapTo$iv$iv;
                        Path it2;
                        Iterable $this$filterTo$iv$iv;
                        List list;
                        Path fromEnv;
                        ResultKt.throwOnFailure((Object)$result);
                        Path path = fromEnv = EmbeddedSettingsDetectionKt.access$detectSTM32CubeCLTFromEnv();
                        if (path != null) {
                            return path;
                        }
                        List $this$invokeSuspend_u24lambda_u240 = list = CollectionsKt.createListBuilder();
                        boolean $i$a$-buildList-EmbeddedSettingsDetectionKt$detectSTM32CubeCLT$2$baseLocations$22 = false;
                        $this$invokeSuspend_u24lambda_u240.add(EmbeddedSettingsDetectionKt.STM32CUBECLT_BASE_LOCATION);
                        if (OS.CURRENT == OS.Linux) {
                            $this$invokeSuspend_u24lambda_u240.add(EmbeddedSettingsDetectionKt.getSTM32CUBECLT_BASE_LINUX_ALTERNATIVE());
                        }
                        List baseLocations = CollectionsKt.build((List)list);
                        Iterable iterable = baseLocations;
                        boolean $i$f$filter = false;
                        Iterable $i$a$-buildList-EmbeddedSettingsDetectionKt$detectSTM32CubeCLT$2$baseLocations$22 = iterable;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it2 = (Path)element$iv$iv;
                            boolean bl = false;
                            LinkOption[] linkOptionArray2 = new LinkOption[]{};
                            if (!Files.isDirectory(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        boolean $i$f$flatMap = false;
                        $this$filterTo$iv$iv = iterable2;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            it2 = (Path)element$iv$iv;
                            boolean bl = false;
                            Iterable list$iv$iv = PathsKt.listDirectoryEntries$default((Path)it2, null, (int)1, null);
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        Iterable iterable3 = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$flatMapTo$iv$iv = iterable3;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it2 = (Path)element$iv$iv;
                            boolean bl = false;
                            String string = PathsKt.getName((Path)it2).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                            if (!StringsKt.startsWith$default((String)string, (String)"stm32cubeclt", (boolean)false, (int)2, null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable iterable4 = (List)destination$iv$iv;
                        boolean $i$f$firstOrNull = false;
                        Iterator<T> iterator = iterable4.iterator();
                        do {
                            if (!iterator.hasNext()) return null;
                            element$iv = iterator.next();
                            it = (Path)element$iv;
                            boolean bl = false;
                            linkOptionArray = new LinkOption[]{};
                        } while (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
                        Object v4 = element$iv;
                        return v4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ String access$findExecutableInPath(String name, String defaultPath) {
        return EmbeddedSettingsDetectionKt.findExecutableInPath(name, defaultPath);
    }

    public static final /* synthetic */ Path access$detectSTM32CubeCLTFromEnv() {
        return EmbeddedSettingsDetectionKt.detectSTM32CubeCLTFromEnv();
    }

    static {
        Path path;
        Path path2;
        Path path3;
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: 
            case 2: {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                Path path4 = Paths.get(string, new String[0]);
                path3 = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                break;
            }
            default: {
                Path path5 = Paths.get("/usr/bin/openocd", new String[0]);
                path3 = path5;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
            }
        }
        DEFAULT_OPENOCD_LOCATION = path3;
        OS oS2 = OS.CURRENT;
        switch (oS2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS2.ordinal()]) {
            case 1: {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                Path path6 = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
                Path path7 = path6.resolve("AppData\\Local\\Programs\\STM32CubeMX\\STM32CubeMX.exe");
                path2 = path7;
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
                break;
            }
            case 2: {
                Path path8 = Paths.get("/Applications/STMicroelectronics/STM32CubeMX.app/Contents/Resources/STM32CubeMX", new String[0]);
                path2 = path8;
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"get(...)");
                break;
            }
            default: {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                Path path9 = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"get(...)");
                Path path10 = path9.resolve("STM32CubeMX/STM32CubeMX");
                path2 = path10;
                Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"resolve(...)");
            }
        }
        DEFAULT_STM32CUBEMX_LOCATION = path2;
        OS oS3 = OS.CURRENT;
        switch (oS3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS3.ordinal()]) {
            case 1: {
                Path path11 = Paths.get("C:\\ST", new String[0]);
                path = path11;
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"get(...)");
                break;
            }
            case 2: {
                Path path12 = Paths.get("/opt/ST", new String[0]);
                path = path12;
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"get(...)");
                break;
            }
            default: {
                Path path13 = Paths.get("/opt/st", new String[0]);
                path = path13;
                Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"get(...)");
            }
        }
        STM32CUBECLT_BASE_LOCATION = path;
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        String string2 = string;
        String[] stringArray = new String[]{"st"};
        Path path14 = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"get(...)");
        STM32CUBECLT_BASE_LINUX_ALTERNATIVE = path14;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

