/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.ui.EmbeddedSettingsUI;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class EmbeddedSettingsConfigurable
implements SearchableConfigurable {
    private EmbeddedSettingsUI settingsUI = null;

    @NotNull
    public String getId() {
        return "com.jetbrains.cidr.embedded.config";
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.EmbeddedSettingsConfigurable.display.name", (Object[])new Object[0]);
    }

    public boolean isModified() {
        return this.settingsUI.isModified();
    }

    public void apply() throws ConfigurationException {
        this.settingsUI.validate();
        this.settingsUI.apply();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.settingsUI);
        this.settingsUI = null;
    }

    public JComponent createComponent() {
        this.settingsUI = new EmbeddedSettingsUI();
        Disposer.register((Disposable)EmbeddedSettingsState.getInstance(), (Disposable)this.settingsUI);
        return this.settingsUI.createPanel();
    }

    public void reset() {
        this.settingsUI.reset();
        try {
            this.settingsUI.validate();
        }
        catch (ConfigurationException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
        }
    }

    public String getHelpTopic() {
        return "settings.embeddedtools";
    }
}

