/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.debugger.peripheralview;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.debugger.peripheralview.PeripheralViewUsagesCollector;
import com.intellij.clion.embedded.debugger.peripheralview.SvdField;
import com.intellij.clion.embedded.debugger.peripheralview.SvdRegister;
import com.intellij.clion.embedded.debugger.peripheralview.SvdTreeTable;
import com.intellij.clion.embedded.debugger.peripheralview.SvdValue;
import com.intellij.clion.embedded.debugger.peripheralview.SvdValueCellEditor;
import com.intellij.clion.embedded.debugger.peripheralview.SvdValueCellEditorKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.concurrent.CancellationException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\b\u0004*\u000247\u0018\u00002\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J6\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0002J\u000e\u0010 \u001a\u00020\u0018*\u0004\u0018\u00010!H\u0002J\u0012\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010!H\u0016J\u0014\u0010$\u001a\u00020\u000f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0012\u0010&\u001a\u00020\u00182\b\b\u0002\u0010'\u001a\u00020\u0018H\u0002J\b\u0010(\u001a\u00020\u0018H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J6\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010*2\u0006\u00101\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0018\u00010\tR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00105R\u0010\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00108\u00a8\u0006:"}, d2={"Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "myTable", "Lcom/intellij/clion/embedded/debugger/peripheralview/SvdTreeTable;", "myDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/intellij/clion/embedded/debugger/peripheralview/SvdTreeTable;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myUnderlayEditor", "Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$AbstractSvdValueEditor;", "errorComponent", "Lcom/intellij/ui/components/JBTextField;", "createBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "showError", "", "message", "", "position", "Lcom/intellij/ui/awt/RelativePoint;", "focusComponent", "Ljavax/swing/JComponent;", "outerComponent", "colored", "", "showSelectedError", "getValueOnRow", "Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValue;", "row", "", "getSelectedValue", "getEditingValue", "causesEdit", "Ljava/util/EventObject;", "isCellEditable", "anEvent", "writeRegisterToMemory", "svdValue", "doStopCellEditing", "forced", "stopCellEditing", "getCellEditorValue", "", "switchUnderlayEditor", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "isSelected", "column", "numericCellEditor", "com/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$numericCellEditor$1", "Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$numericCellEditor$1;", "enumCellEditor", "com/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$enumCellEditor$1", "Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$enumCellEditor$1;", "AbstractSvdValueEditor", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nSvdValueCellEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvdValueCellEditor.kt\ncom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,340:1\n19#2:341\n19#2:342\n*S KotlinDebug\n*F\n+ 1 SvdValueCellEditor.kt\ncom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor\n*L\n103#1:341\n106#1:342\n*E\n"})
public final class SvdValueCellEditor
extends AbstractTableCellEditor {
    @NotNull
    private final SvdTreeTable myTable;
    @NotNull
    private final CidrDebugProcess myDebugProcess;
    @Nullable
    private AbstractSvdValueEditor myUnderlayEditor;
    @NotNull
    private final JBTextField errorComponent;
    @NotNull
    private final numericCellEditor.1 numericCellEditor;
    @NotNull
    private final enumCellEditor.1 enumCellEditor;

    /*
     * WARNING - void declaration
     */
    public SvdValueCellEditor(@NotNull SvdTreeTable myTable, @NotNull CidrDebugProcess myDebugProcess) {
        void $this$errorComponent_u24lambda_u240;
        JBTextField jBTextField;
        Intrinsics.checkNotNullParameter((Object)((Object)myTable), (String)"myTable");
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        this.myTable = myTable;
        this.myDebugProcess = myDebugProcess;
        JBTextField jBTextField2 = jBTextField = new JBTextField();
        SvdValueCellEditor svdValueCellEditor = this;
        boolean bl = false;
        $this$errorComponent_u24lambda_u240.setEditable(false);
        $this$errorComponent_u24lambda_u240.setBorder(null);
        svdValueCellEditor.errorComponent = jBTextField;
        this.numericCellEditor = new AbstractSvdValueEditor(this){
            private final JBTextField myTextField;
            private final Font myTextFieldFont;
            private final Border myTextFieldBorder;
            final /* synthetic */ SvdValueCellEditor this$0;
            {
                this.this$0 = $receiver;
                this.myTextField = new JBTextField();
                this.myTextFieldFont = new Font("JetBrains Mono", 0, this.myTextField.getFont().getSize());
                this.myTextFieldBorder = this.myTextField.getBorder();
                this.myTextField.setFont(this.myTextFieldFont);
                this.myTextField.addActionListener(arg_0 -> numericCellEditor.1._init_$lambda$0($receiver, arg_0));
                this.myTextField.getDocument().addDocumentListener((DocumentListener)this.getTextChangeListener());
            }

            public void showEditingError(@Nls String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                SvdValueCellEditor.showError$default(this.this$0, message, new RelativePoint((Component)this.myTextField, this.myTextField.getCaret().getMagicCaretPosition()), (JComponent)this.myTextField, null, false, 24, null);
            }

            public Object getCellEditorValue() {
                String string = this.myTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return SvdValueCellEditorKt.access$decodeLongOrNull(string);
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                SvdValue svdValue = SvdValueCellEditor.access$getValueOnRow(this.this$0, row);
                if (svdValue == null) {
                    return null;
                }
                SvdValue svdValue2 = svdValue;
                this.myTextField.setText(!SvdValueCellEditorKt.access$getRegister(svdValue2).isFailed() ? svdValue2.getDisplayValue() : "");
                this.myTextField.setBorder(this.myTextFieldBorder);
                this.setWasChanged(false);
                return (Component)this.myTextField;
            }

            private static final void _init_$lambda$0(SvdValueCellEditor this$0, ActionEvent it) {
                SvdValueCellEditor.access$doStopCellEditing(this$0, true);
            }
        };
        this.enumCellEditor = new AbstractSvdValueEditor(this){
            private final ComboBox<String> myComboBox;
            private final Border myComboBoxBorder;
            private final JTextField myEditorTextField;
            private final Font myEditorTextFieldFont;
            final /* synthetic */ SvdValueCellEditor this$0;
            {
                this.this$0 = $receiver;
                this.myComboBox = new ComboBox();
                this.myComboBoxBorder = this.myComboBox.getBorder();
                Component component2 = this.myComboBox.getEditor().getEditorComponent();
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JTextField");
                this.myEditorTextField = (JTextField)component2;
                this.myEditorTextFieldFont = new Font("JetBrains Mono", 0, this.myEditorTextField.getFont().getSize());
                this.myComboBox.setEditable(true);
                ActionListener actionListener = arg_0 -> enumCellEditor.1._init_$lambda$0($receiver, arg_0);
                this.myComboBox.addActionListener(actionListener);
                this.myEditorTextField.addActionListener(actionListener);
                this.myEditorTextField.setFont(this.myEditorTextFieldFont);
                this.myEditorTextField.getDocument().addDocumentListener((DocumentListener)this.getTextChangeListener());
            }

            /*
             * Enabled aggressive block sorting
             */
            public Object getCellEditorValue() {
                Long l;
                SvdField svdField;
                SvdValue $this$asSafely$iv = SvdValueCellEditor.access$getEditingValue(this.this$0);
                boolean $i$f$asSafely = false;
                SvdValue svdValue = $this$asSafely$iv;
                if (!(svdValue instanceof SvdField)) {
                    svdValue = null;
                }
                if ((svdField = (SvdField)svdValue) != null) {
                    String string = this.myEditorTextField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Long l2 = SvdValueCellEditorKt.access$tryParseWriteEnumValue(svdField, string);
                    if (l2 != null) {
                        l = l2;
                        return l;
                    }
                }
                String string = this.myEditorTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                l = SvdValueCellEditorKt.access$decodeLongOrNull(string);
                return l;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                SvdValue svdValue;
                ComboBoxModel comboBoxModel = this.myComboBox.getModel();
                Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type javax.swing.DefaultComboBoxModel<kotlin.String>");
                DefaultComboBoxModel model = (DefaultComboBoxModel)comboBoxModel;
                model.removeAllElements();
                SvdValue svdValue2 = SvdValueCellEditor.access$getValueOnRow(this.this$0, row);
                if (svdValue2 == null) {
                    return null;
                }
                SvdValue $this$asSafely$iv = svdValue = svdValue2;
                boolean $i$f$asSafely = false;
                SvdValue svdValue3 = $this$asSafely$iv;
                if (!(svdValue3 instanceof SvdField)) {
                    svdValue3 = null;
                }
                SvdField svdField = (SvdField)svdValue3;
                if (svdField == null) {
                    return null;
                }
                SvdField field = svdField;
                String[] stringArray = field.getSvdEnumWrite().getDisplayValues();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getDisplayValues(...)");
                model.addAll(ArraysKt.toList((Object[])stringArray));
                this.myEditorTextField.setText(!SvdValueCellEditorKt.access$getRegister(svdValue).isFailed() ? ((SvdField)svdValue).getDisplayValue() : "");
                this.myComboBox.setBorder(this.myComboBoxBorder);
                this.myComboBox.setSelectedItem((Object)this.myEditorTextField.getText());
                this.setWasChanged(false);
                return (Component)this.myComboBox;
            }

            public void showEditingError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                SvdValueCellEditor.showError$default(this.this$0, message, new RelativePoint((Component)this.myEditorTextField, this.myEditorTextField.getCaret().getMagicCaretPosition()), this.myEditorTextField, (JComponent)this.myComboBox, false, 16, null);
            }

            private static final void _init_$lambda$0(SvdValueCellEditor this$0, ActionEvent it) {
                SvdValueCellEditor.access$doStopCellEditing(this$0, true);
            }
        };
    }

    private final Balloon createBalloon() {
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)this.errorComponent).setHideOnAction(true).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnCloseClick(true).setHideOnFrameResize(true).setRequestFocus(false).setBorderColor(JBColor.border()).setFillColor(this.errorComponent.getBackground()).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        return balloon;
    }

    private final void showError(@Nls String message, RelativePoint position, JComponent focusComponent, JComponent outerComponent, boolean colored) {
        this.errorComponent.setText(message);
        if (colored) {
            outerComponent.setBorder(new LineBorder((Color)JBColor.RED));
        }
        Balloon balloon = this.createBalloon();
        FocusAdapter listener2 = new FocusAdapter(outerComponent, balloon){
            final /* synthetic */ JComponent $outerComponent;
            final /* synthetic */ Balloon $balloon;
            {
                this.$outerComponent = $outerComponent;
                this.$balloon = $balloon;
            }

            public void focusLost(FocusEvent e) {
                FocusEvent focusEvent = e;
                if (UIUtil.isAncestor((Component)this.$outerComponent, (Component)(focusEvent != null ? focusEvent.getOppositeComponent() : null))) {
                    return;
                }
                this.$balloon.hide();
            }
        };
        balloon.addListener(new JBPopupListener(focusComponent, listener2){
            final /* synthetic */ JComponent $focusComponent;
            final /* synthetic */ showError.listener.1 $listener;
            {
                this.$focusComponent = $focusComponent;
                this.$listener = $listener;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$focusComponent.removeFocusListener(this.$listener);
            }
        });
        focusComponent.addFocusListener(listener2);
        balloon.show(position, Balloon.Position.above);
    }

    static /* synthetic */ void showError$default(SvdValueCellEditor svdValueCellEditor, String string, RelativePoint relativePoint, JComponent jComponent, JComponent jComponent2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            jComponent2 = jComponent;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        svdValueCellEditor.showError(string, relativePoint, jComponent, jComponent2, bl);
    }

    private final void showSelectedError(@Nls String message) {
        Point relativePos = this.myTable.getCellRect(this.myTable.getSelectedRow(), 1, true).getLocation();
        SvdValueCellEditor.showError$default(this, message, new RelativePoint((Component)((Object)this.myTable), relativePos), (JComponent)((Object)this.myTable), null, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final SvdValue<?> getValueOnRow(int row) {
        SvdValue svdValue;
        Object object;
        TreePath treePath;
        TreeTableTree treeTableTree = this.myTable.getTree();
        if (treeTableTree != null && (treePath = treeTableTree.getPathForRow(row)) != null && (object = treePath.getLastPathComponent()) != null) {
            void $this$asSafely$iv;
            Object object2 = object;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof SvdValue)) {
                v0 = null;
            }
            svdValue = v0;
        } else {
            svdValue = null;
        }
        return svdValue;
    }

    private final SvdValue<?> getSelectedValue() {
        Object $this$asSafely$iv = this.myTable.getTree().getLastSelectedPathComponent();
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof SvdValue)) {
            object = null;
        }
        return (SvdValue)object;
    }

    private final SvdValue<?> getEditingValue() {
        int editingRow = this.myTable.getEditingRow();
        if (editingRow < 0) {
            return null;
        }
        return this.getValueOnRow(editingRow);
    }

    private final boolean causesEdit(EventObject $this$causesEdit) {
        return $this$causesEdit instanceof MouseEvent ? SwingUtilities.isLeftMouseButton((MouseEvent)$this$causesEdit) && ((MouseEvent)$this$causesEdit).getClickCount() >= 2 : true;
    }

    public boolean isCellEditable(@Nullable EventObject anEvent) {
        if (!this.causesEdit(anEvent)) {
            return false;
        }
        if (!this.myDebugProcess.getSession().isSuspended()) {
            String string = EmbeddedBundle.message("svd.register.not.suspended.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showSelectedError(string);
            return false;
        }
        SvdValue<?> selectedValue = this.getSelectedValue();
        if (selectedValue == null) {
            return false;
        }
        if (!selectedValue.getAccess().isWritable()) {
            String string = EmbeddedBundle.message("svd.register.not.writable.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showSelectedError(string);
            return false;
        }
        if (SvdValueCellEditorKt.access$getRegister(selectedValue).isWritePending()) {
            String string = EmbeddedBundle.message("svd.register.write.already.pending.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showSelectedError(string);
            return false;
        }
        return true;
    }

    private final void writeRegisterToMemory(SvdValue<?> svdValue) {
        SvdRegister register = SvdValueCellEditorKt.access$getRegister(svdValue);
        CoroutineScope coroutineScope = this.myDebugProcess.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, register, svdValue, null){
            int label;
            final /* synthetic */ SvdValueCellEditor this$0;
            final /* synthetic */ SvdRegister $register;
            final /* synthetic */ SvdValue<?> $svdValue;
            {
                this.this$0 = $receiver;
                this.$register = $register;
                this.$svdValue = $svdValue;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CidrDebuggerCommandExecutor cidrDebuggerCommandExecutor = SvdValueCellEditor.access$getMyDebugProcess$p(this.this$0).getDebuggerCommandExecutor();
                        Intrinsics.checkNotNullExpressionValue((Object)cidrDebuggerCommandExecutor, (String)"getDebuggerCommandExecutor(...)");
                        this.label = 1;
                        Object object2 = CidrDebuggerCommandExecutor.executeCommandSuspend$default((CidrDebuggerCommandExecutor)cidrDebuggerCommandExecutor, (boolean)false, (boolean)false, null, (Function3)((Function3)new Function3<CoroutineScope, DebuggerDriver, Continuation<? super Unit>, Object>(this.$register, this.this$0, this.$svdValue, null){
                            Object L$1;
                            Object L$2;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SvdRegister $register;
                            final /* synthetic */ SvdValueCellEditor this$0;
                            final /* synthetic */ SvdValue<?> $svdValue;
                            {
                                this.$register = $register;
                                this.this$0 = $receiver;
                                this.$svdValue = $svdValue;
                                super(3, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (DebuggerDriver)this.L$0;
                                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        success = new Ref.BooleanRef();
                                        driver.writeMemory(this.$register.getAddress(), this.$register.getBytes());
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)driver);
                                        this.L$1 = success;
                                        this.label = 1;
                                        v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$register, success, null){
                                            int label;
                                            final /* synthetic */ SvdRegister $register;
                                            final /* synthetic */ Ref.BooleanRef $success;
                                            {
                                                this.$register = $register;
                                                this.$success = $success;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.$register.markWriteSuccess();
                                                        this.$success.element = true;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        ** if (v0 != var5_3) goto lbl16
lbl15:
                                        // 1 sources

                                        return var5_3;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl40
                                    }
                                    case 1: {
                                        success = (Ref.BooleanRef)this.L$1;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                            ** GOTO lbl40
                                        }
                                        catch (Throwable error) {
                                            if (error instanceof CancellationException || error instanceof ProcessCanceledException) {
                                                throw error;
                                            }
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)driver);
                                            this.L$1 = success;
                                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)error);
                                            this.label = 2;
                                            v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$register, error, success, null){
                                                int label;
                                                final /* synthetic */ SvdRegister $register;
                                                final /* synthetic */ Throwable $error;
                                                final /* synthetic */ Ref.BooleanRef $success;
                                                {
                                                    this.$register = $register;
                                                    this.$error = $error;
                                                    this.$success = $success;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            String string = this.$error.getLocalizedMessage();
                                                            if (string == null) {
                                                                String string2 = EmbeddedBundle.message("svd.register.write.failed", new Object[0]);
                                                                string = string2;
                                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                                            }
                                                            this.$register.markNoValue(string, false);
                                                            this.$success.element = false;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v1 == var5_3) {
                                                return var5_3;
                                            }
                                            ** GOTO lbl40
                                        }
                                    }
                                    case 2: {
                                        error = (Throwable)this.L$2;
                                        success = (Ref.BooleanRef)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl40:
                                        // 4 sources

                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)driver);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)success);
                                        this.L$2 = null;
                                        this.label = 3;
                                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$svdValue, this.$register, success, null){
                                            int label;
                                            final /* synthetic */ SvdValueCellEditor this$0;
                                            final /* synthetic */ SvdValue<?> $svdValue;
                                            final /* synthetic */ SvdRegister $register;
                                            final /* synthetic */ Ref.BooleanRef $success;
                                            {
                                                this.this$0 = $receiver;
                                                this.$svdValue = $svdValue;
                                                this.$register = $register;
                                                this.$success = $success;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        SvdValueCellEditor.access$getMyTable$p(this.this$0).repaint();
                                                        PeripheralViewUsagesCollector.PeripheralViewWriteValueType peripheralType = this.$svdValue instanceof SvdRegister ? PeripheralViewUsagesCollector.PeripheralViewWriteValueType.REGISTER : PeripheralViewUsagesCollector.PeripheralViewWriteValueType.FIELD;
                                                        PeripheralViewUsagesCollector.PERIPHERAL_VIEW_VALUE_WRITTEN.log(SvdValueCellEditor.access$getMyDebugProcess$p(this.this$0).getProject(), (Object)Boxing.boxBoolean((boolean)this.$register.changed), (Object)Boxing.boxBoolean((boolean)this.$success.element), (Object)((Object)peripheralType));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var5_3) {
                                            return var5_3;
                                        }
                                        ** GOTO lbl52
                                    }
                                    case 3: {
                                        success = (Ref.BooleanRef)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl52:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(CoroutineScope p1, DebuggerDriver p2, Continuation<? super Unit> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)7, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean doStopCellEditing(boolean forced) {
        if (!forced) {
            AbstractSvdValueEditor abstractSvdValueEditor = this.myUnderlayEditor;
            Intrinsics.checkNotNull((Object)((Object)abstractSvdValueEditor));
            if (!abstractSvdValueEditor.getWasChanged()) {
                return super.stopCellEditing();
            }
        }
        AbstractSvdValueEditor abstractSvdValueEditor = this.myUnderlayEditor;
        Intrinsics.checkNotNull((Object)((Object)abstractSvdValueEditor));
        if (abstractSvdValueEditor.stopCellEditing()) {
            return super.stopCellEditing();
        }
        return false;
    }

    static /* synthetic */ boolean doStopCellEditing$default(SvdValueCellEditor svdValueCellEditor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return svdValueCellEditor.doStopCellEditing(bl);
    }

    public boolean stopCellEditing() {
        return SvdValueCellEditor.doStopCellEditing$default(this, false, 1, null);
    }

    @Nullable
    public Object getCellEditorValue() {
        AbstractSvdValueEditor abstractSvdValueEditor = this.myUnderlayEditor;
        return abstractSvdValueEditor != null ? abstractSvdValueEditor.getCellEditorValue() : null;
    }

    private final void switchUnderlayEditor(int row) {
        SvdValue<?> svdValue = this.getValueOnRow(row);
        this.myUnderlayEditor = svdValue == null ? null : (svdValue instanceof SvdRegister ? (AbstractSvdValueEditor)this.numericCellEditor : (svdValue instanceof SvdField ? (((SvdField)svdValue).isWriteEnumSupported() ? (AbstractSvdValueEditor)this.enumCellEditor : (AbstractSvdValueEditor)this.numericCellEditor) : null));
    }

    @Nullable
    public Component getTableCellEditorComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        this.switchUnderlayEditor(row);
        AbstractSvdValueEditor abstractSvdValueEditor = this.myUnderlayEditor;
        return abstractSvdValueEditor != null ? abstractSvdValueEditor.getTableCellEditorComponent(table, value, isSelected, row, column) : null;
    }

    public static final /* synthetic */ CidrDebugProcess access$getMyDebugProcess$p(SvdValueCellEditor $this) {
        return $this.myDebugProcess;
    }

    public static final /* synthetic */ SvdTreeTable access$getMyTable$p(SvdValueCellEditor $this) {
        return $this.myTable;
    }

    public static final /* synthetic */ SvdValue access$getValueOnRow(SvdValueCellEditor $this, int row) {
        return $this.getValueOnRow(row);
    }

    public static final /* synthetic */ boolean access$doStopCellEditing(SvdValueCellEditor $this, boolean forced) {
        return $this.doStopCellEditing(forced);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$AbstractSvdValueEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "<init>", "(Lcom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor;)V", "wasChanged", "", "getWasChanged", "()Z", "setWasChanged", "(Z)V", "textChangeListener", "Lcom/intellij/ui/DocumentAdapter;", "getTextChangeListener", "()Lcom/intellij/ui/DocumentAdapter;", "showEditingError", "", "message", "", "stopCellEditing", "intellij.clion.embedded"})
    @SourceDebugExtension(value={"SMAP\nSvdValueCellEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvdValueCellEditor.kt\ncom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$AbstractSvdValueEditor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,340:1\n19#2:341\n*S KotlinDebug\n*F\n+ 1 SvdValueCellEditor.kt\ncom/intellij/clion/embedded/debugger/peripheralview/SvdValueCellEditor$AbstractSvdValueEditor\n*L\n228#1:341\n*E\n"})
    private abstract class AbstractSvdValueEditor
    extends AbstractTableCellEditor {
        private boolean wasChanged;
        @NotNull
        private final DocumentAdapter textChangeListener = new DocumentAdapter(this){
            final /* synthetic */ AbstractSvdValueEditor this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EDT.assertIsEdt();
                this.this$0.setWasChanged(true);
            }
        };

        public final boolean getWasChanged() {
            return this.wasChanged;
        }

        public final void setWasChanged(boolean bl) {
            this.wasChanged = bl;
        }

        @NotNull
        public final DocumentAdapter getTextChangeListener() {
            return this.textChangeListener;
        }

        public abstract void showEditingError(@Nls @NotNull String var1);

        public boolean stopCellEditing() {
            try {
                Long value;
                SvdValue svdValue = SvdValueCellEditor.this.getEditingValue();
                if (svdValue == null) {
                    return false;
                }
                SvdValue svdValue2 = svdValue;
                if (SvdValueCellEditorKt.access$getRegister(svdValue2).isWritePending()) {
                    String string = EmbeddedBundle.message("svd.register.write.already.pending.error", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.showEditingError(string);
                    return false;
                }
                Object $this$asSafely$iv = this.getCellEditorValue();
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof Long)) {
                    object = null;
                }
                if ((value = (Long)object) == null || !SvdValueCellEditorKt.access$isValueInRange(svdValue2, value)) {
                    String string = EmbeddedBundle.message("svd.register.invalid.value", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.showEditingError(string);
                    return false;
                }
                svdValue2.setValue(value);
                SvdValueCellEditor.this.writeRegisterToMemory(svdValue2);
                return true;
            }
            catch (Throwable error) {
                String string = error.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                this.showEditingError(string);
                return false;
            }
        }
    }
}

