/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.debugger.peripheralview;

import com.intellij.clion.embedded.debugger.peripheralview.Format;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterAccess;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterReadAction;
import com.intellij.clion.embedded.debugger.peripheralview.SvdNodeBase;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class SvdValue<T extends SvdNodeBase<?>>
extends SvdNodeBase<T> {
    private static final Map<Character, Format> ourFormatBySign = Stream.of(Format.values()).collect(Collectors.toMap(Format::getSign, t -> t));
    private final RegisterAccess myAccess;
    private final RegisterReadAction myReadAction;
    private final int myBitSize;
    protected volatile boolean changed;
    private Format myFormat;

    protected SvdValue(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction, int bitSize, Format format) {
        if (id == null) {
            SvdValue.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SvdValue.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdValue.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdValue.$$$reportNull$$$0(3);
        }
        super(id, name, description);
        this.myAccess = access;
        this.myReadAction = readAction;
        this.myBitSize = bitSize;
        this.myFormat = format;
    }

    @Nullable
    protected RegisterReadAction getReadAction() {
        return this.myReadAction;
    }

    @VisibleForTesting
    @NotNull
    public RegisterAccess getAccess() {
        RegisterAccess registerAccess = this.myAccess;
        if (registerAccess == null) {
            SvdValue.$$$reportNull$$$0(4);
        }
        return registerAccess;
    }

    @NotNull
    public Format getFormat() {
        Format format = this.myFormat;
        if (format == null) {
            SvdValue.$$$reportNull$$$0(5);
        }
        return format;
    }

    protected void setFormat(@NotNull Format format) {
        if (format == null) {
            SvdValue.$$$reportNull$$$0(6);
        }
        this.myFormat = format;
    }

    @VisibleForTesting
    public int getBitSize() {
        return this.myBitSize;
    }

    public long getBitMask() {
        return (1L << this.getBitSize()) - 1L;
    }

    @NotNull
    public abstract SvdValueState getState();

    protected boolean isChanged() {
        return this.changed;
    }

    public abstract void setValue(long var1);

    @NotNull
    public abstract Format getDefaultFormat();

    @Override
    public void setFormatFromSign(char sign) {
        this.setFormat(ourFormatBySign.get(Character.valueOf(sign)));
    }

    public boolean isEnumFormatSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/debugger/peripheralview/SvdValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/debugger/peripheralview/SvdValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum SvdValueState {
        UNKNOWN,
        UNCHANGED,
        CHANGED,
        WRITE_PENDING,
        DIRTY,
        NO_VALUE;

    }
}

