/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.debugger.peripheralview;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.debugger.peripheralview.Format;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterAccess;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterReadAction;
import com.intellij.clion.embedded.debugger.peripheralview.SvdField;
import com.intellij.clion.embedded.debugger.peripheralview.SvdNode;
import com.intellij.clion.embedded.debugger.peripheralview.SvdRegisterClusterLevel;
import com.intellij.clion.embedded.debugger.peripheralview.SvdValue;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SvdRegister
extends SvdValue<SvdField>
implements SvdRegisterClusterLevel<SvdField> {
    private static final Format DEFAULT_FORMAT = Format.HEX;
    private final Address myAddress;
    protected volatile long value;
    @Nullable
    private volatile String failReason;
    private volatile SvdValue.SvdValueState state;

    public SvdRegister(@NotNull String peripheralName, @NotNull String name, @NotNull String description, Address address, int bitSize, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction) {
        if (peripheralName == null) {
            SvdRegister.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SvdRegister.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdRegister.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdRegister.$$$reportNull$$$0(3);
        }
        super(peripheralName + "|" + name, name, description, access, readAction, bitSize, DEFAULT_FORMAT);
        this.value = 0L;
        this.failReason = "-";
        this.state = SvdValue.SvdValueState.UNKNOWN;
        this.myAddress = address;
        if (!this.getAccess().isReadable()) {
            this.markNoValue(EmbeddedBundle.message("svd.write.only", new Object[0]), false);
        }
    }

    public Address getAddress() {
        return this.myAddress;
    }

    public void processValue(@Nullable List<LLMemoryHunk> hunks, @Nullable Throwable e) {
        if (e != null) {
            this.markNoValue(e.getLocalizedMessage(), !(e instanceof CancellationException));
        } else if (hunks == null) {
            this.markNoValue("-", true);
        } else {
            for (LLMemoryHunk hunk : hunks) {
                if (!hunk.getRange().contains(this.myAddress)) continue;
                int offset = (int)this.myAddress.minus(hunk.getRange().getStart());
                long value = this.readValue(hunk, offset, this.getByteSize());
                boolean bl = this.changed = this.value != value;
                if (this.changed) {
                    this.value = value;
                    for (SvdField field : this.getChildren()) {
                        field.updateFromValue(value);
                        this.state = SvdValue.SvdValueState.CHANGED;
                    }
                } else {
                    this.getChildren().forEach(SvdField::markStalled);
                    this.state = SvdValue.SvdValueState.UNCHANGED;
                }
                this.failReason = null;
                return;
            }
            this.markNoValue(EmbeddedBundle.message("non.readable", new Object[0]), true);
        }
    }

    protected long readValue(LLMemoryHunk hunk, int offset, int byteSize) {
        return SvdRegister.readLittleEndianValue(hunk, offset, byteSize);
    }

    public static long readLittleEndianValue(LLMemoryHunk hunk, int offset, int byteSize) {
        long value = 0L;
        for (int i = byteSize - 1; i >= 0; --i) {
            value = value << 8 | 0xFFL & (long)((Byte)hunk.getBytes().get(offset + i)).byteValue();
        }
        return value;
    }

    public int getByteSize() {
        return (this.getBitSize() + 7) / 8;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.getByteSize()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(this.value >> i * 8);
        }
        return bytes;
    }

    @Override
    public void setValue(long value) {
        this.state = SvdValue.SvdValueState.WRITE_PENDING;
        this.changed = this.value != value;
        this.value = value;
        for (SvdField field : this.getChildren()) {
            field.updateFromValue(value);
        }
    }

    @TestOnly
    public long getValue() {
        return this.value;
    }

    public void updateFromFields() {
        this.state = SvdValue.SvdValueState.WRITE_PENDING;
        long newValue = 0L;
        for (SvdField field : this.getChildren()) {
            newValue |= field.getBits();
        }
        this.changed = this.value != newValue;
        this.value = newValue;
    }

    @Override
    @NotNull
    public SvdValue.SvdValueState getState() {
        SvdValue.SvdValueState svdValueState = this.state;
        if (svdValueState == null) {
            SvdRegister.$$$reportNull$$$0(4);
        }
        return svdValueState;
    }

    public void markWriteSuccess() {
        this.state = SvdValue.SvdValueState.DIRTY;
    }

    public void markNoValue(@NotNull String reason, boolean valueChange) {
        if (reason == null) {
            SvdRegister.$$$reportNull$$$0(5);
        }
        this.changed = valueChange && !reason.equals(this.failReason);
        this.failReason = reason;
        this.state = this.changed ? SvdValue.SvdValueState.CHANGED : SvdValue.SvdValueState.NO_VALUE;
    }

    @Override
    @NotNull
    public String getDisplayValue() {
        String string = this.isFailed() ? this.failReason : this.getFormat().format(this.value, this.getBitSize());
        if (string == null) {
            SvdRegister.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isFailed() {
        return this.failReason != null;
    }

    public boolean isWritePending() {
        return this.state == SvdValue.SvdValueState.WRITE_PENDING;
    }

    @Override
    @NotNull
    public Format getDefaultFormat() {
        Format format = DEFAULT_FORMAT;
        if (format == null) {
            SvdRegister.$$$reportNull$$$0(7);
        }
        return format;
    }

    @Override
    public void exportCsv(@NotNull PrintWriter writer, @NotNull String prefix, @NotNull Predicate<SvdNode<?>> predicateActive) {
        if (writer == null) {
            SvdRegister.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            SvdRegister.$$$reportNull$$$0(9);
        }
        if (predicateActive == null) {
            SvdRegister.$$$reportNull$$$0(10);
        }
        writer.print(prefix);
        writer.print(", ");
        writer.print(this.getName());
        writer.print(", ");
        writer.print(this.getDisplayValue());
        if (!this.getChildren().isEmpty()) {
            writer.print(", ");
            for (int i = 0; i < this.getChildren().size(); ++i) {
                SvdField field = (SvdField)this.getChildren().get(i);
                if (i > 0) {
                    writer.print("; ");
                }
                writer.print(field.getName());
                writer.print(": ");
                writer.print(field.getDisplayValue());
            }
        }
        writer.println();
    }

    @Override
    public long getStartAddress() {
        return this.myAddress.getUnsignedLongValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheralName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/debugger/peripheralview/SvdRegister";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicateActive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/debugger/peripheralview/SvdRegister";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markNoValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportCsv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

