/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.debugger.peripheralview;

import com.intellij.clion.embedded.debugger.peripheralview.EnumAccess;
import com.intellij.clion.embedded.debugger.peripheralview.Format;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterAccess;
import com.intellij.clion.embedded.debugger.peripheralview.RegisterReadAction;
import com.intellij.clion.embedded.debugger.peripheralview.SvdEnum;
import com.intellij.clion.embedded.debugger.peripheralview.SvdNodeBase;
import com.intellij.clion.embedded.debugger.peripheralview.SvdRegister;
import com.intellij.clion.embedded.debugger.peripheralview.SvdValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdField
extends SvdValue<SvdNodeBase<?>> {
    public static final Format DEFAULT_FORMAT = Format.BIN;
    private final int myBitOffset;
    private final SvdRegister myParent;
    private static final SvdEnum EMPTY_ENUM = new SvdEnum(EnumAccess.READ_WRITE);
    private SvdEnum mySvdEnumRead;
    private SvdEnum mySvdEnumWrite;
    private long myValue;
    private final long myBitMask;
    private boolean dirty;

    public SvdField(@NotNull SvdRegister parent, @NotNull String name, @NotNull String description, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction, int bitOffset, int size) {
        if (parent == null) {
            SvdField.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SvdField.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdField.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdField.$$$reportNull$$$0(3);
        }
        super(parent.getId() + "|" + name, name, description, access, readAction, size, DEFAULT_FORMAT);
        this.mySvdEnumRead = EMPTY_ENUM;
        this.mySvdEnumWrite = EMPTY_ENUM;
        this.myValue = 0L;
        this.dirty = false;
        this.myBitOffset = bitOffset;
        this.myParent = parent;
        this.myBitMask = size == 64 ? -1L : -1L << size ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public int getBitOffset() {
        return this.myBitOffset;
    }

    public void updateFromValue(long registerValue) {
        long newValue = registerValue >> this.myBitOffset;
        this.changed = this.myValue != (newValue &= this.myBitMask);
        this.myValue = newValue;
        this.dirty = false;
    }

    @Override
    public void setValue(long value) {
        this.myValue = value & this.myBitMask;
        this.dirty = true;
        this.myParent.updateFromFields();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getBits() {
        return this.myValue << this.myBitOffset;
    }

    @Override
    @NotNull
    public SvdValue.SvdValueState getState() {
        if (this.myParent.isWritePending()) {
            SvdValue.SvdValueState svdValueState = SvdValue.SvdValueState.WRITE_PENDING;
            if (svdValueState == null) {
                SvdField.$$$reportNull$$$0(4);
            }
            return svdValueState;
        }
        if (this.myParent.isFailed()) {
            SvdValue.SvdValueState svdValueState = SvdValue.SvdValueState.NO_VALUE;
            if (svdValueState == null) {
                SvdField.$$$reportNull$$$0(5);
            }
            return svdValueState;
        }
        if (this.dirty) {
            SvdValue.SvdValueState svdValueState = SvdValue.SvdValueState.DIRTY;
            if (svdValueState == null) {
                SvdField.$$$reportNull$$$0(6);
            }
            return svdValueState;
        }
        if (this.changed) {
            SvdValue.SvdValueState svdValueState = SvdValue.SvdValueState.CHANGED;
            if (svdValueState == null) {
                SvdField.$$$reportNull$$$0(7);
            }
            return svdValueState;
        }
        SvdValue.SvdValueState svdValueState = SvdValue.SvdValueState.UNCHANGED;
        if (svdValueState == null) {
            SvdField.$$$reportNull$$$0(8);
        }
        return svdValueState;
    }

    public SvdRegister getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getDisplayValue() {
        if (this.getAccess().isReadable() && !this.myParent.isFailed()) {
            if (this.getFormat() == Format.ENUM) {
                String string = this.mySvdEnumRead.getDisplayValue(this.myValue, this.getBitSize());
                if (string == null) {
                    SvdField.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.getFormat().format(this.myValue, this.getBitSize());
            if (string == null) {
                SvdField.$$$reportNull$$$0(10);
            }
            return string;
        }
        return "-";
    }

    public void setSvdEnumRead(@NotNull SvdEnum svdEnumRead) {
        if (svdEnumRead == null) {
            SvdField.$$$reportNull$$$0(11);
        }
        this.mySvdEnumRead = svdEnumRead;
    }

    @NotNull
    public SvdEnum getSvdEnumRead() {
        SvdEnum svdEnum = this.mySvdEnumRead;
        if (svdEnum == null) {
            SvdField.$$$reportNull$$$0(12);
        }
        return svdEnum;
    }

    public void setSvdEnumWrite(@NotNull SvdEnum svdEnumWrite) {
        if (svdEnumWrite == null) {
            SvdField.$$$reportNull$$$0(13);
        }
        this.mySvdEnumWrite = svdEnumWrite;
    }

    @NotNull
    public SvdEnum getSvdEnumWrite() {
        SvdEnum svdEnum = this.mySvdEnumWrite;
        if (svdEnum == null) {
            SvdField.$$$reportNull$$$0(14);
        }
        return svdEnum;
    }

    @Override
    @NotNull
    public Format getDefaultFormat() {
        Format format = DEFAULT_FORMAT;
        if (format == null) {
            SvdField.$$$reportNull$$$0(15);
        }
        return format;
    }

    public void markStalled() {
        this.changed = false;
        this.dirty = false;
    }

    @Override
    public boolean isEnumFormatSupported() {
        return !this.mySvdEnumRead.isEmpty();
    }

    public boolean isWriteEnumSupported() {
        return !this.mySvdEnumWrite.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 12, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/debugger/peripheralview/SvdField";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svdEnumRead";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svdEnumWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/debugger/peripheralview/SvdField";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvdEnumRead";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvdEnumWrite";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSvdEnumRead";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSvdEnumWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 12, 14, 15 -> new IllegalStateException(string);
        };
    }
}

