/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.debugger.peripheralview;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public enum Format {
    DEC((Supplier)EmbeddedBundle.messagePointer("format.decimal", new Object[0]), 'D'){

        @Override
        @NotNull
        public String format(long value, int bits) {
            String string = Long.toUnsignedString(value, 10);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/clion/embedded/debugger/peripheralview/Format$1", "format"));
        }
    }
    ,
    HEX((Supplier)EmbeddedBundle.messagePointer("format.hex", new Object[0]), 'H'){

        @Override
        @NotNull
        public String format(long value, int bits) {
            String string = Format.bitGroupFormat(value, bits, 4, "0123456789ABCDEF", "0x");
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/clion/embedded/debugger/peripheralview/Format$2", "format"));
        }
    }
    ,
    OCT((Supplier)EmbeddedBundle.messagePointer("format.octal", new Object[0]), 'O'){

        @Override
        @NotNull
        public String format(long value, int bits) {
            String string = Format.bitGroupFormat(value, bits, 3, "01234567", "0");
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/clion/embedded/debugger/peripheralview/Format$3", "format"));
        }
    }
    ,
    BIN((Supplier)EmbeddedBundle.messagePointer("format.binary", new Object[0]), 'B'){

        @Override
        @NotNull
        public String format(long value, int bits) {
            String string = Format.bitGroupFormat(value, bits, 1, "01", "0b");
            if (string == null) {
                4.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/clion/embedded/debugger/peripheralview/Format$4", "format"));
        }
    }
    ,
    ENUM((Supplier)EmbeddedBundle.messagePointer("format.enum", new Object[0]), 'E'){

        @Override
        @NotNull
        public String format(long value, int bits) {
            throw new UnsupportedOperationException("Shouldn't be called");
        }
    };

    @NotNull
    private final @NotNull Supplier<@NotNull @NlsActions.ActionText String> readableName;
    private final char sign;

    private Format(Supplier<String> readableName, char sign) {
        if (readableName == null) {
            Format.$$$reportNull$$$0(0);
        }
        this.readableName = readableName;
        this.sign = sign;
    }

    char getSign() {
        return this.sign;
    }

    @NotNull
    public @NotNull Supplier<@NotNull @NlsActions.ActionText String> getReadableName() {
        Supplier<String> supplier = this.readableName;
        if (supplier == null) {
            Format.$$$reportNull$$$0(1);
        }
        return supplier;
    }

    @NotNull
    public abstract String format(long var1, int var3);

    private static String bitGroupFormat(long value, int bits, int bitsPerSymbol, String alphabet, String prefix) {
        StringBuilder result = new StringBuilder();
        int symCount = alphabet.length();
        while (bits > 0) {
            result.append(alphabet.charAt((int)Long.remainderUnsigned(value, symCount)));
            value = Long.divideUnsigned(value, symCount);
            bits -= bitsPerSymbol;
        }
        return result.reverse().insert(0, prefix).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/debugger/peripheralview/Format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/debugger/peripheralview/Format";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

