/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.cl6x;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/embedded/cl6x/Cl6xCompilerConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "logLine", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/FileHyperlinkInfo;", "filename", "line", "column", "Companion", "intellij.clion.embedded"})
public class Cl6xCompilerConsoleFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorColorsScheme colorScheme;
    @NotNull
    private static final Regex errorPattern = new Regex("^((\"(.*)\",\\s*)(line\\s*(\\d+)(\\s*\\([\\D]*([\\d]*)\\))?:)?\\s*)?(WARNING|ERROR|remark|warning|(fatal\\s*)?error)(!\\s*at line\\s(\\d+))?\\s*([^:]*)\\s*:\\s*(.*)$");

    public Cl6xCompilerConsoleFilter(@NotNull Project project, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        this.project = project;
        this.colorScheme = colorScheme;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String logLine, int entireLength) {
        Filter.Result result;
        int n;
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        MatchResult matchResult = Regex.find$default((Regex)errorPattern, (CharSequence)logLine, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult columnMatcher = matchResult;
        MatchGroup matchGroup = columnMatcher.getGroups().get(1);
        if (matchGroup == null) {
            return null;
        }
        MatchGroup messageGroup = matchGroup;
        int baseLength = entireLength - logLine.length();
        int messageStart = messageGroup.getRange().getStart() + baseLength;
        int messageEnd = RangesKt.coerceAtLeast((int)(messageStart + 1), (int)(messageGroup.getRange().getEndInclusive() + baseLength - 1));
        Filter.ResultItem severityResult = null;
        MatchGroup severityGroup = columnMatcher.getGroups().get(8);
        MatchGroup matchGroup2 = severityGroup;
        boolean bl = matchGroup2 != null && (matchGroup2 = matchGroup2.getRange()) != null ? !matchGroup2.isEmpty() : false;
        if (bl) {
            String string = severityGroup.getValue().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String string2 = string;
            TextAttributesKey attribute = Intrinsics.areEqual((Object)string2, (Object)"REMARK") ? ConsoleViewContentType.LOG_INFO_OUTPUT_KEY : (Intrinsics.areEqual((Object)string2, (Object)"WARNING") ? ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY : ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY);
            severityResult = new Filter.ResultItem(baseLength + severityGroup.getRange().getStart(), baseLength + severityGroup.getRange().getEndInclusive() + 1, null, this.colorScheme.getAttributes(attribute));
        }
        String filename = (String)columnMatcher.getGroupValues().get(3);
        Integer n2 = StringsKt.toIntOrNull((String)((String)columnMatcher.getGroupValues().get(5)));
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = StringsKt.toIntOrNull((String)((String)columnMatcher.getGroupValues().get(11)));
            n = n3 != null ? n3 : 0;
        }
        int line = n - 1;
        Integer n4 = StringsKt.toIntOrNull((String)((String)columnMatcher.getGroupValues().get(7)));
        int column = (n4 != null ? n4 : 0) - 1;
        FileHyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(filename, line, column);
        if (severityResult == null) {
            result = new Filter.Result(messageStart, messageEnd, (HyperlinkInfo)hyperlinkInfo);
        } else {
            Object[] objectArray = new Filter.ResultItem[]{new Filter.ResultItem(messageStart, messageEnd, (HyperlinkInfo)hyperlinkInfo), severityResult};
            Filter.Result result2 = new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
            result = result2;
        }
        return result;
    }

    @NotNull
    protected FileHyperlinkInfo createHyperlinkInfo(@NotNull String filename, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return (FileHyperlinkInfo)new LazyFileHyperlinkInfo(this.project, filename, line, column, false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/embedded/cl6x/Cl6xCompilerConsoleFilter$Companion;", "", "<init>", "()V", "errorPattern", "Lkotlin/text/Regex;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

