/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.langSwitcher;

import com.intellij.clion.langSwitcher.CLionLanguagePluginKind;
import com.intellij.clion.langSwitcher.CLionLanguagePluginSwitcherService;
import com.intellij.clion.langSwitcher.CLionStartupEngineSelectorKt;
import com.intellij.diagnostic.VMOptions;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/clion/langSwitcher/CLionStartupEngineSelector;", "", "<init>", "()V", "WAS_CONVERTED_TO_NOVA_MARKER", "", "shouldMigrate", "", "configsImported", "", "newConfigDir", "Ljava/nio/file/Path;", "getMarkerFilePath", "setRadlerEngine", "intellij.clion.langSwitcher"})
public final class CLionStartupEngineSelector {
    @NotNull
    public static final CLionStartupEngineSelector INSTANCE = new CLionStartupEngineSelector();
    @VisibleForTesting
    @NotNull
    public static final String WAS_CONVERTED_TO_NOVA_MARKER = "nova.txt";

    private CLionStartupEngineSelector() {
    }

    public final boolean shouldMigrate() {
        String string = "true";
        String string2 = System.getProperty("clion.nova.migrate.users", "false");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        return string.contentEquals(string2);
    }

    public final void configsImported(@NotNull Path newConfigDir) {
        Intrinsics.checkNotNullParameter((Object)newConfigDir, (String)"newConfigDir");
        if (AppMode.isRunningFromDevBuild() || !this.shouldMigrate()) {
            CLionStartupEngineSelectorKt.access$getLog$p().info("skipped conversion to nova: dev-build or tests");
            return;
        }
        Path markerFile = this.getMarkerFilePath(newConfigDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(markerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            CLionStartupEngineSelectorKt.access$getLog$p().info("skipped conversion to nova: it was already done");
            return;
        }
        this.setRadlerEngine(newConfigDir);
        Files.createFile(newConfigDir.resolve(WAS_CONVERTED_TO_NOVA_MARKER), new FileAttribute[0]);
        CLionStartupEngineSelectorKt.access$getLog$p().info("set language plugin to radler, created marker file");
        CLionStartupEngineSelectorKt.access$getLog$p().info("updating disabled_plugins.txt");
        CLionLanguagePluginSwitcherService.Companion.filterSavedDisabledPlugins$intellij_clion_langSwitcher(CLionLanguagePluginKind.Radler);
    }

    private final Path getMarkerFilePath(Path newConfigDir) {
        Path path = newConfigDir;
        if (path == null) {
            Path path2 = VMOptions.getUserOptionsFile();
            path = path2 != null ? path2.getParent() : null;
            if (path == null) {
                Path path3 = PathManager.getConfigDir();
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getConfigDir(...)");
            }
        }
        Path userOptionsDir = path;
        Path path4 = userOptionsDir.resolve(WAS_CONVERTED_TO_NOVA_MARKER);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        return path4;
    }

    static /* synthetic */ Path getMarkerFilePath$default(CLionStartupEngineSelector cLionStartupEngineSelector, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return cLionStartupEngineSelector.getMarkerFilePath(path);
    }

    private final void setRadlerEngine(Path newConfigDir) {
        Path file = VMOptions.getUserOptionsFile();
        if (file != null) {
            CLionStartupEngineSelectorKt.access$getLog$p().info("setting radler language plugin");
            String suppressedSetId = CLionLanguagePluginKind.Radler.getSuppressedSetId();
            System.setProperty("idea.suppressed.plugins.set.selector", suppressedSetId);
            VMOptions.setOptions((List)CollectionsKt.listOf((Object)new Pair((Object)"-Didea.suppressed.plugins.set.selector=", (Object)suppressedSetId)), (Path)newConfigDir.resolve(PathsKt.getName((Path)file)));
        } else {
            CLionStartupEngineSelectorKt.access$getLog$p().info("skipped setting of language plugin: cannot write options");
        }
    }
}

