/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.langSwitcher;

import com.intellij.clion.langSwitcher.CLionBackendEngineCounterCollector;
import com.intellij.clion.langSwitcher.CLionLangSwitcherBundle;
import com.intellij.clion.langSwitcher.CLionLanguagePluginKind;
import com.intellij.clion.langSwitcher.CLionLanguagePluginSwitcherService;
import com.intellij.clion.langSwitcher.CLionLanguagePluginSwitcherServiceKt;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherBrokenInstallation;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherNoVmOptions;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherNotAllowedInDevBuild;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.InvalidateCacheService;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettingType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J,\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001b0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService;", "", "serviceCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "setUpAdvancedSettingsListener", "", "initialPlugin", "Lcom/intellij/clion/langSwitcher/CLionLanguagePluginKind;", "checkLanguagePluginState", "syncSettingsIfNecessary", "setUpDisabledPluginsListener", "switchPlugin", "useRadler", "", "changeVMOptions", "suppressedSetId", "", "setOption", "file", "Ljava/nio/file/Path;", "prefix", "newValue", "setOptions", "_options", "", "Lcom/intellij/openapi/util/Pair;", "Companion", "intellij.clion.langSwitcher"})
@SourceDebugExtension(value={"SMAP\nCLionLanguagePluginSwitcherService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionLanguagePluginSwitcherService.kt\ncom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,295:1\n106#2:296\n78#2,22:297\n*S KotlinDebug\n*F\n+ 1 CLionLanguagePluginSwitcherService.kt\ncom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService\n*L\n229#1:296\n229#1:297,22\n*E\n"})
public final class CLionLanguagePluginSwitcherService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope serviceCoroutineScope;
    @JvmField
    @NotNull
    public static final String CLION_USE_RADLER_ADVANCED_OPTION = "clion.use.radler";

    public CLionLanguagePluginSwitcherService(@NotNull CoroutineScope serviceCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)serviceCoroutineScope, (String)"serviceCoroutineScope");
        this.serviceCoroutineScope = serviceCoroutineScope;
        CLionLanguagePluginKind initialPlugin = CLionLanguagePluginKind.Companion.current();
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("Using " + initialPlugin.name() + " C/C++ language engine");
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("isRemoteDevHost = " + AppMode.isRemoteDevHost());
        CLionBackendEngineCounterCollector.INSTANCE.logBackendState();
        this.syncSettingsIfNecessary(initialPlugin);
        this.checkLanguagePluginState(initialPlugin);
        this.setUpDisabledPluginsListener();
        this.setUpAdvancedSettingsListener(initialPlugin);
    }

    private final void setUpAdvancedSettingsListener(CLionLanguagePluginKind initialPlugin) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(initialPlugin, this){
            final /* synthetic */ CLionLanguagePluginKind $initialPlugin;
            final /* synthetic */ CLionLanguagePluginSwitcherService this$0;
            {
                this.$initialPlugin = $initialPlugin;
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(String id, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)CLionLanguagePluginSwitcherService.CLION_USE_RADLER_ADVANCED_OPTION)) {
                    if (AppMode.isRunningFromDevBuild()) {
                        boolean initialUseRadler;
                        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().warn("Switcher between language engines is not supported in dev mode!");
                        boolean bl = initialUseRadler = this.$initialPlugin == CLionLanguagePluginKind.Radler;
                        if (initialUseRadler != (Boolean)newValue) {
                            CLionLanguagePluginKind otherPlugin = CLionLanguagePluginKind.Companion.current().getOther();
                            Notifications.Bus.notify((Notification)new CLionPluginKindSwitcherNotAllowedInDevBuild(otherPlugin.getDevBuildRunConfiguration()), null);
                            AdvancedSettings.Companion.getInstance().setSetting(CLionLanguagePluginSwitcherService.CLION_USE_RADLER_ADVANCED_OPTION, (Object)initialUseRadler, AdvancedSettingType.Bool);
                        }
                    } else {
                        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("Switching to " + ((Boolean)newValue != false ? "Nova" : "Classic") + " language engine...");
                        CLionLanguagePluginSwitcherService.access$switchPlugin(this.this$0, (Boolean)newValue);
                    }
                }
            }
        });
    }

    private final void checkLanguagePluginState(CLionLanguagePluginKind initialPlugin) {
        String languagePluginError = CLionLanguagePluginSwitcherServiceKt.access$checkLanguagePluginEnabled(initialPlugin);
        if (languagePluginError != null) {
            String string = CLionLangSwitcherBundle.message("clion.plugin.switcher.repair.ide", new Object[0]);
            NotificationAction repairAction2 = new NotificationAction(initialPlugin, string){
                final /* synthetic */ CLionLanguagePluginKind $initialPlugin;
                {
                    this.$initialPlugin = $initialPlugin;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    notification.expire();
                    CLionLanguagePluginSwitcherService.Companion.filterSavedDisabledPlugins$intellij_clion_langSwitcher(this.$initialPlugin);
                    ApplicationManager.getApplication().invokeLater(checkLanguagePluginState.repairAction.1::actionPerformed$lambda$0, ModalityState.nonModal());
                }

                private static final void actionPerformed$lambda$0() {
                    RegistryBooleanOptionDescriptor.suggestRestart(null);
                }
            };
            CLionPluginKindSwitcherBrokenInstallation notification = new CLionPluginKindSwitcherBrokenInstallation(languagePluginError);
            notification.addAction((AnAction)repairAction2);
            Notifications.Bus.notify((Notification)notification, null);
        }
    }

    private final void syncSettingsIfNecessary(CLionLanguagePluginKind initialPlugin) {
        boolean initialUseRadler;
        boolean bl = initialUseRadler = initialPlugin == CLionLanguagePluginKind.Radler;
        if (initialUseRadler != AdvancedSettings.Companion.getBoolean(CLION_USE_RADLER_ADVANCED_OPTION)) {
            AdvancedSettings.Companion.getInstance().setSetting(CLION_USE_RADLER_ADVANCED_OPTION, (Object)initialUseRadler, AdvancedSettingType.Bool);
            CLionBackendEngineCounterCollector.INSTANCE.logSwitch(initialPlugin);
        }
    }

    private final void setUpDisabledPluginsListener() {
        DisabledPluginsState.Companion.addDisablePluginListener(CLionLanguagePluginSwitcherService::setUpDisabledPluginsListener$lambda$0);
    }

    private final void switchPlugin(boolean useRadler) {
        CLionLanguagePluginKind newPluginKind;
        CLionLanguagePluginKind cLionLanguagePluginKind = newPluginKind = useRadler ? CLionLanguagePluginKind.Radler : CLionLanguagePluginKind.Classic;
        if (!this.changeVMOptions(newPluginKind.getSuppressedSetId())) {
            Notifications.Bus.notify((Notification)new CLionPluginKindSwitcherNoVmOptions(), null);
            return;
        }
        CLionBackendEngineCounterCollector.INSTANCE.logSwitch(newPluginKind);
        Companion.filterSavedDisabledPlugins$intellij_clion_langSwitcher(newPluginKind);
        boolean showRestartDialog = CLionLanguagePluginSwitcherServiceKt.getSHOW_RESTART_DIALOG_ON_SWITCH();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx app = (ApplicationEx)application;
        Runnable invalidateCachesAndRestart = () -> CLionLanguagePluginSwitcherService.switchPlugin$lambda$0(showRestartDialog, app);
        app.invokeLater(invalidateCachesAndRestart, ModalityState.nonModal());
    }

    private final boolean changeVMOptions(String suppressedSetId) {
        Path userOptionsFile;
        boolean wasOptionSet = false;
        boolean isRemoteMode = AppMode.isRemoteDevHost();
        Path path = VMOptions.getUserOptionsFile();
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("changing VM options, isRemoteDevHost = " + isRemoteMode + ", platform vmoptions file = " + VMOptions.getPlatformOptionsFile() + ", user vmoptions file = " + (path != null ? (Comparable)path : (Comparable)((Object)"<no file>")));
        if (isRemoteMode) {
            CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("setting -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to " + VMOptions.getPlatformOptionsFile());
            Path path2 = VMOptions.getPlatformOptionsFile();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPlatformOptionsFile(...)");
            this.setOption(path2, "-Didea.suppressed.plugins.set.selector=", suppressedSetId);
            wasOptionSet = true;
        }
        if ((userOptionsFile = VMOptions.getUserOptionsFile()) == null) {
            CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("skipping setting of -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to user vmoptions file because there is no such file");
            return wasOptionSet;
        }
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("setting -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to " + userOptionsFile);
        this.setOption(userOptionsFile, "-Didea.suppressed.plugins.set.selector=", suppressedSetId);
        return true;
    }

    private final void setOption(Path file, String prefix, String newValue) {
        this.setOptions(file, CollectionsKt.listOf((Object)new Pair((Object)prefix, (Object)newValue)));
    }

    private final void setOptions(Path file, List<? extends Pair<String, String>> _options) {
        List lines = Files.exists(file, new LinkOption[0]) ? (List)new ArrayList(Files.readAllLines(file, VMOptions.getFileCharset())) : (List)new ArrayList();
        List options = new ArrayList(_options);
        boolean modified = false;
        ListIterator<CallSite> il = lines.listIterator(lines.size());
        block0: while (il.hasPrevious()) {
            String $this$trim$iv = (String)il.previous();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Iterator io = options.iterator();
            while (io.hasNext()) {
                Pair option = (Pair)io.next();
                Object object = option.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                if (!StringsKt.startsWith$default((String)line, (String)((String)object), (boolean)false, (int)2, null)) continue;
                if (option.second == null) {
                    il.remove();
                    modified = true;
                    continue block0;
                }
                String newLine = "" + option.first + option.second;
                if (!Intrinsics.areEqual((Object)newLine, (Object)line)) {
                    il.set((CallSite)((Object)newLine));
                    modified = true;
                }
                io.remove();
                continue block0;
            }
        }
        for (Pair option : options) {
            if (option.second == null) continue;
            lines.add("" + option.first + option.second);
            modified = true;
        }
        if (modified) {
            NioFiles.createDirectories((Path)file.getParent());
            Files.write(file, (Iterable<? extends CharSequence>)lines, VMOptions.getFileCharset(), new OpenOption[0]);
        }
    }

    private static final void setUpDisabledPluginsListener$lambda$0() {
        CLionLanguagePluginKind currentPluginKind = CLionLanguagePluginKind.Companion.current();
        Companion.filterSavedDisabledPlugins$intellij_clion_langSwitcher(currentPluginKind);
    }

    private static final void switchPlugin$lambda$0(boolean $showRestartDialog, ApplicationEx $app) {
        InvalidateCacheService.invalidateCaches(arg_0 -> CLionLanguagePluginSwitcherService.switchPlugin$lambda$0$1(CLionLanguagePluginSwitcherService::switchPlugin$lambda$0$0, arg_0));
        if ($showRestartDialog) {
            RegistryBooleanOptionDescriptor.suggestRestart(null);
        } else {
            $app.restart(true);
        }
    }

    private static final boolean switchPlugin$lambda$0$0(CachesInvalidator it) {
        return it.getDescription() == null;
    }

    private static final boolean switchPlugin$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$switchPlugin(CLionLanguagePluginSwitcherService $this, boolean useRadler) {
        $this.switchPlugin(useRadler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService$Companion;", "", "<init>", "()V", "CLION_USE_RADLER_ADVANCED_OPTION", "", "filterSavedDisabledPlugins", "", "newPluginKind", "Lcom/intellij/clion/langSwitcher/CLionLanguagePluginKind;", "filterSavedDisabledPlugins$intellij_clion_langSwitcher", "intellij.clion.langSwitcher"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void filterSavedDisabledPlugins$intellij_clion_langSwitcher(@NotNull CLionLanguagePluginKind newPluginKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)newPluginKind), (String)"newPluginKind");
            Path disabledPluginsFile = PathManager.getConfigDir().resolve("disabled_plugins.txt");
            Logger logger = CLionLanguagePluginSwitcherServiceKt.access$getLOG$p();
            Intrinsics.checkNotNull((Object)disabledPluginsFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            logger.info("File " + disabledPluginsFile + " exists? " + (Files.exists(disabledPluginsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? "Yes" : "No"));
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(disabledPluginsFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                List list;
                Set requiredPluginIds = CollectionsKt.toMutableSet((Iterable)newPluginKind.getRelevantPluginIds());
                if (AppMode.isRunningFromDevBuild()) {
                    CollectionsKt.addAll((Collection)requiredPluginIds, (Iterable)newPluginKind.getOther().getRelevantPluginIds());
                }
                CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("Required plugins: " + requiredPluginIds);
                AutoCloseable autoCloseable = Files.lines(disabledPluginsFile);
                Throwable throwable = null;
                try {
                    Stream lines = (Stream)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)lines);
                    list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)lines), (Function1)filterSavedDisabledPlugins.newDisabledPluginsIds.1.1.INSTANCE), arg_0 -> Companion.filterSavedDisabledPlugins$lambda$0$0(requiredPluginIds, arg_0)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                List newDisabledPluginsIds2 = list;
                CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("New disabled plugins: " + newDisabledPluginsIds2);
                Files.write(disabledPluginsFile, (Iterable<? extends CharSequence>)newDisabledPluginsIds2, new OpenOption[0]);
            } else {
                CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info(disabledPluginsFile + " doesn't exist - nothing to update");
            }
        }

        private static final boolean filterSavedDisabledPlugins$lambda$0$0(Set $requiredPluginIds, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return !(((CharSequence)line).length() == 0) && !$requiredPluginIds.contains(line);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

