/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrTestListParserAndHolder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import com.jetbrains.cidr.execution.testing.google.GoogleTestLanguageSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration>
implements CidrBeforeTestRunTaskProvider.CidrTestConfigurationNeedBeforeRunTask,
CidrTestListParserAndHolder<CidrGoogleTestLinker> {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = CidrGoogleTestRunConfigurationData::new;
    @NlsSafe
    public static final String FRAMEWORK_ID = "Google Test";
    private volatile transient ArrayList<CidrGoogleTestLinker> myLinkers;
    private static final Pattern[] SUITES = new Pattern[]{Pattern.compile("([^ \t]+)/([^ \t]+)/([^ \t]+)[.](?:  # TypeParam = (.+))?"), Pattern.compile("([^ \t]+)/(\\d+)[.](?:  # TypeParam = (.+))?"), Pattern.compile("([^ \t]+)/([^ \t]+)[.]"), Pattern.compile("([^ \t]+)[.]")};
    private static final Pattern[] TESTS = new Pattern[]{Pattern.compile("  ([^ \t]+)/(\\d+)(?:  # GetParam\\(\\) = (.+))?"), Pattern.compile("  ([^ \t]+)")};

    public CidrGoogleTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myLinkers = null;
    }

    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        String string = this.myTestName;
        if (string == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setTestSuite(@Nullable String suiteNameOrPart) {
        this.myTestSuite = CidrGoogleTestRunConfigurationData.getPureName(suiteNameOrPart);
    }

    public void setTestName(@Nullable String testNameOrPart) {
        this.myTestName = CidrGoogleTestRunConfigurationData.getPureName(testNameOrPart);
    }

    @Nullable
    private static String getPureName(@Nullable String nameOrPart) {
        String nullize = StringUtil.nullize((String)nameOrPart, (boolean)true);
        if (nullize == null) {
            return null;
        }
        List split = StringUtil.split((String)nullize, (String)":");
        return switch (split.size()) {
            case 1 -> ((String)split.get(0)).trim();
            case 2 -> ((String)split.get(1)).trim();
            default -> null;
        };
    }

    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        return this.bothAreEmpty(scope) || (scope.isPatternLike() ? this.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && Objects.equals(this.getTestPattern(), scope.getPattern()) : this.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST && Objects.equals(this.getTestSuite(), CidrGoogleTestRunConfigurationData.getPureName(scope.getSuiteName())) && Objects.equals(this.getTestName(), CidrGoogleTestRunConfigurationData.getPureName(scope.getTestName())));
    }

    protected boolean isEmptyPatternScope(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        return scope.isPatternLike() && "*".equals(scope.getPattern().trim());
    }

    public void checkData() throws RuntimeConfigurationException {
        Project project = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || this.myTestSuite == null || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn((Project)project)) {
            return;
        }
        if (((Boolean)OCTestExecution.executeWithCachedValuesFast(() -> GoogleTestLanguageSupport.getInstance().hasTestElement(project, this.myTestSuite, this.myTestName))).booleanValue()) {
            return;
        }
        String errorMessage = this.myTestName == null ? CidrExecutionBundle.message((String)"test.suiteNotFound", (Object[])new Object[]{this.myTestSuite}) : CidrExecutionBundle.message((String)"test.testNotFound", (Object[])new Object[]{this.myTestName});
        throw new RuntimeConfigurationError(errorMessage);
    }

    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        if (env == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        return new CidrGoogleTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (executor == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        if (target == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        return new CidrGoogleTestConsoleProperties((RunConfiguration)this.myConfiguration, executor, target);
    }

    public synchronized List<CidrGoogleTestLinker> getTestListCopy() {
        return this.myLinkers == null ? null : new ArrayList<CidrGoogleTestLinker>(this.myLinkers);
    }

    public synchronized void clean() {
        this.myLinkers = null;
    }

    public synchronized void parse(@NotNull ProcessOutput output) {
        if (output == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(8);
        }
        this.myLinkers = CidrGoogleTestRunConfigurationData.parseOutputToLinkers(output.getStdout());
    }

    @NotNull
    public static ArrayList<CidrGoogleTestLinker> parseOutputToLinkers(@NotNull String programOutputWithListOfTests) {
        if (programOutputWithListOfTests == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(9);
        }
        List lines = StringUtil.split((String)programOutputWithListOfTests, (String)"\n", (boolean)true, (boolean)false);
        ArrayList<CidrGoogleTestLinker> linkers = new ArrayList<CidrGoogleTestLinker>();
        CidrGoogleTestLinker suiteLinker = null;
        block10: for (String line : lines) {
            if (line.isBlank()) {
                suiteLinker = null;
                continue;
            }
            int suiteNo = 0;
            for (Pattern suite : SUITES) {
                Matcher suiteMatcher = suite.matcher(line);
                if (suiteMatcher.matches()) {
                    suiteLinker = new CidrGoogleTestLinker();
                    switch (suiteNo) {
                        case 0: {
                            suiteLinker.isTyped = true;
                            suiteLinker.instantiation = suiteMatcher.group(1);
                            suiteLinker.suite = suiteMatcher.group(2);
                            suiteLinker.order = suiteMatcher.group(3);
                            suiteLinker.typeNameOrParamValue = suiteMatcher.group(4);
                            continue block10;
                        }
                        case 1: {
                            suiteLinker.isTyped = true;
                            suiteLinker.suite = suiteMatcher.group(1);
                            suiteLinker.order = suiteMatcher.group(2);
                            suiteLinker.typeNameOrParamValue = suiteMatcher.group(3);
                            continue block10;
                        }
                        case 2: {
                            suiteLinker.isTyped = false;
                            suiteLinker.instantiation = suiteMatcher.group(1);
                            suiteLinker.suite = suiteMatcher.group(2);
                            continue block10;
                        }
                        case 3: {
                            suiteLinker.isTyped = false;
                            suiteLinker.suite = suiteMatcher.group(1);
                            continue block10;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                ++suiteNo;
            }
            if (suiteLinker != null) {
                int testNo = 0;
                for (Pattern test : TESTS) {
                    Matcher testMatcher = test.matcher(line);
                    if (testMatcher.matches()) {
                        CidrGoogleTestLinker testLinker = suiteLinker.copy();
                        switch (testNo) {
                            case 0: {
                                testLinker.test = testMatcher.group(1);
                                testLinker.order = testMatcher.group(2);
                                testLinker.typeNameOrParamValue = testMatcher.group(3);
                                if (testLinker.instantiation != null || testLinker.isTyped) break;
                                testLinker.instantiation = "<empty>";
                                break;
                            }
                            case 1: {
                                testLinker.test = testMatcher.group(1);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        linkers.add(testLinker);
                        continue block10;
                    }
                    ++testNo;
                }
            }
            suiteLinker = null;
        }
        ArrayList<CidrGoogleTestLinker> arrayList = linkers;
        if (arrayList == null) {
            CidrGoogleTestRunConfigurationData.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programOutputWithListOfTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOutputToLinkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyPatternScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseOutputToLinkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10 -> new IllegalStateException(string);
        };
    }
}

