/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrGoogleTestLinker {
    @NonNls
    public static final String DATA = "data";
    @NonNls
    public static final String TYPE = "type";
    @NonNls
    public static final String SUITE = "suite";
    @NonNls
    public static final String TEST = "test";
    @NonNls
    public static final String ORDER = "order";
    @NonNls
    public static final String ORDER_NAME = "orderName";
    @NonNls
    public static final String KIND_SEPARATOR = ":";
    @NonNls
    public static final String EMPTY = "<empty>";
    public String instantiation = null;
    public String suite = null;
    public String test = null;
    public String order = null;
    public String typeNameOrParamValue = null;
    public boolean isTyped = false;
    private static final String DISABLED = "DISABLED_";

    public CidrGoogleTestLinker copy() {
        CidrGoogleTestLinker cp = new CidrGoogleTestLinker();
        cp.instantiation = this.instantiation;
        cp.suite = this.suite;
        cp.test = this.test;
        cp.order = this.order;
        cp.typeNameOrParamValue = this.typeNameOrParamValue;
        cp.isTyped = this.isTyped;
        return cp;
    }

    @NotNull
    public String getPath() {
        StringBuilder path = new StringBuilder();
        CidrGoogleTestLinker.addToPath(path, SUITE, this.suite);
        CidrGoogleTestLinker.addToPath(path, this.isTyped ? TYPE : DATA, this.instantiation);
        if (this.isTyped) {
            CidrGoogleTestLinker.addToPath(path, ORDER, this.order);
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
        } else {
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
            CidrGoogleTestLinker.addToPath(path, ORDER, this.order);
        }
        CidrGoogleTestLinker.addToPath(path, ORDER_NAME, CidrGoogleTestLinker.encodePathPart(this.typeNameOrParamValue));
        String string = path.toString();
        if (string == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public String getOrderName() {
        if (this.order == null) {
            return null;
        }
        return this.order + (String)(this.typeNameOrParamValue == null ? "" : " - " + this.typeNameOrParamValue);
    }

    public String getFindPath() {
        StringBuilder path = new StringBuilder();
        CidrGoogleTestLinker.addToPath(path, SUITE, this.suite);
        if (this.test != null) {
            CidrGoogleTestLinker.addToPath(path, TEST, this.test);
        } else if (this.instantiation != null) {
            CidrGoogleTestLinker.addToPath(path, this.isTyped ? TYPE : DATA, this.instantiation);
        }
        return path.toString();
    }

    private static void addToPath(@NotNull StringBuilder path, @NotNull String partKind, @Nullable String part) {
        if (path == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(1);
        }
        if (partKind == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(2);
        }
        if (part != null) {
            if (!path.isEmpty()) {
                path.append('/');
            }
            path.append(partKind).append(KIND_SEPARATOR).append(part);
        }
    }

    @Nullable
    public static CidrGoogleTestLinker parseTestOut(@NotNull String text) {
        if (text == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(3);
        }
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        Pair<String, String> beforeAfter = CidrGoogleTestLinker.splitByFirst(text, ",");
        testInfo.typeNameOrParamValue = CidrGoogleTestLinker.getParam((String)beforeAfter.second);
        List parts = StringUtil.split((String)((String)beforeAfter.first), (String)"/", (boolean)true, (boolean)false);
        switch (parts.size()) {
            case 1: {
                Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(0), ".");
                testInfo.suite = (String)suiteTest.first;
                testInfo.test = (String)suiteTest.second;
                break;
            }
            case 2: {
                Pair<String, String> orderTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(1), ".");
                if (orderTest.second == null) {
                    Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(0), ".");
                    if (testInfo.typeNameOrParamValue == null && suiteTest.second == null) {
                        testInfo.instantiation = (String)parts.get(0);
                        testInfo.suite = (String)parts.get(1);
                        break;
                    }
                    testInfo.suite = (String)suiteTest.first;
                    testInfo.test = (String)suiteTest.second;
                    testInfo.order = (String)parts.get(1);
                    boolean bl = testInfo.isTyped = testInfo.test == null;
                    if (testInfo.typeNameOrParamValue != null) break;
                    testInfo.instantiation = EMPTY;
                    break;
                }
                testInfo.suite = (String)parts.get(0);
                testInfo.order = (String)orderTest.first;
                testInfo.test = (String)orderTest.second;
                testInfo.isTyped = true;
                break;
            }
            case 3: {
                testInfo.instantiation = (String)parts.get(0);
                Pair<String, String> suiteTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(1), ".");
                if (suiteTest.second != null) {
                    testInfo.suite = (String)suiteTest.first;
                    testInfo.test = (String)suiteTest.second;
                    testInfo.order = (String)parts.get(2);
                    break;
                }
                testInfo.isTyped = true;
                testInfo.suite = (String)parts.get(1);
                Pair<String, String> orderTest = CidrGoogleTestLinker.splitByFirst((String)parts.get(2), ".");
                testInfo.order = (String)orderTest.first;
                testInfo.test = (String)orderTest.second;
                break;
            }
            default: {
                return null;
            }
        }
        return testInfo;
    }

    @Contract(value="null -> null")
    private static String getParam(@Nullable String afterComma) {
        if (afterComma == null) {
            return null;
        }
        return (String)CidrGoogleTestLinker.splitByFirst((String)afterComma, (String)" = ").second;
    }

    @NotNull
    public static Pair<String, String> splitByFirst(@NotNull String text, @NotNull String separator) {
        String after;
        String before;
        int commaPos;
        if (text == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(5);
        }
        if ((commaPos = StringUtil.indexOf((CharSequence)text, (CharSequence)separator)) < 0) {
            before = text;
            after = null;
        } else {
            before = commaPos == 0 ? "" : text.substring(0, commaPos);
            after = commaPos == text.length() - separator.length() ? "" : text.substring(commaPos + separator.length());
        }
        Pair pair = Pair.create((Object)before, after);
        if (pair == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    public static CidrGoogleTestLinker create(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(7);
        }
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        List parts = CidrTestScopeElementImpl.splitPath((String)locationTestPath);
        for (String pair : parts) {
            Pair<String, String> keyValue = CidrGoogleTestLinker.splitByFirst(pair, KIND_SEPARATOR);
            if (keyValue.second == null) continue;
            String key = (String)keyValue.first;
            String value = (String)keyValue.second;
            if (DATA.equals(key)) {
                testInfo.instantiation = value;
                testInfo.isTyped = false;
                continue;
            }
            if (TYPE.equals(key)) {
                testInfo.instantiation = value;
                testInfo.isTyped = true;
                continue;
            }
            if (SUITE.equals(key)) {
                testInfo.suite = value;
                continue;
            }
            if (TEST.equals(key)) {
                testInfo.test = value;
                continue;
            }
            if (ORDER.equals(key)) {
                testInfo.order = value;
                continue;
            }
            if (!ORDER_NAME.equals(key)) continue;
            testInfo.typeNameOrParamValue = CidrGoogleTestLinker.decodePathPart(value);
        }
        CidrGoogleTestLinker cidrGoogleTestLinker = testInfo;
        if (cidrGoogleTestLinker == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(8);
        }
        return cidrGoogleTestLinker;
    }

    public String getConfigurationName() {
        StringBuilder cn = new StringBuilder();
        if (this.instantiation != null) {
            cn.append(this.instantiation).append("-");
        }
        if (this.suite != null) {
            cn.append(this.suite);
        }
        if (this.test != null) {
            cn.append(".").append(this.test);
        }
        if (this.order != null) {
            cn.append("[").append(this.getOrderName()).append("]");
        }
        return cn.toString();
    }

    @NonNls
    public String getPatternForCommandLine() {
        String test = StringUtil.notNullize((String)this.test, (String)"*");
        String suite = StringUtil.notNullize((String)this.suite, (String)"*");
        String order = StringUtil.notNullize((String)this.order, (String)"*");
        if (this.instantiation != null) {
            if (EMPTY.equals(this.instantiation)) {
                return String.format("%s.%s/%s", suite, test, order);
            }
            return String.format("%s/%s.%s/%s:%s/%s/%s.%s", this.instantiation, suite, test, order, this.instantiation, suite, order, test);
        }
        if (this.suite == null) {
            return "*";
        }
        return String.format("%s.%s:%s/%s.%s:%s.%s/%s:*/%s.%s/*:*/%s/*.%s", suite, test, suite, order, test, suite, test, order, suite, test, suite, test);
    }

    public static String getNoName() {
        return SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.noname", (Object[])new Object[0]);
    }

    public static String encodePathPart(@Nullable String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value);
        StringUtil.escapeQuotes((StringBuilder)sb);
        StringUtil.quote((StringBuilder)sb);
        return sb.toString();
    }

    public static String decodePathPart(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (StringUtil.isQuotedString((String)value)) {
            return StringUtil.unescapeChar((String)StringUtil.unquoteString((String)value), (char)'\"');
        }
        return value;
    }

    public static boolean isTest(@NotNull String locationWithoutPrefix) {
        if (locationWithoutPrefix == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(9);
        }
        CidrGoogleTestLinker linker = CidrGoogleTestLinker.create(locationWithoutPrefix);
        if (linker.suite == null || linker.test == null) {
            return false;
        }
        boolean ret = linker.isTyped ? linker.order != null : linker.instantiation == null || linker.order != null;
        return ret;
    }

    public static boolean isDisabled(@Nullable String locationWithPrefix) {
        if (locationWithPrefix == null || !locationWithPrefix.startsWith("gtest://")) {
            return false;
        }
        CidrGoogleTestLinker linker = CidrGoogleTestLinker.create(locationWithPrefix.substring("gtest://".length()));
        if (linker.suite != null && linker.suite.startsWith(DISABLED)) {
            return true;
        }
        if (linker.test != null && linker.test.startsWith(DISABLED)) {
            return true;
        }
        return linker.isTyped && linker.instantiation != null && linker.instantiation.startsWith(DISABLED);
    }

    @Contract(pure=true)
    @NotNull
    public static String getNonNullName(@Nullable String name) {
        String string = StringUtil.notNullize((String)name, (String)CidrGoogleTestLinker.getNoName());
        if (string == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestLinker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partKind";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationTestPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationWithoutPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestLinker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByFirst";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonNullName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTestOut";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitByFirst";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

