/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.testing.CidrFromTagInLineToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleOutputToGeneralTestEventsConverter
extends CidrFromTagInLineToGeneralTestEventsConverter {
    @NonNls
    protected final HashMap<String, String> myRenamedClosedNodeIds;
    @RegExp
    @NonNls
    private static final String DIGITS = "\\d(?:[^()]?\\d)*";
    @RegExp
    @NonNls
    private static final String TEST_TIME = " [(:](\\d(?:[^()]?\\d)* ms)(?: total)?\\)?\n";
    private final List<CidrGoogleTestLinker> myInfos;
    private final String myTargetName;
    private boolean myFinished;
    private CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> myLongFail;
    boolean myCanParse_TEST_END;
    boolean myNewlineAfter_SUITE_END;
    boolean myCanParse_TEST_END_FAILED_MULTILINE_END;
    boolean myCanParse_FINAL_XXXX;

    public CidrGoogleOutputToGeneralTestEventsConverter(@NotNull @NonNls String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console, @Nullable List<CidrGoogleTestLinker> linkers, @Nullable @NonNls String targetName) {
        if (testFrameworkName == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties, new CidrTestEventProcessor("gtest"), console);
        this.myRenamedClosedNodeIds = new HashMap();
        this.myFinished = false;
        this.myLongFail = null;
        this.myCanParse_TEST_END = false;
        this.myNewlineAfter_SUITE_END = false;
        this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
        this.myCanParse_FINAL_XXXX = false;
        this.myInfos = linkers;
        this.myTargetName = targetName;
    }

    protected synchronized void setupTestTree(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (this.myInfos == null || this.myInfos.isEmpty()) {
            return;
        }
        for (CidrGoogleTestLinker linker : this.myInfos) {
            this.ensureOpen(processor, linker, false);
        }
        this.myRenamedClosedNodeIds.clear();
        while (!this.myTestNameStack.isEmpty()) {
            this.myTestNameStack.pop();
        }
        while (!this.myTestResultStack.isEmpty()) {
            this.myTestResultStack.pop();
        }
        processor.onBuildTreeEnded();
        CidrGoogleOutputToGeneralTestEventsConverter.fixIgnoredState((GeneralTestEventsProcessor)processor, (SMTestProxy)((SMTRunnerConsoleView)this.myConsole).getResultsViewer().getTestsRootNode(), node -> CidrGoogleTestLinker.isDisabled(node.getLocationUrl()), node -> CidrGoogleOutputToGeneralTestEventsConverter.getNodeId(node), (boolean)false);
    }

    @Nullable
    private static String getNodeId(@NotNull SMTestProxy node) {
        String locationURL;
        if (node == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if ((locationURL = node.getLocationUrl()) != null && locationURL.startsWith("gtest://")) {
            return "0/" + locationURL.substring("gtest://".length());
        }
        return null;
    }

    @NotNull
    public CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> parse(@NotNull String line) {
        if (line == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, Object> attrs = new HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, Object>();
        if (this.myNewlineAfter_SUITE_END) {
            this.myNewlineAfter_SUITE_END = false;
            if (line.equals("\n")) {
                return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr((Object)Tag.INFO, attrs);
            }
        }
        for (Tag tag : Tag.values()) {
            Matcher matcher;
            if (tag == Tag.TEST_END_FAILED_MULTILINE_END && !this.myCanParse_TEST_END_FAILED_MULTILINE_END || (tag == Tag.TEST_END || tag == Tag.TEST_END_FAILED_MULTILINE_START) && !this.myCanParse_TEST_END || (tag == Tag.FINAL_STATUS || tag == Tag.FINAL_FAILED_REPORT) && !this.myCanParse_FINAL_XXXX || !(matcher = tag.myTagPattern.matcher(line)).find()) continue;
            switch (tag.ordinal()) {
                case 0: {
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(1));
                    this.myCanParse_TEST_END = true;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    this.myCanParse_FINAL_XXXX = true;
                    break;
                }
                case 1: {
                    this.myCanParse_TEST_END = false;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    this.myCanParse_FINAL_XXXX = false;
                    break;
                }
                case 3: {
                    this.myCanParse_TEST_END = false;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                    break;
                }
                case 2: {
                    this.myCanParse_TEST_END = false;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(2));
                    this.myNewlineAfter_SUITE_END = true;
                    break;
                }
                case 7: {
                    this.myCanParse_TEST_END = true;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                    break;
                }
                case 4: {
                    this.myCanParse_TEST_END = false;
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = false;
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED, matcher.group(1));
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(3));
                    break;
                }
                case 5: {
                    this.myCanParse_TEST_END_FAILED_MULTILINE_END = true;
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED, "FAILED");
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(1));
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, "0 ms");
                    break;
                }
                case 6: {
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, line);
                    attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(1));
                }
            }
            String outText = line.substring(0, matcher.start());
            if (tag == Tag.INFO) {
                attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, outText + matcher.group(1));
            } else if (!outText.isEmpty()) {
                attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, outText + "\n");
            }
            return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr((Object)tag, attrs);
        }
        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, line);
        return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr((Object)Tag.INFO, attrs);
    }

    public synchronized void flushBufferOnProcessTermination(int exitCode) {
        super.flushBufferOnProcessTermination(exitCode);
        this.myFinished = true;
    }

    protected synchronized void processLine(@NotNull Key outputType, @NotNull @NlsSafe String text) {
        Tag etag;
        if (outputType == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        if (text == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag = this.parse(text);
        String outText = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
        GeneralTestEventsProcessor processor = this.getProcessor();
        if (outText != null && !outText.isEmpty() && this.myLongFail == null) {
            String testName = this.myTestNameStack.isEmpty() ? "" : (String)this.myTestNameStack.peek();
            String nodeId = this.getCurrentNodeId();
            if (nodeId.equals("0") || testName == null) {
                processor.onUncapturedOutput(outText, outputType);
                return;
            }
            this.process(ProcessOutputType.isStdout((Key)outputType) ? this.myEventProcessor.testStdOut(testName, nodeId, outputType, outText) : this.myEventProcessor.testErrOut(testName, nodeId, outputType, outText));
        }
        if ((etag = (Tag)((Object)tag.getTag())) != Tag.INFO && this.myLongFail != null) {
            this.closeLastNode(processor, this.myLongFail.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED), CidrGoogleOutputToGeneralTestEventsConverter.getTimeInMs((String)(etag == Tag.TEST_END_FAILED_MULTILINE_END ? tag : this.myLongFail).getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME)), true);
            this.myLongFail = null;
        }
        switch (etag.ordinal()) {
            case 1: {
                processor.onTestsReporterAttached();
                this.setupRootNode(processor);
                break;
            }
            case 3: 
            case 7: {
                this.ensureOpen(tag, processor);
                break;
            }
            case 0: {
                int testStackSize = this.myTestNameStack.size();
                for (int toClose = 0; toClose < testStackSize; ++toClose) {
                    this.closeLastNode(processor, null, 0L, true);
                }
                this.myFinished = true;
                break;
            }
            case 5: {
                this.myLongFail = tag;
                break;
            }
            case 2: 
            case 4: {
                this.closeLastNode(processor, tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.SUCCEEDED), CidrGoogleOutputToGeneralTestEventsConverter.getTimeInMs((String)tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME)), true);
            }
        }
    }

    private void setupRootNode(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        processor.onRootPresentationAdded(this.myTargetName, null, "gtest://CIDRRerun?" + this.createMetainfo());
    }

    private void ensureOpen(@NotNull CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag, @NotNull GeneralTestEventsProcessor processor) {
        if (tag == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(10);
        }
        if (this.myFinished) {
            return;
        }
        String attr = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
        if (attr == null) {
            return;
        }
        CidrGoogleTestLinker linker = CidrGoogleTestLinker.parseTestOut(attr);
        if (linker == null) {
            return;
        }
        this.ensureOpen(processor, linker, true);
    }

    private void ensureOpen(@NotNull GeneralTestEventsProcessor processor, @NotNull CidrGoogleTestLinker linker, boolean runState) {
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(11);
        }
        if (linker == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(12);
        }
        String[] pathPartsAsNodeIds = ArrayUtil.toStringArray((Collection)CidrTestScopeElementImpl.splitPath((String)linker.getPath()));
        int partsCount = pathPartsAsNodeIds.length;
        String orderNamePart = null;
        if (partsCount > 0 && "orderName".equals(CidrGoogleTestLinker.splitByFirst((String)pathPartsAsNodeIds[partsCount - 1], (String)":").first)) {
            orderNamePart = pathPartsAsNodeIds[partsCount - 1];
            --partsCount;
        }
        int lastCommonParent = 0;
        for (String pathPartAsNodeId : this.myTestNameStack) {
            if (lastCommonParent >= partsCount || !pathPartsAsNodeIds[lastCommonParent].equals(pathPartAsNodeId)) break;
            ++lastCommonParent;
        }
        int testStackSize = this.myTestNameStack.size();
        for (int toClose = lastCommonParent; toClose < testStackSize; ++toClose) {
            this.closeLastNode(processor, null, 0L, runState);
        }
        String addLocationPart = null;
        for (int toOpen = lastCommonParent; toOpen < partsCount; ++toOpen) {
            String presentableName;
            Pair<String, String> keyValue = CidrGoogleTestLinker.splitByFirst(pathPartsAsNodeIds[toOpen], ":");
            if ("order".equals(keyValue.first)) {
                addLocationPart = orderNamePart;
                presentableName = linker.getOrderName();
            } else {
                presentableName = (String)keyValue.second;
            }
            this.openNewNode(processor, pathPartsAsNodeIds[toOpen], CidrGoogleTestLinker.getNonNullName(presentableName), addLocationPart, runState);
        }
    }

    @NotNull
    protected String getCurrentNodeId() {
        String id = super.getCurrentNodeId();
        while (this.myRenamedClosedNodeIds.containsKey(id)) {
            id = this.myRenamedClosedNodeIds.get(id);
        }
        String string = id;
        if (string == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    private void openNewNode(@NotNull GeneralTestEventsProcessor processor, @NotNull String pathPartAsNodeId, @NotNull String presentableName, @Nullable String addLocationPart, boolean runState) {
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(14);
        }
        if (pathPartAsNodeId == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(15);
        }
        if (presentableName == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(16);
        }
        String parentId = this.getCurrentNodeId();
        this.myTestNameStack.push((Object)pathPartAsNodeId);
        String location = addLocationPart == null ? this.getLocationFromId() : this.getLocationFromId() + CidrTestScopeElement.SEPARATOR + addLocationPart;
        this.myTestResultStack.push((Object)CidrFromTagInLineToGeneralTestEventsConverter.TestResult.create((boolean)true, (int)0));
        String nodeId = this.getCurrentNodeId();
        boolean test = CidrGoogleTestLinker.isTest(location);
        String metainfo = this.createMetainfo();
        if (runState) {
            this.process(test ? this.myEventProcessor.testStarted(presentableName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(presentableName, parentId, nodeId, location, metainfo));
        } else {
            processor.onSuiteTreeNodeAdded(!test, presentableName, "gtest://" + location, metainfo, nodeId, parentId);
        }
    }

    @NotNull
    private String createMetainfo() {
        String string = CidrMetaParam.serialize((Pair[])new Pair[]{Pair.pair((Object)"target", (Object)this.myTargetName)});
        if (string == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getPresentableName(@NotNull String name) {
        if (name == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(18);
        }
        String string = StringUtil.notNullize((String)((String)CidrGoogleTestLinker.splitByFirst((String)name, (String)":").second));
        if (string == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(19);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void closeLastNode(@NotNull GeneralTestEventsProcessor processor, @Nullable String statusOFS, long durationInMs, boolean bl) {
        void runState;
        if (processor == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(20);
        }
        if (this.myFinished) {
            return;
        }
        String nodeId = this.getCurrentNodeId();
        String location = this.getLocationFromId();
        this.myRenamedClosedNodeIds.put(nodeId, nodeId + "/reopen:");
        if (this.myTestNameStack.isEmpty()) {
            return;
        }
        String nodeName = (String)this.myTestNameStack.pop();
        boolean succeeded = ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.pop()).success;
        if (succeeded && statusOFS != null) {
            boolean bl2 = succeeded = !"FAILED".equalsIgnoreCase(statusOFS);
        }
        if (!this.myTestResultStack.isEmpty()) {
            ((CidrFromTagInLineToGeneralTestEventsConverter.TestResult)this.myTestResultStack.peek()).update(succeeded, durationInMs);
        }
        if (runState != false) {
            String presentableName = CidrGoogleOutputToGeneralTestEventsConverter.getPresentableName(nodeName);
            this.process(CidrGoogleTestLinker.isTest(location) ? this.myEventProcessor.testFinished(presentableName, nodeId, String.valueOf(durationInMs), succeeded, "SKIPPED".equalsIgnoreCase(statusOFS)) : this.myEventProcessor.suiteFinished(presentableName, nodeId));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linker";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleOutputToGeneralTestEventsConverter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPartAsNodeId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleOutputToGeneralTestEventsConverter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNodeId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetainfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupTestTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupRootNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureOpen";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openNewNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "closeLastNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 17, 19 -> new IllegalStateException(string);
        };
    }

    static enum Tag {
        MODULE_END("\\[==========] \\d(?:[^()]?\\d)* tests? from \\d(?:[^()]?\\d)* tests? (?:(?:case|suite)s?)? ran\\. [(:](\\d(?:[^()]?\\d)* ms)(?: total)?\\)?\n"),
        MODULE_START("\\[==========] Running \\d(?:[^()]?\\d)* tests? from \\d(?:[^()]?\\d)* test (?:(?:case|suite)s?)?\\."),
        SUITE_END("\\[----------] \\d(?:[^()]?\\d)* tests? from (.*) [(:](\\d(?:[^()]?\\d)* ms)(?: total)?\\)?\n"),
        SUITE_START("\\[----------] \\d(?:[^()]?\\d)* tests? from (.*)\n"),
        TEST_END("\\[\\s*(OK|FAILED|SKIPPED)\\s*]\\s*(.*) [(:](\\d(?:[^()]?\\d)* ms)(?: total)?\\)?\n"),
        TEST_END_FAILED_MULTILINE_START("\\[\\s*FAILED\\s*]\\s*([^, ]*, where GetParam\\(\\) = .*)\n"),
        TEST_END_FAILED_MULTILINE_END(" [(:](\\d(?:[^()]?\\d)* ms)(?: total)?\\)?\n"),
        TEST_START("\\[\\s*RUN\\s*]\\s*(.*)\n"),
        SETUP_TEARDOWN("\\[----------] Global test environment (set-up|tear-down)[.]?\n"),
        FILTER_NOTE_PREFIX("Note: Google Test filter = (.*)\n"),
        FINAL_STATUS("\\[\\s*(PASSED|FAILED|SKIPPED)\\s*](.*)\n"),
        FINAL_FAILED_REPORT("\\s*\\d(?:[^()]?\\d)* FAILED TESTS?\n"),
        INFO("\\[(?:----------|==========]) (.*)\n");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            if (pattern == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myTagPattern = Pattern.compile(pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/cidr/execution/testing/google/CidrGoogleOutputToGeneralTestEventsConverter$Tag", "<init>"));
        }
    }
}

