/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util.events.impl;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.util.events.impl.ChromeTracingEventTracer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/util/events/impl/ToggleChromeTracingAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "productCode", "", "Lorg/jetbrains/annotations/NotNull;", "getProductCode", "()Ljava/lang/String;", "myIsRunning", "", "myTimeStarted", "", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "startTracing", "stopTracingAndDump", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.cidr.util.execution"})
@SourceDebugExtension(value={"SMAP\nChromeTracingEventTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeTracingEventTracer.kt\ncom/jetbrains/cidr/util/events/impl/ToggleChromeTracingAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
public final class ToggleChromeTracingAction
extends DumbAwareToggleAction {
    private boolean myIsRunning = Boolean.getBoolean("cidr.enable.json.tracer");
    private long myTimeStarted = System.currentTimeMillis();

    public ToggleChromeTracingAction() {
        if (this.myIsRunning) {
            this.startTracing();
        }
    }

    private final String getProductCode() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        return string;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.myIsRunning;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setSelected(state);
    }

    private final void setSelected(boolean state) {
        this.myIsRunning = state;
        if (this.myIsRunning) {
            this.startTracing();
        } else {
            this.stopTracingAndDump();
        }
    }

    private final void startTracing() {
        this.myTimeStarted = System.currentTimeMillis();
        ChromeTracingEventTracer.Companion.getInstance().startTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTracingAndDump() {
        long duration = (System.currentTimeMillis() - this.myTimeStarted) / (long)1000;
        String fileNamePrefix = new SimpleDateFormat("'" + this.getProductCode() + "-trace.'yyyy-MM-dd-HH-mm-ss'-[" + duration + "sec]'").format(new Date());
        File file = FileUtil.createTempFile((File)new File(SystemProperties.getUserHome()), (String)fileNamePrefix, (String)".json.gz", (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File outFile = file;
        Object[] objectArray = new GZIPOutputStream((OutputStream)new FileOutputStream(outFile), 65536);
        Object object = Charsets.UTF_8;
        objectArray = new OutputStreamWriter((OutputStream)objectArray, (Charset)object);
        object = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)objectArray;
            boolean bl = false;
            ChromeTracingEventTracer.Companion.getInstance().write(it);
            it = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
        }
        objectArray = new Object[]{outFile.getPath()};
        Object[] it = objectArray = new Notification("System Messages", CidrUtilsExecutionBundle.message("chrome.trace.title", new Object[0]), CidrUtilsExecutionBundle.message("chrome.trace.message", objectArray), NotificationType.INFORMATION);
        boolean bl = false;
        it.addAction((AnAction)NotificationAction.createSimpleExpiring((String)RevealFileAction.getActionName(), () -> ToggleChromeTracingAction.stopTracingAndDump$lambda$1$0(outFile)));
        Notifications.Bus.notify((Notification)objectArray);
        ChromeTracingEventTracer.Companion.getInstance().stopTracing();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final void stopTracingAndDump$lambda$1$0(File $outFile) {
        RevealFileAction.openFile((File)$outFile);
    }
}

