/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.toolchains.PathSeparator;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CidrWSLHostProcessBuilder
extends CidrProcessBuilder {
    private final CidrWSLHost myHost;
    private final WSLDistribution myDistribution;

    @ApiStatus.Internal
    public CidrWSLHostProcessBuilder(CidrWSLHost host) {
        this.myHost = host;
        this.myDistribution = host.myWSL.getWslDistribution();
    }

    @Override
    @NotNull
    protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) throws ExecutionException {
        if (cl == null) {
            CidrWSLHostProcessBuilder.$$$reportNull$$$0(0);
        }
        if (params == null) {
            CidrWSLHostProcessBuilder.$$$reportNull$$$0(1);
        }
        if (this.myDistribution == null) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("wsl.toolchain.not.found", this.myHost.myWSL.getWslDistributionName()));
        }
        cl = this.patchCommandLine(cl, params.isElevated());
        Object processHandler = params.isEmulateTerminal() ? new LocalHost.TerminalEmulatorOSProcessHandler(cl) : (params.isColored() ? new LocalHost.ParameterizedColoredProcessHandler(cl, params) : (params.isCapturedOutput() ? new LocalHost.ParameterizedCapturingProcessHandler(cl, params) : new LocalHost.ParameterizedOSProcessHandler(cl, params)));
        CidrRunProcessUtil.setHasPty(processHandler, params.isPty());
        Object object = processHandler;
        if (object == null) {
            CidrWSLHostProcessBuilder.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NotNull
    @ApiStatus.Internal
    public GeneralCommandLine patchCommandLine(@NotNull GeneralCommandLine cl, boolean isElevated) throws ExecutionException {
        if (cl == null) {
            CidrWSLHostProcessBuilder.$$$reportNull$$$0(3);
        }
        if (cl instanceof PtyCommandLine) {
            ((PtyCommandLine)cl).withInitialColumns(2500);
        }
        String exe = cl.getExePath();
        cl.setExePath(this.myHost.convertToRemote(exe));
        Path wd = cl.getWorkingDirectory();
        String wdPath = wd == null ? null : this.myHost.convertToRemote(wd.normalize().toString());
        WSLCommandLineOptions options = new WSLCommandLineOptions().setSudo(isElevated).setRemoteWorkingDirectory(wdPath).setExecuteCommandInLoginShell(AdvancedSettings.getBoolean((String)"wsl.toolchain.execute.login.shell")).setSleepTimeoutSec(Registry.doubleValue((String)"clion.wsl.sleep.timeout")).setPassEnvVarsUsingInterop(false);
        cl.withWorkingDirectory(null);
        String pathValue = cl.getEnvironment().getOrDefault("PATH", null);
        if (pathValue != null && cl.isPassParentEnvironment()) {
            options.addInitCommand("export PATH=\"" + pathValue + String.valueOf((Object)PathSeparator.UNIX) + "$PATH\"");
            cl.getEnvironment().remove("PATH");
        }
        GeneralCommandLine generalCommandLine = this.myDistribution.patchCommandLine(cl, null, options);
        if (generalCommandLine == null) {
            CidrWSLHostProcessBuilder.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHostProcessBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHostProcessBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

