/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.stepFilters;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.util.Function;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.TableModelEditor;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFilterSettingsItem;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersDiagnosticsLevel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;", "<init>", "()V", "rootPanel", "Ljavax/swing/JPanel;", "loadSteppingRulesFromFilesCheckbox", "Ljavax/swing/JCheckBox;", "doNotStepIntoFunctionsCheckbox", "comment", "Ljavax/swing/JLabel;", "steppingDiagnosticsLabel", "steppingDiagnosticsModel", "Lcom/intellij/ui/EnumComboBoxModel;", "Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersDiagnosticsLevel;", "steppingDiagnosticsDropdown", "Lcom/intellij/openapi/ui/ComboBox;", "stepFiltersEditor", "Lcom/intellij/util/ui/table/TableModelEditor;", "Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFilterSettingsItem;", "reset", "", "settings", "isModified", "", "apply", "getComponent", "Ljavax/swing/JComponent;", "createTable", "updateTable", "intellij.cidr.debugger.core"})
public final class StepFiltersConfigurableUi
implements ConfigurableUi<CidrDebuggerSettings> {
    @NotNull
    private final JPanel rootPanel = new JPanel(new GridBagLayout());
    @NotNull
    private final JCheckBox loadSteppingRulesFromFilesCheckbox = new JCheckBox(CidrDebuggerBundle.message("debug.settings.stepFilters.loadSteppingRulesFromFiles", new Object[0]));
    @NotNull
    private final JCheckBox doNotStepIntoFunctionsCheckbox = new JCheckBox(CidrDebuggerBundle.message("debug.settings.stepFilters.doNotStepIntoFunctions", new Object[0]));
    @NotNull
    private final JLabel comment = new JLabel(CidrDebuggerBundle.message("debug.settings.stepFilters.comment", new Object[0]));
    @NotNull
    private final JLabel steppingDiagnosticsLabel = new JLabel(CidrDebuggerBundle.message("debug.settings.stepFilters.diagnostics", new Object[0]));
    @NotNull
    private final EnumComboBoxModel<StepFiltersDiagnosticsLevel> steppingDiagnosticsModel = new EnumComboBoxModel(StepFiltersDiagnosticsLevel.class);
    @NotNull
    private final ComboBox<StepFiltersDiagnosticsLevel> steppingDiagnosticsDropdown = new ComboBox((ComboBoxModel)this.steppingDiagnosticsModel);
    @NotNull
    private final TableModelEditor<StepFilterSettingsItem> stepFiltersEditor = this.createTable();

    public StepFiltersConfigurableUi() {
        this.comment.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        this.steppingDiagnosticsLabel.setLabelFor((Component)this.steppingDiagnosticsDropdown);
        this.rootPanel.add((Component)this.loadSteppingRulesFromFilesCheckbox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.rootPanel.add((Component)this.doNotStepIntoFunctionsCheckbox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.rootPanel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)28), 0, 0));
        this.rootPanel.add((Component)this.stepFiltersEditor.createComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)5), 0, 0));
        JPanel steppingDiagnosticsPanel = new JPanel(new FlowLayout(0));
        steppingDiagnosticsPanel.add(this.steppingDiagnosticsLabel);
        steppingDiagnosticsPanel.add((Component)this.steppingDiagnosticsDropdown);
        this.rootPanel.add((Component)steppingDiagnosticsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.doNotStepIntoFunctionsCheckbox.addActionListener(arg_0 -> StepFiltersConfigurableUi._init_$lambda$0(this, arg_0));
    }

    public void reset(@NotNull CidrDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.loadSteppingRulesFromFilesCheckbox.setSelected(settings.getUseSteppingRulesFromFiles());
        this.doNotStepIntoFunctionsCheckbox.setSelected(settings.getUseSteppingRulesFromSettings());
        this.steppingDiagnosticsDropdown.setSelectedItem((Object)settings.getSteppingRulesDiagnosticsLevel());
        this.stepFiltersEditor.reset(settings.getStepFilters());
        this.updateTable();
    }

    public boolean isModified(@NotNull CidrDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return this.loadSteppingRulesFromFilesCheckbox.isSelected() != settings.getUseSteppingRulesFromFiles() || this.doNotStepIntoFunctionsCheckbox.isSelected() != settings.getUseSteppingRulesFromSettings() || this.steppingDiagnosticsDropdown.getSelectedItem() != settings.getSteppingRulesDiagnosticsLevel() || this.stepFiltersEditor.isModified();
    }

    public void apply(@NotNull CidrDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        settings.setUseSteppingRulesFromFiles(this.loadSteppingRulesFromFilesCheckbox.isSelected());
        settings.setUseSteppingRulesFromSettings(this.doNotStepIntoFunctionsCheckbox.isSelected());
        Object newDiagnostics = this.steppingDiagnosticsDropdown.getSelectedItem();
        if (newDiagnostics instanceof StepFiltersDiagnosticsLevel) {
            settings.setSteppingRulesDiagnosticsLevel((StepFiltersDiagnosticsLevel)((Object)newDiagnostics));
        }
        if (this.stepFiltersEditor.isModified()) {
            settings.setStepFilters(this.stepFiltersEditor.apply());
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.rootPanel;
    }

    private final TableModelEditor<StepFilterSettingsItem> createTable() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TableModelEditor.EditableColumnInfo<StepFilterSettingsItem, Boolean>(){

            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            public Boolean valueOf(StepFilterSettingsItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.isEnabled();
            }

            public void setValue(StepFilterSettingsItem item, boolean value) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                item.setEnabled(value);
            }
        }, new TableModelEditor.EditableColumnInfo<StepFilterSettingsItem, String>(){

            public String valueOf(StepFilterSettingsItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getPattern();
            }

            public void setValue(StepFilterSettingsItem item, String value) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                item.setPattern(value);
            }
        }};
        ColumnInfo[] columns2 = columnInfoArray;
        TableModelEditor.DialogItemEditor itemEditor2 = (TableModelEditor.DialogItemEditor)new TableModelEditor.DialogItemEditor<StepFilterSettingsItem>(this){
            final /* synthetic */ StepFiltersConfigurableUi this$0;
            {
                this.this$0 = $receiver;
            }

            public StepFilterSettingsItem clone(StepFilterSettingsItem item, boolean forInPlaceEditing) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new StepFilterSettingsItem(item.isEnabled(), item.getPattern());
            }

            public Class<StepFilterSettingsItem> getItemClass() {
                return StepFilterSettingsItem.class;
            }

            public void edit(StepFilterSettingsItem item, Function<? super StepFilterSettingsItem, ? extends StepFilterSettingsItem> mutator, boolean isAdd) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
                String pattern = Messages.showInputDialog((Component)StepFiltersConfigurableUi.access$getRootPanel$p(this.this$0), (String)CidrDebuggerBundle.message("debug.settings.stepFilters.newStepFilter.message", new Object[0]), (String)CidrDebuggerBundle.message("debug.settings.stepFilters.newStepFilter.title", new Object[0]), null, (String)item.getPattern(), (InputValidator)((InputValidator)new NonEmptyInputValidator()));
                if (pattern != null) {
                    ((StepFilterSettingsItem)mutator.fun((Object)item)).setPattern(pattern);
                }
            }

            public void applyEdited(StepFilterSettingsItem oldItem, StepFilterSettingsItem newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                newItem.setPattern(oldItem.getPattern());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        return new TableModelEditor(columns2, (CollectionItemEditor)itemEditor2, CidrDebuggerBundle.message("debug.settings.stepFilters.emptyText", new Object[0]));
    }

    private final void updateTable() {
        this.comment.setEnabled(this.doNotStepIntoFunctionsCheckbox.isSelected());
        this.stepFiltersEditor.enabled(this.doNotStepIntoFunctionsCheckbox.isSelected());
    }

    private static final void _init_$lambda$0(StepFiltersConfigurableUi this$0, ActionEvent it) {
        this$0.updateTable();
    }

    public static final /* synthetic */ JPanel access$getRootPanel$p(StepFiltersConfigurableUi $this) {
        return $this.rootPanel;
    }
}

