/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlayPass;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlays;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.cidr.debugger.core"})
public final class CidrMemoryInlays
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> TIMESTAMP_KEY;
    private static volatile boolean showDebugInfo;
    @NotNull
    private static AtomicLong showDebugInfoModificationCount;

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = editor.getVirtualFile();
        MemoryViewFile memoryViewFile = virtualFile instanceof MemoryViewFile ? (MemoryViewFile)virtualFile : null;
        if (memoryViewFile == null) {
            return null;
        }
        MemoryViewFile memoryViewFile2 = memoryViewFile;
        CidrMemoryDoc<?> cidrMemoryDoc = memoryViewFile2.getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return null;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        long memoryDocModificationCount = ((Number)memoryDoc.getDocAccess().read(CidrMemoryInlays::createHighlightingPass$lambda$0)).longValue();
        long timestamp = editor.getDocument().getModificationStamp() + memoryDocModificationCount + showDebugInfoModificationCount.get();
        Long l = (Long)editor.getUserData(TIMESTAMP_KEY);
        long l2 = timestamp;
        if (l != null && l == l2) {
            return null;
        }
        return new CidrMemoryInlayPass(editor, memoryDoc, timestamp);
    }

    private static final long createHighlightingPass$lambda$0(CidrMemoryDocAccess.DocAccessScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return $this$read.getAddressSpace().getModificationCount();
    }

    static {
        Key key = Key.create((String)"com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlays.timestamp");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TIMESTAMP_KEY = key;
        showDebugInfoModificationCount = new AtomicLong(0L);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlays$Companion;", "", "<init>", "()V", "TIMESTAMP_KEY", "Lcom/intellij/openapi/util/Key;", "", "getTIMESTAMP_KEY", "()Lcom/intellij/openapi/util/Key;", "value", "", "showDebugInfo", "getShowDebugInfo", "()Z", "setShowDebugInfo", "(Z)V", "showDebugInfoModificationCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getShowDebugInfoModificationCount$intellij_cidr_debugger_core", "()Ljava/util/concurrent/atomic/AtomicLong;", "setShowDebugInfoModificationCount$intellij_cidr_debugger_core", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Long> getTIMESTAMP_KEY() {
            return TIMESTAMP_KEY;
        }

        public final boolean getShowDebugInfo() {
            return showDebugInfo;
        }

        public final void setShowDebugInfo(boolean value) {
            showDebugInfo = value;
            this.getShowDebugInfoModificationCount$intellij_cidr_debugger_core().incrementAndGet();
        }

        @NotNull
        public final AtomicLong getShowDebugInfoModificationCount$intellij_cidr_debugger_core() {
            return showDebugInfoModificationCount;
        }

        public final void setShowDebugInfoModificationCount$intellij_cidr_debugger_core(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
            showDebugInfoModificationCount = atomicLong;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

