/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlays;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.ErrorDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import com.jetbrains.cidr.execution.debugger.memory.LoadingDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFileEditorProvider;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002JN\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\b\b\u0002\u0010'\u001a\u00020(H\u0002J$\u0010)\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030%H\u0002J$\u0010*\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030%H\u0002J$\u0010+\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030%H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlayPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "editor", "Lcom/intellij/openapi/editor/Editor;", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "timestamp", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;J)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getMemoryDoc", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "getTimestamp", "()J", "oldInlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "intervals", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "addNewInlays", "addHoleInlay", "inlayModel", "Lcom/intellij/openapi/editor/InlayModel;", "presentationFactory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "offset", "", "interval", "prevRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "nextRegion", "showAbove", "", "addErrorInlay", "addLoadingInlay", "addLoadedRegionInlays", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrMemoryInlays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrMemoryInlays.kt\ncom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlayPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1#2:217\n1869#3,2:218\n*S KotlinDebug\n*F\n+ 1 CidrMemoryInlays.kt\ncom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlayPass\n*L\n87#1:218,2\n*E\n"})
public final class CidrMemoryInlayPass
extends TextEditorHighlightingPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final CidrMemoryDoc<?> memoryDoc;
    private final long timestamp;
    @NotNull
    private final List<Inlay<? extends EditorCustomElementRenderer>> oldInlays;
    @NotNull
    private final List<Interval> intervals;
    @NotNull
    private static final Key<Boolean> INLAY_MARKER;

    public CidrMemoryInlayPass(@NotNull Editor editor, @NotNull CidrMemoryDoc<?> memoryDoc, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        super(memoryDoc.getProject(), editor.getDocument());
        this.editor = editor;
        this.memoryDoc = memoryDoc;
        this.timestamp = timestamp;
        this.oldInlays = new ArrayList();
        this.intervals = new ArrayList();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final CidrMemoryDoc<?> getMemoryDoc() {
        return this.memoryDoc;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        for (Inlay inlay : this.editor.getInlayModel().getBlockElementsInRange(0, Integer.MAX_VALUE)) {
            if (!Intrinsics.areEqual((Object)inlay.getUserData(INLAY_MARKER), (Object)true)) continue;
            Intrinsics.checkNotNull((Object)inlay);
            this.oldInlays.add((Inlay<? extends EditorCustomElementRenderer>)inlay);
        }
        for (Inlay inlay : this.editor.getInlayModel().getAfterLineEndElementsInRange(0, Integer.MAX_VALUE)) {
            if (!Intrinsics.areEqual((Object)inlay.getUserData(INLAY_MARKER), (Object)true)) continue;
            Intrinsics.checkNotNull((Object)inlay);
            this.oldInlays.add((Inlay<? extends EditorCustomElementRenderer>)inlay);
        }
        this.memoryDoc.getDocAccess().read(arg_0 -> CidrMemoryInlayPass.doCollectInformation$lambda$0(this, arg_0));
    }

    public void doApplyInformationToEditor() {
        EditorScrollingPositionKeeper.perform((Editor)this.editor, (boolean)false, () -> CidrMemoryInlayPass.doApplyInformationToEditor$lambda$0(this));
    }

    private final void addNewInlays() {
        InlayModel inlayModel = this.editor.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        InlayModel inlayModel2 = inlayModel;
        PresentationFactory presentationFactory = new PresentationFactory(this.editor);
        Interval hole = null;
        DocRegion prevDocRegion = null;
        boolean showHoleInlays = this.memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider;
        for (Interval interval : this.intervals) {
            if (interval instanceof DocRegion) {
                int startOffset = ((DocRegion)interval).getTextRange().getStartOffset();
                if (hole != null) {
                    CidrMemoryInlayPass.addHoleInlay$default(this, inlayModel2, presentationFactory, startOffset, hole, prevDocRegion, (DocRegion)interval, false, 64, null);
                    hole = null;
                }
                if (interval instanceof ErrorDocRegion) {
                    this.addErrorInlay(inlayModel2, presentationFactory, (DocRegion)interval);
                } else if (interval instanceof LoadingDocRegion) {
                    this.addLoadingInlay(inlayModel2, presentationFactory, (DocRegion)interval);
                } else if (CidrMemoryInlays.Companion.getShowDebugInfo()) {
                    this.addLoadedRegionInlays(inlayModel2, presentationFactory, (DocRegion)interval);
                }
                prevDocRegion = (DocRegion)interval;
                continue;
            }
            if (!showHoleInlays && !CidrMemoryInlays.Companion.getShowDebugInfo()) continue;
            if (!(hole == null)) {
                boolean bl = false;
                String string = "Two hole intervals in a row: " + hole + " and " + interval;
                throw new IllegalStateException(string.toString());
            }
            hole = interval;
        }
        if (hole != null && (prevDocRegion != null || CidrMemoryInlays.Companion.getShowDebugInfo())) {
            this.addHoleInlay(inlayModel2, presentationFactory, this.getDocument().getTextLength(), hole, prevDocRegion, null, false);
        }
    }

    private final void addHoleInlay(InlayModel inlayModel, PresentationFactory presentationFactory, int offset, Interval interval, DocRegion<?> prevRegion, DocRegion<?> nextRegion, boolean showAbove) {
        boolean hasNextDocRegion;
        InlayPresentation rangePresentation = presentationFactory.roundWithBackground(presentationFactory.smallText(String.valueOf(interval.getRange())));
        boolean hasPrevDocRegion = prevRegion != null && !(prevRegion instanceof ErrorDocRegion);
        boolean bl = hasNextDocRegion = nextRegion != null && !(nextRegion instanceof ErrorDocRegion);
        if (hasPrevDocRegion || hasNextDocRegion) {
            int width = rangePresentation.getWidth();
            InlayPresentation presentationWithMouseListener = presentationFactory.onClick(rangePresentation, MouseButton.Left, (arg_0, arg_1) -> CidrMemoryInlayPass.addHoleInlay$lambda$0(hasPrevDocRegion, hasNextDocRegion, width, this, offset, arg_0, arg_1));
            Cursor cursor = Cursor.getPredefinedCursor(12);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            InlayPresentation presentation = presentationFactory.withCursorOnHover(presentationWithMouseListener, cursor);
            Inlay inlay = inlayModel.addBlockElement(offset, new InlayProperties().showAbove(showAbove), (EditorCustomElementRenderer)new PresentationRenderer(presentation));
            if (inlay != null) {
                inlay.putUserData(INLAY_MARKER, (Object)true);
            }
        }
    }

    static /* synthetic */ void addHoleInlay$default(CidrMemoryInlayPass cidrMemoryInlayPass, InlayModel inlayModel, PresentationFactory presentationFactory, int n, Interval interval, DocRegion docRegion, DocRegion docRegion2, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        cidrMemoryInlayPass.addHoleInlay(inlayModel, presentationFactory, n, interval, docRegion, docRegion2, bl);
    }

    private final void addErrorInlay(InlayModel inlayModel, PresentationFactory presentationFactory, DocRegion<?> interval) {
        CidrMemoryData.DataRegion<?> dataRegion = interval.getDataRegion();
        Intrinsics.checkNotNull(dataRegion, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData.DataRegion.Completed.LoadError<out kotlin.Any?>");
        String errorMessage = ((CidrMemoryData.DataRegion.Completed.LoadError)dataRegion).getException().getMessage();
        String string = errorMessage;
        if (string == null) {
            Object[] objectArray = new Object[]{String.valueOf(interval.getRange())};
            String string2 = CidrDebuggerBundle.message("debug.error.failedToReadMemory.unknownReason", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String errorText = string;
        Inlay inlay = inlayModel.addAfterLineEndElement(interval.getTextRange().getStartOffset(), new InlayProperties().relatesToPrecedingText(true).priority(1), (EditorCustomElementRenderer)new PresentationRenderer(presentationFactory.roundWithBackground(presentationFactory.smallText(errorText))));
        if (inlay != null) {
            inlay.putUserData(INLAY_MARKER, (Object)true);
        }
    }

    private final void addLoadingInlay(InlayModel inlayModel, PresentationFactory presentationFactory, DocRegion<?> interval) {
        Object[] objectArray = new Object[]{String.valueOf(interval.getRange())};
        String string = CidrDebuggerBundle.message("debug.inlay.loadingData", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String text = string;
        Inlay inlay = inlayModel.addAfterLineEndElement(interval.getTextRange().getStartOffset(), new InlayProperties().showAbove(true).priority(1), (EditorCustomElementRenderer)new PresentationRenderer(presentationFactory.roundWithBackground(presentationFactory.smallText(text))));
        if (inlay != null) {
            inlay.putUserData(INLAY_MARKER, (Object)true);
        }
    }

    private final void addLoadedRegionInlays(InlayModel inlayModel, PresentationFactory presentationFactory, DocRegion<?> interval) {
        Inlay inlay = inlayModel.addAfterLineEndElement(interval.getTextRange().getStartOffset(), new InlayProperties().relatesToPrecedingText(true).priority(1), (EditorCustomElementRenderer)new PresentationRenderer(presentationFactory.roundWithBackground(presentationFactory.smallText("v " + interval.getRange()))));
        if (inlay != null) {
            inlay.putUserData(INLAY_MARKER, (Object)true);
        }
        if ((inlay = inlayModel.addAfterLineEndElement(interval.getTextRange().getEndOffset() - 1, new InlayProperties().relatesToPrecedingText(true).priority(1), (EditorCustomElementRenderer)new PresentationRenderer(presentationFactory.roundWithBackground(presentationFactory.smallText("^ " + interval.getRange()))))) != null) {
            inlay.putUserData(INLAY_MARKER, (Object)true);
        }
    }

    private static final boolean doCollectInformation$lambda$0(CidrMemoryInlayPass this$0, CidrMemoryDocAccess.DocAccessScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return this$0.intervals.addAll($this$read.getAddressSpace().getIntervals());
    }

    private static final void doApplyInformationToEditor$lambda$0(CidrMemoryInlayPass this$0) {
        Iterable $this$forEach$iv = this$0.oldInlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this$0.addNewInlays();
        this$0.editor.putUserData(CidrMemoryInlays.Companion.getTIMESTAMP_KEY(), (Object)this$0.timestamp);
    }

    private static final Unit addHoleInlay$lambda$0(boolean $hasPrevDocRegion, boolean $hasNextDocRegion, int $width, CidrMemoryInlayPass this$0, int $offset, MouseEvent e, Point p) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        boolean loadHigherAddresses = $hasPrevDocRegion && $hasNextDocRegion ? p.x < $width / 2 : $hasPrevDocRegion;
        int editorLineCount = MemoryViewFileEditorProvider.getLineCount(this$0.editor);
        if (loadHigherAddresses) {
            this$0.memoryDoc.loadHigherAddresses(this$0.getDocument().getLineNumber($offset) - 1, editorLineCount);
        } else {
            this$0.memoryDoc.loadLowerAddresses(this$0.getDocument().getLineNumber($offset) + 1, editorLineCount);
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlays.marker");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INLAY_MARKER = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlayPass$Companion;", "", "<init>", "()V", "INLAY_MARKER", "Lcom/intellij/openapi/util/Key;", "", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

