/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpByteUpdate;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "findRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion;", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "offset", "", "intellij.cidr.debugger.core"})
public final class CidrHexdumpTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        VirtualFile virtualFile = file.getVirtualFile();
        MemoryViewFile memoryViewFile = virtualFile instanceof MemoryViewFile ? (MemoryViewFile)virtualFile : null;
        if (memoryViewFile == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        MemoryViewFile memoryViewFile2 = memoryViewFile;
        CidrMemoryDoc<?> cidrMemoryDoc = memoryViewFile2.getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        if (!(memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String readOnlyReason = ((CidrDebuggerHexdumpDataProvider)memoryDoc.getDataProvider()).readOnlyReason();
        if (readOnlyReason != null) {
            HintManager.getInstance().showInformationHint(editor, readOnlyReason, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        int docOffset = editor.getCaretModel().getOffset();
        CidrHexdumpRegion cidrHexdumpRegion = this.findRegion(memoryDoc, docOffset);
        if (cidrHexdumpRegion == null) {
            return TypedHandlerDelegate.Result.STOP;
        }
        CidrHexdumpRegion hexdumpRegion = cidrHexdumpRegion;
        int offsetInRegion = docOffset - hexdumpRegion.getTextRange().getStartOffset();
        return (TypedHandlerDelegate.Result)memoryDoc.getDocAccess().edit(arg_0 -> CidrHexdumpTypedHandler.beforeCharTyped$lambda$0(hexdumpRegion, offsetInRegion, c, editor, memoryDoc, arg_0));
    }

    private final CidrHexdumpRegion findRegion(CidrMemoryDoc<?> memoryDoc, int offset) {
        return (CidrHexdumpRegion)memoryDoc.getDocAccess().read(arg_0 -> CidrHexdumpTypedHandler.findRegion$lambda$0(offset, memoryDoc, arg_0));
    }

    private static final TypedHandlerDelegate.Result beforeCharTyped$lambda$0(CidrHexdumpRegion $hexdumpRegion, int $offsetInRegion, char $c, Editor $editor, CidrMemoryDoc $memoryDoc, CidrMemoryDocAccess.DocAccessScope $this$edit) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
        CidrHexdumpByteUpdate byteUpdate = $hexdumpRegion.updateByte($offsetInRegion, $c);
        if (byteUpdate != null) {
            $editor.getCaretModel().getCurrentCaret().moveToOffset(byteUpdate.getDocOffsetAfterEdit());
            $editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            int n = 0;
            byte[] byArray = new byte[1];
            while (n < 1) {
                int n2 = n++;
                byArray[n2] = byteUpdate.getNewValue();
            }
            byte[] dataToStore = byArray;
            $memoryDoc.storeData(byteUpdate.getCoord().getAddress(), dataToStore, (Function1<Throwable, Unit>)((Function1)arg_0 -> CidrHexdumpTypedHandler.beforeCharTyped$lambda$0$0($editor, byteUpdate, $memoryDoc, $hexdumpRegion, arg_0)));
        }
        return TypedHandlerDelegate.Result.STOP;
    }

    private static final Unit beforeCharTyped$lambda$0$0(Editor $editor, CidrHexdumpByteUpdate $byteUpdate, CidrMemoryDoc $memoryDoc, CidrHexdumpRegion $hexdumpRegion, Throwable err) {
        if (err != null) {
            GotoAddressPanel gotoAddressPanel;
            TextEditor fileEditor = TextEditorProvider.Companion.getInstance().getTextEditor($editor);
            GotoAddressPanel gotoAddressPanel2 = gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor));
            if (gotoAddressPanel2 != null) {
                Object[] objectArray = new Object[]{String.valueOf($byteUpdate.getCoord().getAddress())};
                String string = CidrDebuggerBundle.message("debug.memory.failed.to.update.byte", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                gotoAddressPanel2.showError(string);
            }
        }
        $memoryDoc.getDocAccess().edit(arg_0 -> CidrHexdumpTypedHandler.beforeCharTyped$lambda$0$0$0($hexdumpRegion, $byteUpdate, err, arg_0));
        ((CidrDebuggerHexdumpDataProvider)$memoryDoc.getDataProvider()).getProcess().getSession().rebuildViews();
        return Unit.INSTANCE;
    }

    private static final Unit beforeCharTyped$lambda$0$0$0(CidrHexdumpRegion $hexdumpRegion, CidrHexdumpByteUpdate $byteUpdate, Throwable $err, CidrMemoryDocAccess.DocAccessScope $this$edit) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
        $hexdumpRegion.updateCompleted($byteUpdate, $err);
        return Unit.INSTANCE;
    }

    private static final CidrHexdumpRegion findRegion$lambda$0(int $offset, CidrMemoryDoc $memoryDoc, CidrMemoryDocAccess.DocAccessScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        int docLine = $this$read.getDocument().getLineNumber($offset);
        DocRegion docRegion = $memoryDoc.findRegionForLine(docLine);
        return docRegion instanceof CidrHexdumpRegion ? (CidrHexdumpRegion)docRegion : null;
    }
}

