/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.actions.CidrDebuggerRegisterSetsGroupKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLRegisterSet;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrInfoMessageValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegisterValue;
import icons.CidrDebuggerIcons;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "myProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "myFrame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;)V", "canNavigateToSource", "", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeChildren", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getRegistersToShow", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "RegistersToShow", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrRegistersValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrRegistersValue.kt\ncom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1460#2,5:114\n1208#2,2:119\n1236#2,4:121\n*S KotlinDebug\n*F\n+ 1 CidrRegistersValue.kt\ncom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue\n*L\n109#1:114,5\n57#1:119,2\n57#1:121,4\n*E\n"})
public final class CidrRegistersValue
extends XNamedValue {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final CidrStackFrame myFrame;

    public CidrRegistersValue(@NotNull CidrDebugProcess myProcess, @NotNull CidrStackFrame myFrame) {
        Intrinsics.checkNotNullParameter((Object)myProcess, (String)"myProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)myFrame), (String)"myFrame");
        super(CidrDebuggerBundle.message("debug.registers.value", new Object[0]));
        this.myProcess = myProcess;
        this.myFrame = myFrame;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        node.setPresentation(CidrDebuggerIcons.Registers, new XValuePresentation(){

            public String getSeparator() {
                return "";
            }

            public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            }
        }, true);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.myProcess.postCommand(arg_0 -> CidrRegistersValue.computeChildren$lambda$0(this, node, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final RegistersToShow getRegistersToShow(DebuggerDriver driver) {
        void destination$iv;
        void $this$flatMapTo$iv;
        String arch = null;
        List<LLRegisterSet> registerSets = null;
        try {
            String string = driver.getArchitecture();
            if (string == null) {
                string = "";
            }
            arch = string;
            List<LLRegisterSet> list = driver.getRegisterSets(this.myFrame.getThread(), this.myFrame.getFrame());
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRegisterSets(...)");
            registerSets = list;
        }
        catch (Exception e) {
            CidrDebuggerLog.LOG.warn((Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                String string2 = CidrDebuggerBundle.message("debug.error.failedToGetRegisters", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            return new RegistersToShow.Error(string);
        }
        if (registerSets.isEmpty()) {
            return RegistersToShow.ShowAllRegisters.INSTANCE;
        }
        String string = this.myProcess.getDriverName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDriverName(...)");
        String driverName = string;
        CidrDebuggerSettings cidrDebuggerSettings = CidrDebuggerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cidrDebuggerSettings), (String)"getInstance(...)");
        List<LLRegisterSet> enabledRegSets = CidrDebuggerRegisterSetsGroupKt.getEnabledRegisterSets(cidrDebuggerSettings, registerSets, arch, driverName);
        if (enabledRegSets.isEmpty()) {
            return RegistersToShow.AllRegisterSetsDisabled.INSTANCE;
        }
        Iterable iterable = enabledRegSets;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            LLRegisterSet it = (LLRegisterSet)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getRegisters();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        LinkedHashSet result = (LinkedHashSet)destination$iv;
        return new RegistersToShow.ShowSelected(result);
    }

    /*
     * WARNING - void declaration
     */
    private static final void computeChildren$lambda$0(CidrRegistersValue this$0, XCompositeNode $node, DebuggerDriver driver) {
        XValueChildrenList list;
        block10: {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            RegistersToShow registersToShow = this$0.getRegistersToShow(driver);
            list = new XValueChildrenList();
            try {
                RegistersToShow registersToShow2 = registersToShow;
                if (registersToShow2 instanceof RegistersToShow.Error) {
                    list.add((XNamedValue)new CidrErrorValue(((RegistersToShow.Error)registersToShow).getMessage()));
                    break block10;
                }
                if (Intrinsics.areEqual((Object)registersToShow2, (Object)RegistersToShow.AllRegisterSetsDisabled.INSTANCE)) {
                    list.add((XNamedValue)new CidrInfoMessageValue(CidrDebuggerBundle.message("debug.no.register.set.enabled", new Object[0])));
                    break block10;
                }
                if (Intrinsics.areEqual((Object)registersToShow2, (Object)RegistersToShow.ShowAllRegisters.INSTANCE)) {
                    List<LLValue> list2 = driver.getRegisters(this$0.myFrame.getThread(), this$0.myFrame.getFrame());
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getRegisters(...)");
                    List<LLValue> registerValues2 = list2;
                    for (LLValue regValue : registerValues2) {
                        list.add((XNamedValue)new CidrRegisterValue(this$0.myProcess, this$0.myFrame, regValue));
                    }
                    break block10;
                }
                if (registersToShow2 instanceof RegistersToShow.ShowSelected) {
                    void $this$associateByTo$iv$iv;
                    List<LLValue> list3 = driver.getRegisters(this$0.myFrame.getThread(), this$0.myFrame.getFrame(), (Set<String>)((RegistersToShow.ShowSelected)registersToShow).getRegisterNames());
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getRegisters(...)");
                    List<LLValue> registerValues3 = list3;
                    Iterable $this$associateBy$iv = registerValues3;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        LLValue lLValue = (LLValue)((Object)element$iv$iv);
                        Map map = destination$iv$iv;
                        boolean bl = false;
                        map.put(it.getName(), element$iv$iv);
                    }
                    Map regValueByName = destination$iv$iv;
                    Iterator iterator = ((RegistersToShow.ShowSelected)registersToShow).getRegisterNames().iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        LLValue regValue;
                        Object e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        String registerName = (String)e;
                        if ((LLValue)((Object)regValueByName.get(registerName)) == null) continue;
                        list.add((XNamedValue)new CidrRegisterValue(this$0.myProcess, this$0.myFrame, regValue));
                    }
                    break block10;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (DebuggerCommandException e) {
                String string = e.getMessage();
                if (string == null) {
                    String string2 = CidrDebuggerBundle.message("debug.error.failedToGetRegisters", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
                list.add((XNamedValue)new CidrErrorValue(string));
            }
        }
        $node.addChildren(list, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "", "Error", "ShowAllRegisters", "AllRegisterSetsDisabled", "ShowSelected", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$AllRegisterSetsDisabled;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$Error;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$ShowAllRegisters;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$ShowSelected;", "intellij.cidr.debugger.core"})
    private static sealed interface RegistersToShow {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$AllRegisterSetsDisabled;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.cidr.debugger.core"})
        public static final class AllRegisterSetsDisabled
        implements RegistersToShow {
            @NotNull
            public static final AllRegisterSetsDisabled INSTANCE = new AllRegisterSetsDisabled();

            private AllRegisterSetsDisabled() {
            }

            @NotNull
            public String toString() {
                return "AllRegisterSetsDisabled";
            }

            public int hashCode() {
                return 400616450;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AllRegisterSetsDisabled)) {
                    return false;
                }
                AllRegisterSetsDisabled cfr_ignored_0 = (AllRegisterSetsDisabled)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$Error;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cidr.debugger.core"})
        public static final class Error
        implements RegistersToShow {
            @NotNull
            private final String message;

            public Error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error.message;
                }
                return error.copy(string);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$ShowAllRegisters;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.cidr.debugger.core"})
        public static final class ShowAllRegisters
        implements RegistersToShow {
            @NotNull
            public static final ShowAllRegisters INSTANCE = new ShowAllRegisters();

            private ShowAllRegisters() {
            }

            @NotNull
            public String toString() {
                return "ShowAllRegisters";
            }

            public int hashCode() {
                return 762288571;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShowAllRegisters)) {
                    return false;
                }
                ShowAllRegisters cfr_ignored_0 = (ShowAllRegisters)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005H\u00c6\u0003J#\u0010\u000b\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow$ShowSelected;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRegistersValue$RegistersToShow;", "registerNames", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "<init>", "(Ljava/util/LinkedHashSet;)V", "getRegisterNames", "()Ljava/util/LinkedHashSet;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cidr.debugger.core"})
        public static final class ShowSelected
        implements RegistersToShow {
            @NotNull
            private final LinkedHashSet<String> registerNames;

            public ShowSelected(@NotNull LinkedHashSet<String> registerNames) {
                Intrinsics.checkNotNullParameter(registerNames, (String)"registerNames");
                this.registerNames = registerNames;
            }

            @NotNull
            public final LinkedHashSet<String> getRegisterNames() {
                return this.registerNames;
            }

            @NotNull
            public final LinkedHashSet<String> component1() {
                return this.registerNames;
            }

            @NotNull
            public final ShowSelected copy(@NotNull LinkedHashSet<String> registerNames) {
                Intrinsics.checkNotNullParameter(registerNames, (String)"registerNames");
                return new ShowSelected(registerNames);
            }

            public static /* synthetic */ ShowSelected copy$default(ShowSelected showSelected, LinkedHashSet linkedHashSet, int n, Object object) {
                if ((n & 1) != 0) {
                    linkedHashSet = showSelected.registerNames;
                }
                return showSelected.copy(linkedHashSet);
            }

            @NotNull
            public String toString() {
                return "ShowSelected(registerNames=" + this.registerNames + ")";
            }

            public int hashCode() {
                return this.registerNames.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShowSelected)) {
                    return false;
                }
                ShowSelected showSelected = (ShowSelected)other;
                return Intrinsics.areEqual(this.registerNames, showSelected.registerNames);
            }
        }
    }
}

