/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrBreakpointStatisticKind;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrExceptionBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrExceptionBreakpointType.Properties>, LLSymbolicBreakpoint> {
    public CidrExceptionBreakpointHandler(CidrDebugProcess process, Class<? extends CidrExceptionBreakpointType> typeClass) {
        super(process, typeClass, CidrBreakpointStatisticKind.Exception);
    }

    @Override
    protected Collection<LLSymbolicBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<CidrExceptionBreakpointType.Properties> breakpoint, long threadId, int n) throws ExecutionException {
        CidrExceptionBreakpointType.Properties properties;
        if (driver == null) {
            CidrExceptionBreakpointHandler.$$$reportNull$$$0(0);
        }
        if (breakpoint == null) {
            CidrExceptionBreakpointHandler.$$$reportNull$$$0(1);
        }
        if ((properties = (CidrExceptionBreakpointType.Properties)breakpoint.getProperties()) == null) {
            return Collections.emptyList();
        }
        ArrayList<LLSymbolicBreakpoint> result = new ArrayList<LLSymbolicBreakpoint>();
        for (String symbol : CidrExceptionBreakpointHandler.getExceptionSymbols(properties)) {
            try {
                ContainerUtil.addIfNotNull(result, (Object)driver.addSymbolicBreakpoint(symbol));
            }
            catch (DebuggerCommandException e) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    private static List<String> getExceptionSymbols(@NotNull CidrExceptionBreakpointType.Properties properties) {
        if (properties == null) {
            CidrExceptionBreakpointHandler.$$$reportNull$$$0(2);
        }
        CidrExceptionBreakpointType.Properties.Type thrown = properties.getWhenThrown();
        ArrayList<String> result = new ArrayList<String>(3);
        if (thrown != null) {
            if (thrown == CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION) {
                result.add("objc_exception_throw");
            } else if (thrown == CidrExceptionBreakpointType.Properties.Type.SWIFT_EXCEPTION) {
                result.add("swift_willThrow");
            } else if (thrown == CidrExceptionBreakpointType.Properties.Type.KN_EXCEPTION) {
                result.add("ThrowException");
            } else {
                result.add("__cxa_throw");
                result.add("swift_willThrow");
                result.add("_CxxThrowException");
            }
        }
        if (properties.getWhenCaught() != null) {
            result.add("__cxa_begin_catch");
            result.add("swift_errorRetain");
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCodepointsInBackend";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExceptionSymbols";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

