/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrBreakpointStatisticKind;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerBase;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\u0018\u00002\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016J8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0014J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0004J\u001c\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001bJ\u001c\u0010#\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001bJ\u001c\u0010$\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u001bJ\"\u0010&\u001a\u00020\u00192\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010(\u001a\u00020\u000fH\u0002J\u001a\u0010)\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0002R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointHandler;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrCleanableBreakpointHandlerBase;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpoint;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myLocationsMap", "", "", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpointLocation;", "shouldBreakpointBeRemoved", "", "breakpoint", "addCodepointsInBackend", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "threadId", "", "frameIndex", "removeCodepointsInBackend", "", "ids", "", "handleBreakpointAdded", "handleBreakpointRemoved", "breakpointId", "handleBreakpointUpdated", "newBreakpoint", "handleBreakpointLocationsReplaced", "locations", "handleBreakpointLocationsUpdated", "handleBreakpointLocationsRemoved", "locationIds", "updateBreakpointPresentation", "uiBreakpoint", "resolved", "isOurBreakpoint", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrAddressBreakpointHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrAddressBreakpointHandler.kt\ncom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1208#2,2:151\n1236#2,4:153\n1208#2,2:157\n1236#2,4:159\n*S KotlinDebug\n*F\n+ 1 CidrAddressBreakpointHandler.kt\ncom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointHandler\n*L\n39#1:151,2\n39#1:153,4\n90#1:157,2\n90#1:159,4\n*E\n"})
public final class CidrAddressBreakpointHandler
extends CidrCleanableBreakpointHandlerBase<XLineBreakpoint<XBreakpointProperties<?>>, LLBreakpoint> {
    @NotNull
    private final Map<Integer, Map<String, LLBreakpointLocation>> myLocationsMap;

    public CidrAddressBreakpointHandler(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        super(process, CidrAddressBreakpointType.class, CidrBreakpointStatisticKind.Address);
        this.myLocationsMap = new LinkedHashMap();
    }

    @Override
    public boolean shouldBreakpointBeRemoved(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return this.isOurBreakpoint(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<LLBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!this.isOurBreakpoint(breakpoint)) {
            CidrDebuggerLog.LOG.debug("Address breakpoint doesn't belong to process memory " + breakpoint + ", skip adding it");
            return CollectionsKt.emptyList();
        }
        Address address = CidrAddressBreakpointType.Companion.breakpointToAddress(breakpoint);
        if (address == null) {
            return CollectionsKt.emptyList();
        }
        Address address2 = address;
        try {
            void $this$associateByTo$iv$iv;
            DebuggerDriver.AddBreakpointResult addBreakpointResult = driver.addAddressBreakpoint(address2, this.convertCondition((XBreakpoint)breakpoint));
            Intrinsics.checkNotNullExpressionValue((Object)addBreakpointResult, (String)"addAddressBreakpoint(...)");
            DebuggerDriver.AddBreakpointResult result = addBreakpointResult;
            LLBreakpoint lLBreakpoint = result.getBreakpoint();
            Intrinsics.checkNotNullExpressionValue((Object)lLBreakpoint, (String)"getBreakpoint(...)");
            LLBreakpoint brk = lLBreakpoint;
            List<LLBreakpointLocation> list = result.getBreakpointLocations();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBreakpointLocations(...)");
            List<LLBreakpointLocation> brkLocations = list;
            Iterable $this$associateBy$iv = brkLocations;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                LLBreakpointLocation lLBreakpointLocation = (LLBreakpointLocation)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getId(), element$iv$iv);
            }
            Map brkLocationsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                boolean bl = false;
                this.myLocationsMap.put(brk.getId(), brkLocationsMap);
                Unit unit = Unit.INSTANCE;
            }
            this.updateBreakpointPresentation(breakpoint, !((Collection)brkLocations).isEmpty());
            CidrDebuggerLog.LOG.debug("Address breakpoint added: " + breakpoint);
            return CollectionsKt.listOf((Object)result.getBreakpoint());
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug("Failed to add address breakpoint", (Throwable)e);
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) throws ExecutionException, DebuggerCommandException {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        try {
            super.removeCodepointsInBackend(driver, ids, (XBreakpoint)breakpoint);
        }
        finally {
            Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
            synchronized (map) {
                boolean bl = false;
                Iterator<Integer> iterator = ids.iterator();
                while (iterator.hasNext()) {
                    int id = ((Number)iterator.next()).intValue();
                    this.myLocationsMap.remove(id);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
    }

    public final void handleBreakpointRemoved(int breakpointId) {
    }

    public final void handleBreakpointUpdated(int breakpointId, @NotNull LLBreakpoint newBreakpoint) {
        Intrinsics.checkNotNullParameter((Object)newBreakpoint, (String)"newBreakpoint");
        this.updateCodepoint(breakpointId, (LLCodepoint)newBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean bl;
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            void $this$associateByTo$iv$iv;
            boolean bl2 = false;
            if (this.myLocationsMap.get(breakpointId) == null) {
                return;
            }
            Iterable $this$associateBy$iv = locations;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                LLBreakpointLocation lLBreakpointLocation = (LLBreakpointLocation)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl3 = false;
                map2.put(it.getId(), element$iv$iv);
            }
            Map locationsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            this.myLocationsMap.put(breakpointId, locationsMap);
            bl = !locationsMap.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean bl;
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            boolean bl2 = false;
            Map<String, LLBreakpointLocation> map2 = this.myLocationsMap.get(breakpointId);
            if (map2 == null) {
                return;
            }
            Map<String, LLBreakpointLocation> locationsMap = map2;
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            bl = !locationsMap.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        boolean bl;
        Intrinsics.checkNotNullParameter(locationIds, (String)"locationIds");
        Map<Integer, Map<String, LLBreakpointLocation>> map = this.myLocationsMap;
        synchronized (map) {
            boolean bl2 = false;
            Map<String, LLBreakpointLocation> map2 = this.myLocationsMap.get(breakpointId);
            if (map2 == null) {
                return;
            }
            Map<String, LLBreakpointLocation> locationsMap = map2;
            for (String id : locationIds) {
                locationsMap.remove(id);
            }
            bl = !locationsMap.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    private final void updateBreakpointPresentation(XLineBreakpoint<XBreakpointProperties<?>> uiBreakpoint, boolean resolved) {
        String error = this.getError((XBreakpoint)uiBreakpoint);
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("Update presentation for " + uiBreakpoint + ", resolved: " + resolved + ", error: " + error);
        }
        if (resolved) {
            if (error != null) {
                this.setErrorPresentation((XBreakpoint)uiBreakpoint, error);
            } else {
                this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
            }
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }

    private final boolean isOurBreakpoint(XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return false;
        }
        XSourcePosition pos = xSourcePosition;
        return this.myProcess.fileToMemoryDoc(pos.getFile()) != null;
    }
}

