/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CidrRichValueBuilder;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0003"}, d2={"extractRichStringDescription", "", "description", "intellij.cidr.debugger.core"})
@JvmName(name="LLDBValueDescription")
public final class LLDBValueDescription {
    @Nullable
    public static final String extractRichStringDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = ValueRendererUtils.trimStringPrefix(description);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStringPrefix(...)");
        String noPrefix = string;
        String string2 = description.substring(0, description.length() - noPrefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String prefix = string2;
        if (StringsKt.startsWith$default((String)noPrefix, (String)"\"", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)noPrefix, (String)"\"", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)noPrefix, (String)"\"...", (boolean)false, (int)2, null))) {
            Object object;
            if (StringsKt.endsWith$default((String)noPrefix, (String)"\"...", (boolean)false, (int)2, null)) {
                String string3 = noPrefix.substring(0, noPrefix.length() - 4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object = string3 + "...\"";
            } else {
                object = noPrefix;
            }
            String stringContents = object;
            int quoteCount = ValueRendererUtils.getQuoteCount(stringContents);
            if (quoteCount == 2) {
                String string4 = ValueRendererUtils.unescapeForRichString(stringContents);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"unescapeForRichString(...)");
                String unescaped = string4;
                return new CidrRichValueBuilder().appendString(prefix + unescaped).getRichValue();
            }
        }
        return null;
    }
}

