/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBBreakpointErrorDetector;", "", "myHandler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;)V", "errorPattern", "Ljava/util/regex/Pattern;", "processStderrMessage", "", "message", "", "intellij.cidr.debugger.core"})
public final class LLDBBreakpointErrorDetector {
    @NotNull
    private final DebuggerDriver.Handler myHandler;
    @NotNull
    private final Pattern errorPattern;

    public LLDBBreakpointErrorDetector(@NotNull DebuggerDriver.Handler myHandler) {
        Intrinsics.checkNotNullParameter((Object)myHandler, (String)"myHandler");
        this.myHandler = myHandler;
        Pattern pattern = Pattern.compile("(?:error: )?[Ss]topped due to an error evaluating condition of (?:breakpoint|watchpoint) ([0-9]+).*", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.errorPattern = pattern;
    }

    public final void processStderrMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Matcher matcher = this.errorPattern.matcher(message);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            Integer id = StringsKt.toIntOrNull((String)string);
            if (id != null) {
                this.myHandler.handleBreakpointError(id, LLDBBundle.message("error.breakpoint.condition", new Object[0]));
            }
        }
    }
}

