/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbExtractedDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CidrRichValueBuilder;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"VALUE_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "extractDescription", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbExtractedDescription;", "gdbValue", "", "extractRichStrings", "", "intellij.cidr.debugger.core"})
@JvmName(name="GdbValueDescription")
public final class GdbValueDescription {
    private static final Pattern VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: ((?:L|U|u|u8)?\".*\"(?:\\.\\.\\.)?))?$");

    @NotNull
    public static final GdbExtractedDescription extractDescription(@NotNull String gdbValue, boolean extractRichStrings) {
        Intrinsics.checkNotNullParameter((Object)gdbValue, (String)"gdbValue");
        String value = gdbValue;
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            value = string;
            description = matcher.group(2);
        }
        if (description == null) {
            description = value;
        }
        boolean isRich = false;
        if (extractRichStrings) {
            String string = ValueRendererUtils.trimStringPrefix(description);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStringPrefix(...)");
            String noPrefix = string;
            String string2 = description.substring(0, description.length() - noPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String prefix = string2;
            if (StringsKt.startsWith$default((String)noPrefix, (String)"\"", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)noPrefix, (String)"\"", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)noPrefix, (String)"\"...", (boolean)false, (int)2, null))) {
                Object object;
                if (StringsKt.endsWith$default((String)noPrefix, (String)"\"...", (boolean)false, (int)2, null)) {
                    String string3 = noPrefix.substring(0, noPrefix.length() - 4);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    object = string3 + "...\"";
                } else {
                    object = noPrefix;
                }
                String quotedString = object;
                int quoteCount = ValueRendererUtils.getQuoteCount(quotedString);
                if (quoteCount == 2) {
                    String string4 = ValueRendererUtils.unescapeForRichString(quotedString);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"unescapeForRichString(...)");
                    String unescaped = string4;
                    description = new CidrRichValueBuilder().appendString(prefix + unescaped).getRichValue();
                    isRich = true;
                }
            }
        }
        return new GdbExtractedDescription(value, description, isRich);
    }
}

