/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrLocalDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexerKt;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexingSession;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "readElfInstalled", "", "INDEX_DIR_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "configureBeforeTargetLoaded", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "configure", "intellij.cidr.debugger.core"})
public final class GdbIndexConfigurator
implements CidrDebugProcessConfigurator {
    private volatile boolean readElfInstalled;
    private final Pattern INDEX_DIR_PATTERN = Pattern.compile("The directory of the index cache is \"(.*)\".");

    @Override
    public void configureBeforeTargetLoaded(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debuggerDriverConfiguration), (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration driverConfiguration = debuggerDriverConfiguration;
        if (!(process instanceof CidrLocalDebugProcess) || driverConfiguration.getHostMachine().isRemote()) {
            return;
        }
        if (!SystemInfo.isLinux) {
            return;
        }
        GDBDriverConfiguration gDBDriverConfiguration = driverConfiguration instanceof GDBDriverConfiguration ? (GDBDriverConfiguration)driverConfiguration : null;
        if (!(gDBDriverConfiguration != null ? gDBDriverConfiguration.isPrepareGdbIndexes() : false)) {
            return;
        }
        process.postCommand(arg_0 -> GdbIndexConfigurator.configureBeforeTargetLoaded$lambda$0(this, process, driverConfiguration, arg_0));
    }

    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
    }

    private static final void configureBeforeTargetLoaded$lambda$0(GdbIndexConfigurator this$0, CidrDebugProcess $process, DebuggerDriverConfiguration $driverConfiguration, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        GDBDriver cfr_ignored_0 = (GDBDriver)driver;
        if (!this$0.readElfInstalled) {
            this$0.readElfInstalled = GdbIndexerKt.access$isReadElfInstalled();
        }
        if (!this$0.readElfInstalled) {
            CidrDebuggerLog.LOG.info("Gdb index: readelf is not installed, skip indexing");
            return;
        }
        try {
            ((GDBDriver)driver).executeInterpreterCommand(-1L, -1, "set index-cache enabled on");
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Gdb index: failed to enabled index-cache in gdb, skip indexing");
            return;
        }
        String gdbIndexDir = null;
        try {
            String string = ((GDBDriver)driver).executeInterpreterCommand(-1L, -1, "show index-cache directory");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
            String output = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Matcher matcher = this$0.INDEX_DIR_PATTERN.matcher(output);
            if (!matcher.matches()) {
                CidrDebuggerLog.LOG.warn("Gdb index: failed to parse index-cache directory, skip indexing");
                return;
            }
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            gdbIndexDir = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Gdb index: failed to get index-cache directory, skip indexing");
            return;
        }
        GdbIndexer gdbIndexer = GdbIndexer.Companion.getInstance();
        Project project = $process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        String string = ((GDBDriverConfiguration)$driverConfiguration).getGDBExecutablePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGDBExecutablePath(...)");
        File file = ((CidrLocalDebugProcess)$process).getRunParameters().getInstaller().getExecutableFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getExecutableFile(...)");
        GdbIndexingSession indexingSession = gdbIndexer.scheduleIndexing(project, string, gdbIndexDir, file);
        Disposer.register((Disposable)((CidrLocalDebugProcess)$process).getProcessDisposable(), () -> GdbIndexConfigurator.configureBeforeTargetLoaded$lambda$0$0(indexingSession));
        ((GDBDriver)driver).setGdbIndexingSession(indexingSession);
        CidrDebuggerUsagesCollector.INSTANCE.logGdbIndexingUsed();
    }

    private static final void configureBeforeTargetLoaded$lambda$0$0(GdbIndexingSession $indexingSession) {
        if (!$indexingSession.getIndexingJob().isCompleted()) {
            CidrDebuggerLog.LOG.debug(GdbIndexerKt.access$getLogPrefix($indexingSession) + ": debug process terminates, cancel indexing");
            Job.DefaultImpls.cancel$default((Job)$indexingSession.getIndexingJob(), null, (int)1, null);
        }
    }
}

