/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbBreakpointErrorDetector;", "", "myHandler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;)V", "myBreakpointNum", "", "Ljava/lang/Integer;", "processLogMessage", "", "message", "", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nGdbBreakpointErrorDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbBreakpointErrorDetector.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbBreakpointErrorDetector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,38:1\n648#2,5:39\n*S KotlinDebug\n*F\n+ 1 GdbBreakpointErrorDetector.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbBreakpointErrorDetector\n*L\n34#1:39,5\n*E\n"})
public final class GdbBreakpointErrorDetector {
    @NotNull
    private final DebuggerDriver.Handler myHandler;
    @Nullable
    private Integer myBreakpointNum;

    public GdbBreakpointErrorDetector(@NotNull DebuggerDriver.Handler myHandler) {
        Intrinsics.checkNotNullParameter((Object)myHandler, (String)"myHandler");
        this.myHandler = myHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void processLogMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Integer breakpointNum = this.myBreakpointNum;
        if (breakpointNum != null) {
            String errorMessage = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)message)).toString(), (CharSequence)".");
            Object[] objectArray = new Object[]{errorMessage};
            this.myHandler.handleBreakpointError(breakpointNum, GDBBundle.message("error.breakpoint.condition", objectArray));
            this.myBreakpointNum = null;
            return;
        }
        String suffix = StringsKt.removePrefix((String)message, (CharSequence)"Error in testing condition for breakpoint ");
        if (!Intrinsics.areEqual((Object)suffix, (Object)message)) {
            String string;
            block3: {
                void $this$takeWhile$iv;
                String string2 = suffix;
                GdbBreakpointErrorDetector gdbBreakpointErrorDetector = this;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (Character.isDigit(it)) continue;
                    void var8_12 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = var8_12.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block3;
                }
                string = $this$takeWhile$iv;
            }
            gdbBreakpointErrorDetector.myBreakpointNum = StringsKt.toIntOrNull((String)string);
        }
    }
}

