/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBRegisterValue;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0005"}, d2={"parseRawValue", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBRegisterValue;", "value", "", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbParser$RawRegValContext;", "intellij.cidr.debugger.core"})
public final class GDBRegistersKt {
    @NotNull
    public static final GDBRegisterValue parseRawValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ANTLRInputStream input = new ANTLRInputStream(value);
        GdbLexer lexer = new GdbLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        try {
            GdbParser parser = new GdbParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            GdbParser.RawRegValContext regVal = parser.rawRegVal();
            return GDBRegistersKt.parseRawValue(regVal);
        }
        catch (Exception e) {
            return new GDBRegisterValue("", false);
        }
    }

    private static final GDBRegisterValue parseRawValue(GdbParser.RawRegValContext value) {
        GdbParser.RawRegValUnionContext union;
        GdbParser.RawRegValListContext list;
        GdbParser.RawRegValHexContext hex;
        GdbParser.RawRegValContext rawRegValContext = value;
        GdbParser.RawRegValHexContext rawRegValHexContext = hex = rawRegValContext != null ? rawRegValContext.rawRegValHex() : null;
        if (hex != null) {
            String string = hex.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new GDBRegisterValue(string, false);
        }
        GdbParser.RawRegValContext rawRegValContext2 = value;
        GdbParser.RawRegValListContext rawRegValListContext = list = rawRegValContext2 != null ? rawRegValContext2.rawRegValList() : null;
        if (list != null) {
            List<GdbParser.RawRegValHexContext> list2 = list.rawRegValHex();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"rawRegValHex(...)");
            List hexReversed = CollectionsKt.reversed((Iterable)list2);
            String hexCombined = CollectionsKt.joinToString$default((Iterable)hexReversed, (CharSequence)"", (CharSequence)"0x", null, (int)0, null, GDBRegistersKt::parseRawValue$lambda$0, (int)28, null);
            return new GDBRegisterValue(hexCombined, true);
        }
        GdbParser.RawRegValContext rawRegValContext3 = value;
        GdbParser.RawRegValUnionContext rawRegValUnionContext = union = rawRegValContext3 != null ? rawRegValContext3.rawRegValUnion() : null;
        if (union != null) {
            Object object = union.rawRegValUnionEntry();
            GDBRegisterValue parsed = GDBRegistersKt.parseRawValue(object != null && (object = (GdbParser.RawRegValUnionEntryContext)((Object)CollectionsKt.firstOrNull(object))) != null ? ((GdbParser.RawRegValUnionEntryContext)((Object)object)).rawRegVal() : null);
            return new GDBRegisterValue(parsed.hex, true);
        }
        return new GDBRegisterValue("", false);
    }

    private static final CharSequence parseRawValue$lambda$0(GdbParser.RawRegValHexContext it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 2;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }
}

