/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.dap;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0003J\"\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapPathMapping;", "", "myDebuggerPath", "", "myIdePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMyDebuggerPath", "()Ljava/lang/String;", "getMyIdePath", "mapToIdePath", "debuggerPath", "mapToDebuggerPath", "idePath", "map", "path", "from", "to", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.debugger.dap"})
public final class DapPathMapping {
    @NotNull
    private final String myDebuggerPath;
    @NotNull
    private final String myIdePath;

    public DapPathMapping(@NotNull String myDebuggerPath, @NotNull String myIdePath) {
        Intrinsics.checkNotNullParameter((Object)myDebuggerPath, (String)"myDebuggerPath");
        Intrinsics.checkNotNullParameter((Object)myIdePath, (String)"myIdePath");
        this.myDebuggerPath = myDebuggerPath;
        this.myIdePath = myIdePath;
    }

    @NotNull
    public final String getMyDebuggerPath() {
        return this.myDebuggerPath;
    }

    @NotNull
    public final String getMyIdePath() {
        return this.myIdePath;
    }

    @Nullable
    public final String mapToIdePath(@NotNull String debuggerPath) {
        Intrinsics.checkNotNullParameter((Object)debuggerPath, (String)"debuggerPath");
        return this.map(debuggerPath, this.myDebuggerPath, this.myIdePath);
    }

    @Nullable
    public final String mapToDebuggerPath(@NotNull String idePath) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        return this.map(idePath, this.myIdePath, this.myDebuggerPath);
    }

    private final String map(String path, String from, String to) {
        if (!StringsKt.startsWith$default((String)path, (String)from, (boolean)false, (int)2, null)) {
            return null;
        }
        if (path.length() == from.length()) {
            return to;
        }
        if ((StringsKt.endsWith$default((CharSequence)from, (char)'/', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)from, (char)'\\', (boolean)false, (int)2, null)) && (StringsKt.endsWith$default((CharSequence)to, (char)'/', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)to, (char)'\\', (boolean)false, (int)2, null))) {
            String string = path.substring(from.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return to + string;
        }
        char nextChar = path.charAt(from.length());
        switch (nextChar) {
            case '/': 
            case '\\': {
                String string = path.substring(from.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return to + string;
            }
        }
        return null;
    }

    @NotNull
    public final String component1() {
        return this.myDebuggerPath;
    }

    @NotNull
    public final String component2() {
        return this.myIdePath;
    }

    @NotNull
    public final DapPathMapping copy(@NotNull String myDebuggerPath, @NotNull String myIdePath) {
        Intrinsics.checkNotNullParameter((Object)myDebuggerPath, (String)"myDebuggerPath");
        Intrinsics.checkNotNullParameter((Object)myIdePath, (String)"myIdePath");
        return new DapPathMapping(myDebuggerPath, myIdePath);
    }

    public static /* synthetic */ DapPathMapping copy$default(DapPathMapping dapPathMapping, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = dapPathMapping.myDebuggerPath;
        }
        if ((n & 2) != 0) {
            string2 = dapPathMapping.myIdePath;
        }
        return dapPathMapping.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "DapPathMapping(myDebuggerPath=" + this.myDebuggerPath + ", myIdePath=" + this.myIdePath + ")";
    }

    public int hashCode() {
        int result = this.myDebuggerPath.hashCode();
        result = result * 31 + this.myIdePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DapPathMapping)) {
            return false;
        }
        DapPathMapping dapPathMapping = (DapPathMapping)other;
        if (!Intrinsics.areEqual((Object)this.myDebuggerPath, (Object)dapPathMapping.myDebuggerPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.myIdePath, (Object)dapPathMapping.myIdePath);
    }
}

