/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.dap;

import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.dap.DapAddress;
import com.jetbrains.cidr.execution.debugger.backend.dap.DapPathMapper;
import com.jetbrains.cidr.execution.debugger.backend.dap.DebuggerPath;
import com.jetbrains.cidr.execution.debugger.backend.dap.breakpoints.CidrDapInstructionBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.dap.breakpoints.CidrDapSourceBreakpoint;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0019\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0010\u001a\u00020\u0011*\u0004\u0018\u00010\u0012\u001a.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0018"}, d2={"toLLBreakpoint", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpoint;", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/breakpoints/CidrDapSourceBreakpoint;", "codepointId", "", "pathMapper", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapPathMapper;", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/breakpoints/CidrDapInstructionBreakpoint;", "getIdePath", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/IdePath;", "Lorg/eclipse/lsp4j/debug/Source;", "(Lorg/eclipse/lsp4j/debug/Source;Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapPathMapper;)Ljava/lang/String;", "getFileLocation", "Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;", "Lorg/eclipse/lsp4j/debug/Breakpoint;", "getVerifiedFileLocation", "toAddressSafe", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "", "getVerifiedBreakpointLocations", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpointLocation;", "existingBreakpoint", "updatedBreakpoint", "intellij.cidr.debugger.dap"})
@SourceDebugExtension(value={"SMAP\nCidrDapConversions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDapConversions.kt\ncom/jetbrains/cidr/execution/debugger/backend/dap/CidrDapConversionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class CidrDapConversionsKt {
    @NotNull
    public static final LLBreakpoint toLLBreakpoint(@NotNull CidrDapSourceBreakpoint $this$toLLBreakpoint, int codepointId, @NotNull DapPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$toLLBreakpoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        return new LLBreakpoint(codepointId, pathMapper.mapToIdePath-1azDEqo($this$toLLBreakpoint.getDebuggerPath-ygzhc-0()), $this$toLLBreakpoint.getLine(), $this$toLLBreakpoint.getCondition());
    }

    @NotNull
    public static final LLBreakpoint toLLBreakpoint(@NotNull CidrDapInstructionBreakpoint $this$toLLBreakpoint, int codepointId) {
        Intrinsics.checkNotNullParameter((Object)$this$toLLBreakpoint, (String)"<this>");
        return new LLBreakpoint(codepointId, "<address>", 0, $this$toLLBreakpoint.getCondition());
    }

    @Nullable
    public static final String getIdePath(@NotNull Source $this$getIdePath, @NotNull DapPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$getIdePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        String string = $this$getIdePath.getPath();
        if (string == null) {
            return null;
        }
        String debuggerPath = string;
        String idePath = pathMapper.mapToIdePath-1azDEqo(DebuggerPath.constructor-impl(debuggerPath));
        return idePath;
    }

    @Nullable
    public static final FileLocation getFileLocation(@NotNull Breakpoint $this$getFileLocation, @NotNull DapPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Object object = $this$getFileLocation.getSource();
        if (object == null || (object = CidrDapConversionsKt.getIdePath(object, pathMapper)) == null) {
            return null;
        }
        Object idePath = object;
        Integer n = $this$getFileLocation.getLine();
        return new FileLocation((String)idePath, n != null ? n : 0);
    }

    @Nullable
    public static final FileLocation getVerifiedFileLocation(@NotNull Breakpoint $this$getVerifiedFileLocation, @NotNull DapPathMapper pathMapper) {
        Breakpoint breakpoint;
        Intrinsics.checkNotNullParameter((Object)$this$getVerifiedFileLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Breakpoint it = breakpoint = $this$getVerifiedFileLocation;
        boolean bl = false;
        Object object = it.isVerified() ? breakpoint : null;
        return object != null ? CidrDapConversionsKt.getFileLocation(object, pathMapper) : null;
    }

    @NotNull
    public static final Address toAddressSafe(@Nullable String $this$toAddressSafe) {
        return DapAddress.toAddressSafe-impl(DapAddress.constructor-impl($this$toAddressSafe));
    }

    @NotNull
    public static final List<LLBreakpointLocation> getVerifiedBreakpointLocations(int codepointId, @NotNull CidrDapSourceBreakpoint existingBreakpoint, @NotNull Breakpoint updatedBreakpoint, @NotNull DapPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)existingBreakpoint, (String)"existingBreakpoint");
        Intrinsics.checkNotNullParameter((Object)updatedBreakpoint, (String)"updatedBreakpoint");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        if (!updatedBreakpoint.isVerified()) {
            return CollectionsKt.emptyList();
        }
        if (updatedBreakpoint.getSource() == null) {
            Address breakpointAddress = CidrDapConversionsKt.toAddressSafe(updatedBreakpoint.getInstructionReference());
            String idePath = pathMapper.mapToIdePath-1azDEqo(existingBreakpoint.getDebuggerPath-ygzhc-0());
            FileLocation location = new FileLocation(idePath, existingBreakpoint.getLine());
            return CollectionsKt.listOf((Object)new LLBreakpointLocation(String.valueOf(codepointId), breakpointAddress, location));
        }
        FileLocation fileLocation = CidrDapConversionsKt.getFileLocation(updatedBreakpoint, pathMapper);
        return CollectionsKt.listOf((Object)new LLBreakpointLocation(String.valueOf(codepointId), CidrDapConversionsKt.toAddressSafe(updatedBreakpoint.getInstructionReference()), fileLocation));
    }

    @NotNull
    public static final List<LLBreakpointLocation> getVerifiedBreakpointLocations(int codepointId, @NotNull CidrDapInstructionBreakpoint existingBreakpoint, @NotNull Breakpoint updatedBreakpoint, @NotNull DapPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)existingBreakpoint, (String)"existingBreakpoint");
        Intrinsics.checkNotNullParameter((Object)updatedBreakpoint, (String)"updatedBreakpoint");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        if (!updatedBreakpoint.isVerified()) {
            return CollectionsKt.emptyList();
        }
        Object object = updatedBreakpoint.getInstructionReference();
        if (object == null || (object = CidrDapConversionsKt.toAddressSafe((String)object)) == null) {
            object = CidrDapConversionsKt.toAddressSafe(existingBreakpoint.getInstructionReference());
        }
        Object breakpointAddress = object;
        FileLocation fileLocation = CidrDapConversionsKt.getFileLocation(updatedBreakpoint, pathMapper);
        return CollectionsKt.listOf((Object)new LLBreakpointLocation(String.valueOf(codepointId), (Address)breakpointAddress, fileLocation));
    }
}

