/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValue
extends UserDataHolderBase {
    @NotNull
    private final String myName;
    @NotNull
    private final String myType;
    @NotNull
    private final String myDisplayType;
    @Nullable
    private final Long myAddress;
    @Nullable
    private final TypeClass myTypeClass;
    @NotNull
    private final String myReferenceExpression;
    @Nullable
    private final String myFullExpression;
    private boolean myValid;

    public LLValue(@NotNull String name, @NotNull String type, @Nullable Long address, @Nullable TypeClass typeClass, @NotNull String referenceExpression) {
        if (name == null) {
            LLValue.$$$reportNull$$$0(0);
        }
        if (type == null) {
            LLValue.$$$reportNull$$$0(1);
        }
        if (referenceExpression == null) {
            LLValue.$$$reportNull$$$0(2);
        }
        this(name, type, type, address, typeClass, referenceExpression, null);
    }

    public LLValue(@NotNull String name, @NotNull String type, @NotNull String displayType, @Nullable Long address, @Nullable TypeClass typeClass, @NotNull String referenceExpression) {
        if (name == null) {
            LLValue.$$$reportNull$$$0(3);
        }
        if (type == null) {
            LLValue.$$$reportNull$$$0(4);
        }
        if (displayType == null) {
            LLValue.$$$reportNull$$$0(5);
        }
        if (referenceExpression == null) {
            LLValue.$$$reportNull$$$0(6);
        }
        this(name, type, displayType, address, typeClass, referenceExpression, null);
    }

    public LLValue(@NotNull String name, @NotNull String type, @NotNull String displayType, @Nullable Long address, @Nullable TypeClass typeClass, @NotNull String referenceExpression, @Nullable String fullExpression) {
        if (name == null) {
            LLValue.$$$reportNull$$$0(7);
        }
        if (type == null) {
            LLValue.$$$reportNull$$$0(8);
        }
        if (displayType == null) {
            LLValue.$$$reportNull$$$0(9);
        }
        if (referenceExpression == null) {
            LLValue.$$$reportNull$$$0(10);
        }
        this.myValid = true;
        this.myName = name;
        this.myType = type;
        this.myDisplayType = displayType;
        this.myAddress = address;
        this.myTypeClass = typeClass;
        this.myReferenceExpression = referenceExpression;
        this.myFullExpression = StringUtil.nullize((String)fullExpression);
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LLValue.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            LLValue.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDisplayType() {
        String string = this.myDisplayType;
        if (string == null) {
            LLValue.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Long getAddress() {
        return this.myAddress;
    }

    @Nullable
    public TypeClass getTypeClass() {
        return this.myTypeClass;
    }

    @NotNull
    public String getReferenceExpression() {
        String string = this.myReferenceExpression;
        if (string == null) {
            LLValue.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String getFullExpression() {
        return this.myFullExpression;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    public String toString() {
        return this.myName + ":" + this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LLValue value = (LLValue)((Object)o);
        if (this.myValid != value.myValid) {
            return false;
        }
        if (!this.myName.equals(value.myName)) {
            return false;
        }
        if (!this.myType.equals(value.myType)) {
            return false;
        }
        if (!this.myDisplayType.equals(value.myDisplayType)) {
            return false;
        }
        if (!Objects.equals(this.myAddress, value.myAddress)) {
            return false;
        }
        if (this.myTypeClass != value.myTypeClass) {
            return false;
        }
        if (!this.myReferenceExpression.equals(value.myReferenceExpression)) {
            return false;
        }
        return Objects.equals(this.myFullExpression, value.myFullExpression);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myDisplayType.hashCode();
        result = 31 * result + (this.myAddress != null ? this.myAddress.hashCode() : 0);
        result = 31 * result + (this.myTypeClass != null ? this.myTypeClass.hashCode() : 0);
        result = 31 * result + this.myReferenceExpression.hashCode();
        result = 31 * result + (this.myFullExpression != null ? this.myFullExpression.hashCode() : 0);
        result = 31 * result + (this.myValid ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static enum TypeClass {
        CLASS_STRUCT,
        OBJC_POINTER,
        FUNCTION,
        BUILTIN,
        POINTER;

    }
}

