/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    public static final String ADDRESS_BREAKPOINT_FILE = "<address>";
    @NotNull
    private final String myOrigFile;
    private final int myOrigLine;
    @Nullable
    private final String myCondition;

    public LLBreakpoint(int id, @NotNull String file, int line, @Nullable String condition) {
        if (file == null) {
            LLBreakpoint.$$$reportNull$$$0(0);
        }
        super(id);
        this.myOrigFile = file;
        this.myOrigLine = line;
        this.myCondition = condition;
    }

    @NotNull
    public String getOrigFile() {
        String string = this.myOrigFile;
        if (string == null) {
            LLBreakpoint.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getOrigLine() {
        return this.myOrigLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    public boolean isAddressBreakpoint() {
        return this.myOrigFile.equals(ADDRESS_BREAKPOINT_FILE);
    }

    public String toString() {
        String result = "Breakpoint-" + this.getId() + "@" + this.getOrigFile() + ":" + this.getOrigLine();
        if (this.myCondition != null) {
            result = result + ":condition:" + this.myCondition;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myOrigLine != that.myOrigLine) {
            return false;
        }
        if (!this.myOrigFile.equals(that.myOrigFile)) {
            return false;
        }
        return Objects.equals(this.myCondition, that.myCondition);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myOrigFile.hashCode();
        result = 31 * result + this.myOrigLine;
        result = 31 * result + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

