/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\r\u001a\u00020\u0005*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/ShowMemoryViewInEditorAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "withClosingToReopen", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function0;", "intellij.cidr.debugger.core"})
public final class ShowMemoryViewInEditorAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CidrDebugProcess cidrDebugProcess = this.getDebugProcess(e);
        if (cidrDebugProcess == null) {
            return;
        }
        CidrDebugProcess debugProcess = cidrDebugProcess;
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        Project project2 = project;
        MemoryViewPanel memoryViewPanel = debugProcess.getHexdumpViewPanel();
        if (memoryViewPanel == null) {
            return;
        }
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        VirtualFile virtualFile = memoryViewPanel2.getFileEditor().getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        this.withClosingToReopen(file, (Function0<Unit>)((Function0)() -> ShowMemoryViewInEditorAction.actionPerformed$lambda$0(project2, file, memoryViewPanel2)));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CidrDebugProcess debugProcess = this.getDebugProcess(e);
        Object object = debugProcess;
        VirtualFile memoryViewFile = object != null && (object = ((CidrDebugProcess)object).getHexdumpViewPanel()) != null && (object = ((MemoryViewPanel)object).getFileEditor()) != null ? object.getFile() : null;
        e.getPresentation().setVisible(debugProcess != null);
        e.getPresentation().setEnabled(memoryViewFile != null);
    }

    private final CidrDebugProcess getDebugProcess(AnActionEvent e) {
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        return xDebugSession != null ? CidrDebuggerUtilKt.getCidrDebugProcess(xDebugSession) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withClosingToReopen(VirtualFile $this$withClosingToReopen, Function0<Unit> action) {
        $this$withClosingToReopen.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)true);
        try {
            action.invoke();
        }
        finally {
            $this$withClosingToReopen.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
        }
    }

    private static final Unit actionPerformed$lambda$0(Project $project, VirtualFile $file, MemoryViewPanel $memoryViewPanel) {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)$project).openFile($file, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        FileEditor fileEditor = (FileEditor)ArraysKt.firstOrNull((Object[])fileEditorArray);
        if (fileEditor == null) {
            return Unit.INSTANCE;
        }
        FileEditor fileEditor2 = fileEditor;
        GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor2));
        XExpression expression = $memoryViewPanel.getGotoAddressPanel().getInputComponent().getExpressionInput().getExpression();
        if (gotoAddressPanel != null) {
            String string = expression.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
            if (!StringsKt.isBlank((CharSequence)string)) {
                gotoAddressPanel.getInputComponent().getExpressionInput().setExpression(expression);
                gotoAddressPanel.getInputComponent().performEvaluateAction();
            }
        }
        return Unit.INSTANCE;
    }
}

