/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLowLevelException;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSuspensionCause {
    public final Type causeType;
    @NotNull
    @NlsSafe
    public final String reason;
    @Nullable
    public final String file;
    @Nullable
    public final DebuggerSourceFileHash hash;
    public final int line;
    @NotNull
    public final Address address;
    @NotNull
    public final Icon icon;
    @Nullable
    public final CidrLowLevelException lowLevelException;

    public CidrSuspensionCause(Type type, @NotNull String reason, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address address, @Nullable CidrLowLevelException lowLevelException) {
        if (reason == null) {
            CidrSuspensionCause.$$$reportNull$$$0(0);
        }
        if (address == null) {
            CidrSuspensionCause.$$$reportNull$$$0(1);
        }
        this.icon = AllIcons.Debugger.Db_exception_breakpoint;
        this.causeType = type;
        this.reason = reason;
        this.file = file;
        this.hash = hash;
        this.line = line;
        this.address = address;
        this.lowLevelException = lowLevelException;
    }

    public CidrSuspensionCause(Type type, @NotNull String reason, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address address) {
        if (reason == null) {
            CidrSuspensionCause.$$$reportNull$$$0(2);
        }
        if (address == null) {
            CidrSuspensionCause.$$$reportNull$$$0(3);
        }
        this(type, reason, file, hash, line, address, CidrLowLevelException.Companion.detectLowLevelException(type, reason));
    }

    @NlsContexts.Tooltip
    @NotNull
    public String getDisplayString() {
        String string = this.causeType.toDisplayString() + ": " + this.reason;
        if (string == null) {
            CidrSuspensionCause.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getLowLevelDisplayString() {
        String string = this.lowLevelException != null ? this.lowLevelException.getPresentation() : this.causeType.toDisplayString();
        if (string == null) {
            CidrSuspensionCause.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrSuspensionCause cause = (CidrSuspensionCause)o;
        if (!this.reason.equals(cause.reason)) {
            return false;
        }
        return this.causeType.equals((Object)cause.causeType);
    }

    public int hashCode() {
        int result = this.causeType.hashCode();
        result = 31 * result + this.reason.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrSuspensionCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrSuspensionCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowLevelDisplayString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        SIGNAL,
        EXCEPTION,
        EXCEPTION_BREAKPOINT;


        @NotNull
        @NlsSafe
        public String toDisplayString() {
            switch (this.ordinal()) {
                case 0: {
                    String string = CidrDebuggerBundle.message("debug.signal.suspension.cause", new Object[0]);
                    if (string == null) {
                        Type.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                case 1: 
                case 2: {
                    String string = CidrDebuggerBundle.message("debug.signal.exception.cause", new Object[0]);
                    if (string == null) {
                        Type.$$$reportNull$$$0(1);
                    }
                    return string;
                }
            }
            throw new IllegalStateException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrSuspensionCause$Type", "toDisplayString"));
        }
    }
}

