/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrMultiSessionPauser;", "", "<init>", "()V", "pauseOtherSessions", "", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrMultiSessionPauser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrMultiSessionPauser.kt\ncom/jetbrains/cidr/execution/debugger/CidrMultiSessionPauser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,23:1\n3919#2:24\n4434#2,2:25\n1869#3,2:27\n*S KotlinDebug\n*F\n+ 1 CidrMultiSessionPauser.kt\ncom/jetbrains/cidr/execution/debugger/CidrMultiSessionPauser\n*L\n13#1:24\n13#1:25,2\n14#1:27,2\n*E\n"})
public final class CidrMultiSessionPauser {
    /*
     * WARNING - void declaration
     */
    public final void pauseOtherSessions(@NotNull XDebugSession currentSession) {
        Intrinsics.checkNotNullParameter((Object)currentSession, (String)"currentSession");
        boolean shouldPause = CidrDebuggerSettings.getInstance().getPauseAllProcessesOnBreakpointHit();
        if (shouldPause) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)currentSession.getProject()).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            XDebugSession[] debugSessions = xDebugSessionArray;
            CidrDebuggerLog.LOG.debug("Pausing other sessions. Total number of sessions: " + debugSessions.length);
            XDebugSession[] xDebugSessionArray2 = debugSessions;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)currentSession))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XDebugSession it = (XDebugSession)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                CidrDebugProcess cidrProcess = CidrDebuggerUtilKt.getCidrDebugProcess(it);
                if (cidrProcess == null) continue;
                cidrProcess.skipSessionActivationOnNextPause();
                it.pause();
            }
        }
    }
}

