/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrOSProcessUtil;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialRunParameters;
import com.jetbrains.cidr.execution.debugger.CidrAttachedDebugProcess;
import com.jetbrains.cidr.execution.debugger.PidAwareDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrLocalAttachedDebugProcess
extends CidrAttachedDebugProcess
implements PidAwareDebugProcess {
    private final int myPid;

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder) throws ExecutionException {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(0);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(3);
        }
        this(driverConfiguration, info, session, builder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrLocalAttachedDebugProcess(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info, @NotNull XDebugSession session, @NotNull TextConsoleBuilder builder, @NotNull ConsoleFilterProvider backendFilterProvider) throws ExecutionException {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(4);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(5);
        }
        if (session == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(7);
        }
        if (backendFilterProvider == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(8);
        }
        super(CidrLocalAttachedDebugProcess.createRunParameters(driverConfiguration, info), session, builder, backendFilterProvider);
        this.myPid = info.getPid();
    }

    @Override
    @Nullable
    public Integer getPid() {
        return this.getPidToAttachTo();
    }

    @NotNull
    private static RunParameters createRunParameters(@NotNull DebuggerDriverConfiguration driverConfiguration, @NotNull ProcessInfo info) {
        if (driverConfiguration == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(9);
        }
        if (info == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(10);
        }
        int pid = info.getPid();
        ArchitectureType architectureType = SystemInfoRt.isWindows ? CidrOSProcessUtil.getProcessArchitectureType(pid) : ArchitectureType.UNKNOWN;
        return new TrivialRunParameters(driverConfiguration, new GeneralCommandLine(), architectureType);
    }

    @Override
    protected int getPidToAttachTo() {
        return this.myPid;
    }

    @Override
    public boolean isDetachDefault() {
        return true;
    }

    @Override
    @NlsContexts.LinkLabel
    @NotNull
    protected String getRestartDebuggerMessage() {
        String string = XDebuggerBundle.message((String)"xdebugger.attach.reattach", (Object[])new Object[]{this.myPid});
        if (string == null) {
            CidrLocalAttachedDebugProcess.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverConfiguration";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendFilterProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrLocalAttachedDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrLocalAttachedDebugProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartDebuggerMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRunParameters";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

