/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerDataViewsConfigurable;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerGeneralConfigurable;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerRegisterSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerStepFiltersCustomizer;
import com.jetbrains.cidr.execution.debugger.MacOsSymbolSettings;
import com.jetbrains.cidr.execution.debugger.NtSymbolSettings;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingConfigurable;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingSettings;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFilterSettingsItem;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersConfigurableUi;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersDiagnosticsLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDebuggerSettings
extends XDebuggerSettings<CidrDebuggerSettings> {
    private boolean myRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myValuesFilterEnabled = true;
    private boolean myShowFunctionReturnValue = true;
    private final EventDispatcher<SettingListener> myShowFunctionReturnValueDispatcher = EventDispatcher.create(SettingListener.class);
    private final EventDispatcher<SettingListener> myValuesFilterEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myCocoaRenderersEnabled = true;
    private boolean myCoreDataRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myCocoaRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myStlRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myStlRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myHexFormattingEnabled = false;
    private boolean myHexAsSecondaryFormattingEnabled = true;
    private final EventDispatcher<SettingListener> myHexFormattingSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myMuteVariables = false;
    private final EventDispatcher<SettingListener> myMuteVariablesDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myLLDBNatvisRenderersEnabled = true;
    private LLDBNatvisDiagnosticsLevel myLLDBNatvisDiagnosticsLevel = LLDBNatvisDiagnosticsLevel.DISABLED;
    private final EventDispatcher<SettingListener> myNatvisSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myShowFrameModuleName = false;
    private boolean myShowFrameFunctionParameters = true;
    private boolean myShowFrameFunctionTemplateArguments = false;
    private final EventDispatcher<SettingListener> myFrameDecorationSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myShowTypes = true;
    private boolean myShowTypeTemplateArguments = true;
    private final EventDispatcher<SettingListener> myValuePresentationSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myStripCxxAuxiliaryNamespaces = true;
    private boolean mySugarizeCxxStlTypes = true;
    @NotNull
    private NtSymbolSettings myNtSymbolSettings = new NtSymbolSettings();
    @NotNull
    private MacOsSymbolSettings myMacOSSymbolSettings = new MacOsSymbolSettings();
    @NotNull
    private ChildProcessDebuggingSettings myChildProcessDebuggingSettings = new ChildProcessDebuggingSettings();
    private List<CidrDebuggerRegisterSettings> myRegisterSettings = null;
    private boolean myShowRegisters = false;
    private final EventDispatcher<SettingListener> myRegistersSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myFollowChildOnFork = false;
    private final EventDispatcher<SettingListener> myForkSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myDetachOnFork = true;
    private final EventDispatcher<SettingListener> myDetachSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myQtRenderersEnabled = true;
    private boolean myUseSteppingRulesFromFiles = true;
    private boolean myUseSteppingRulesFromSettings = true;
    @NotNull
    private List<StepFilterSettingsItem> myStepFilters = new ArrayList<StepFilterSettingsItem>();
    private StepFiltersDiagnosticsLevel mySteppingRulesDiagnosticsLevel = StepFiltersDiagnosticsLevel.ERRORS_ONLY;
    private boolean myPauseAllProcessesOnBreakpointHit = false;

    @OptionTag(value="RENDERERS_ENABLED")
    public boolean isRenderersEnabled() {
        return this.myRenderersEnabled;
    }

    public void setRenderersEnabled(boolean renderersEnabled) {
        if (this.myRenderersEnabled != renderersEnabled) {
            this.myRenderersEnabled = renderersEnabled;
            this.fireRenderersEnabledChanged();
        }
    }

    @OptionTag(value="VALUES_FILTER_ENABLED")
    public boolean isValuesFilterEnabled() {
        return this.myValuesFilterEnabled;
    }

    public void setValuesFilterEnabled(boolean valuesFilterEnabled) {
        if (this.myValuesFilterEnabled != valuesFilterEnabled) {
            this.myValuesFilterEnabled = valuesFilterEnabled;
            this.fireValuesFilterEnabledChanged();
        }
    }

    @OptionTag(value="SHOW_FUNCTION_RETURN_VALUE")
    public boolean isShowFunctionReturnValue() {
        return this.myShowFunctionReturnValue;
    }

    public void setShowFunctionReturnValue(boolean showFunctionReturnValueEnabled) {
        if (this.myShowFunctionReturnValue != showFunctionReturnValueEnabled) {
            this.myShowFunctionReturnValue = showFunctionReturnValueEnabled;
            this.fireShowFunctionReturnValueChanged();
        }
    }

    @OptionTag(value="COCOA_RENDERERS_ENABLED")
    public boolean isCocoaRenderersEnabled() {
        return this.myCocoaRenderersEnabled;
    }

    public void setCocoaRenderersEnabled(boolean cocoaRenderersEnabled) {
        if (this.myCocoaRenderersEnabled != cocoaRenderersEnabled) {
            this.myCocoaRenderersEnabled = cocoaRenderersEnabled;
            this.fireCocoaRenderersEnabledChanged();
        }
    }

    @OptionTag(value="CORE_DATA_RENDERERS_ENABLED")
    public boolean isCoreDataRenderersEnabled() {
        return this.myCoreDataRenderersEnabled;
    }

    public void setCoreDataRenderersEnabled(boolean coreDataRenderersEnabled) {
        if (this.myCoreDataRenderersEnabled != coreDataRenderersEnabled) {
            this.myCoreDataRenderersEnabled = coreDataRenderersEnabled;
            this.fireCocoaRenderersEnabledChanged();
        }
    }

    @OptionTag(value="STL_RENDERERS_ENABLED")
    public boolean isStlRenderersEnabled() {
        return this.myStlRenderersEnabled;
    }

    public void setStlRenderersEnabled(boolean stlRenderersEnabled) {
        if (this.myStlRenderersEnabled != stlRenderersEnabled) {
            this.myStlRenderersEnabled = stlRenderersEnabled;
            this.fireStlRenderersEnabledChanged();
        }
    }

    @OptionTag(value="MUTE_VARIABLES")
    public boolean isMuteVariables() {
        return this.myMuteVariables;
    }

    public void setMuteVariables(boolean muteVariables) {
        if (this.myMuteVariables != muteVariables) {
            this.myMuteVariables = muteVariables;
            this.fireMuteVariablesChanged();
        }
    }

    @OptionTag(value="LLDB_NATVIS_RENDERERS_ENABLED")
    public boolean isLLDBNatvisRenderersEnabled() {
        return this.myLLDBNatvisRenderersEnabled;
    }

    public void setLLDBNatvisRenderersEnabled(boolean LLDBNatvisRenderersEnabled) {
        if (this.myLLDBNatvisRenderersEnabled != LLDBNatvisRenderersEnabled) {
            this.myLLDBNatvisRenderersEnabled = LLDBNatvisRenderersEnabled;
            this.fireNatvisSettingsChanged();
        }
    }

    @OptionTag(value="LLDB_NATVIS_DIAGNOSTICS_LEVEL")
    public LLDBNatvisDiagnosticsLevel getLLDBNatvisDiagnosticsLevel() {
        return this.myLLDBNatvisDiagnosticsLevel;
    }

    public void setLLDBNatvisDiagnosticsLevel(LLDBNatvisDiagnosticsLevel LLDBNatvisDiagnosticsLevel2) {
        if (this.myLLDBNatvisDiagnosticsLevel != LLDBNatvisDiagnosticsLevel2) {
            this.myLLDBNatvisDiagnosticsLevel = LLDBNatvisDiagnosticsLevel2;
            this.fireNatvisSettingsChanged();
        }
    }

    @OptionTag(value="HEX_FORMATTING_ENABLED")
    public boolean isHexFormattingEnabled() {
        return this.myHexFormattingEnabled;
    }

    public void setHexFormattingEnabled(boolean value) {
        if (this.myHexFormattingEnabled != value) {
            this.myHexFormattingEnabled = value;
            this.fireHexFormattingSettingsChanged();
        }
    }

    @OptionTag(value="HEX_AS_SECONDARY_FORMATTING_ENABLED")
    public boolean isHexAsSecondaryFormattingEnabled() {
        return this.myHexAsSecondaryFormattingEnabled;
    }

    public void setHexAsSecondaryFormattingEnabled(boolean value) {
        if (this.myHexAsSecondaryFormattingEnabled != value) {
            this.myHexAsSecondaryFormattingEnabled = value;
            this.fireHexFormattingSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_MODULE_NAME")
    public boolean isShowFrameModuleName() {
        return this.myShowFrameModuleName;
    }

    public void setShowFrameModuleName(boolean showFrameModuleName) {
        if (this.myShowFrameModuleName != showFrameModuleName) {
            this.myShowFrameModuleName = showFrameModuleName;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_FUNCTION_PARAMETERS")
    public boolean isShowFrameFunctionParameters() {
        return this.myShowFrameFunctionParameters;
    }

    public void setShowFrameFunctionParameters(boolean showFrameFunctionParameters) {
        if (this.myShowFrameFunctionParameters != showFrameFunctionParameters) {
            this.myShowFrameFunctionParameters = showFrameFunctionParameters;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_FUNCTION_TEMPLATE_ARGUMENTS")
    public boolean isShowFrameFunctionTemplateArguments() {
        return this.myShowFrameFunctionTemplateArguments;
    }

    public void setShowFrameFunctionTemplateArguments(boolean showFrameFunctionTemplateArguments) {
        if (this.myShowFrameFunctionTemplateArguments != showFrameFunctionTemplateArguments) {
            this.myShowFrameFunctionTemplateArguments = showFrameFunctionTemplateArguments;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_TYPES")
    public boolean isShowTypes() {
        return this.myShowTypes;
    }

    public void setShowTypes(boolean showTypes) {
        if (this.myShowTypes != showTypes) {
            this.myShowTypes = showTypes;
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_TYPE_TEMPLATE_ARGUMENTS")
    public boolean isShowTypeTemplateArguments() {
        return this.myShowTypeTemplateArguments;
    }

    public void setShowTypeTemplateArguments(boolean showTypeTemplateArguments) {
        if (this.myShowTypeTemplateArguments != showTypeTemplateArguments) {
            this.myShowTypeTemplateArguments = showTypeTemplateArguments;
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="STRIP_CXX_AUXILIARY_NAMESPACES")
    public boolean isStripCxxAuxiliaryNamespaces() {
        return this.myStripCxxAuxiliaryNamespaces;
    }

    public void setStripCxxAuxiliaryNamespaces(boolean stripCxxAuxiliaryNamespaces) {
        if (this.myStripCxxAuxiliaryNamespaces != stripCxxAuxiliaryNamespaces) {
            this.myStripCxxAuxiliaryNamespaces = stripCxxAuxiliaryNamespaces;
            this.fireFrameDecorationSettingsChanged();
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="SUGARIZE_CXX_STL_TYPES")
    public boolean isSugarizeCxxStlTypes() {
        return this.mySugarizeCxxStlTypes;
    }

    public void setSugarizeCxxStlTypes(boolean sugarizeCxxStlTypes) {
        if (this.mySugarizeCxxStlTypes != sugarizeCxxStlTypes) {
            this.mySugarizeCxxStlTypes = sugarizeCxxStlTypes;
            this.fireFrameDecorationSettingsChanged();
            this.fireValuePresentationSettingsChanged();
        }
    }

    @Property(surroundWithTag=false)
    @NotNull
    public NtSymbolSettings getNtSymbolSettings() {
        NtSymbolSettings ntSymbolSettings = this.myNtSymbolSettings;
        if (ntSymbolSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(0);
        }
        return ntSymbolSettings;
    }

    public void setNtSymbolSettings(@NotNull NtSymbolSettings symbolSettings) {
        if (symbolSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(1);
        }
        this.myNtSymbolSettings = symbolSettings;
    }

    @Property(surroundWithTag=false)
    @NotNull
    public MacOsSymbolSettings getMacOSSymbolSettings() {
        MacOsSymbolSettings macOsSymbolSettings = this.myMacOSSymbolSettings;
        if (macOsSymbolSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(2);
        }
        return macOsSymbolSettings;
    }

    public void setMacOSSymbolSettings(@NotNull MacOsSymbolSettings settings) {
        if (settings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(3);
        }
        this.myMacOSSymbolSettings = settings;
    }

    @Property(surroundWithTag=false)
    @NotNull
    public ChildProcessDebuggingSettings getChildProcessDebuggingSettings() {
        ChildProcessDebuggingSettings childProcessDebuggingSettings = this.myChildProcessDebuggingSettings;
        if (childProcessDebuggingSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(4);
        }
        return childProcessDebuggingSettings;
    }

    public void setChildProcessDebuggingSettings(@NotNull ChildProcessDebuggingSettings settings) {
        if (settings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(5);
        }
        this.myChildProcessDebuggingSettings = settings;
    }

    @OptionTag(value="SHOW_REGISTERS")
    public boolean isShowRegisters() {
        return this.myShowRegisters;
    }

    public void setShowRegisters(boolean value) {
        if (this.myShowRegisters != value) {
            this.myShowRegisters = value;
            this.fireRegistersSettingsChanged();
        }
    }

    @OptionTag(value="FOLLOW_CHILD_ON_FORK")
    public boolean isFollowChildOnFork() {
        return this.myFollowChildOnFork;
    }

    public void setFollowChildOnFork(boolean value) {
        if (this.myFollowChildOnFork != value) {
            this.myFollowChildOnFork = value;
            this.fireForkSettingsChanged();
        }
    }

    @OptionTag(value="DETACH_INFERIOR_ON_FORK")
    public boolean isDetachOnFork() {
        return this.myDetachOnFork;
    }

    public void setDetachOnFork(boolean value) {
        if (this.myDetachOnFork != value) {
            this.myDetachOnFork = value;
            this.fireDetachSettingsChanged();
        }
    }

    @XCollection(propertyElementName="register-settings", style=XCollection.Style.v2)
    @Nullable
    public List<CidrDebuggerRegisterSettings> getRegisterSettings() {
        return this.myRegisterSettings;
    }

    public void setRegisterSettings(@Nullable List<CidrDebuggerRegisterSettings> registerSetSettings) {
        this.myRegisterSettings = registerSetSettings;
    }

    @Nullable
    public Map<String, Boolean> getRegisterSetSettings(@NotNull String archName, @NotNull String driverName) {
        if (archName == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(6);
        }
        if (driverName == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(7);
        }
        if (this.myRegisterSettings == null) {
            return null;
        }
        for (CidrDebuggerRegisterSettings arch : this.myRegisterSettings) {
            if (!archName.equals(arch.getArchitecture()) || !driverName.equals(arch.getDriver())) continue;
            return new HashMap<String, Boolean>(arch.getRegisterSets());
        }
        return null;
    }

    public void setRegisterSetSettings(@NotNull String archName, @NotNull String driverName, @NotNull Map<String, Boolean> registerSetSelection) {
        if (archName == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(8);
        }
        if (driverName == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(9);
        }
        if (registerSetSelection == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(10);
        }
        List<CidrDebuggerRegisterSettings> current = this.myRegisterSettings;
        ArrayList<CidrDebuggerRegisterSettings> newSettings = new ArrayList<CidrDebuggerRegisterSettings>();
        if (current != null) {
            for (CidrDebuggerRegisterSettings archRegisters : current) {
                if (archName.equals(archRegisters.getArchitecture()) && driverName.equals(archRegisters.getDriver())) continue;
                newSettings.add(archRegisters);
            }
        }
        CidrDebuggerRegisterSettings changedEntry = new CidrDebuggerRegisterSettings();
        changedEntry.setArchitecture(archName);
        changedEntry.setDriver(driverName);
        changedEntry.setRegisterSets(registerSetSelection);
        newSettings.add(changedEntry);
        this.myRegisterSettings = newSettings;
        this.fireRegistersSettingsChanged();
    }

    @NotNull
    public static CidrDebuggerSettings getInstance() {
        CidrDebuggerSettings cidrDebuggerSettings = (CidrDebuggerSettings)CidrDebuggerSettings.getInstance(CidrDebuggerSettings.class);
        if (cidrDebuggerSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(11);
        }
        return cidrDebuggerSettings;
    }

    public CidrDebuggerSettings() {
        super("ObjectiveC");
        this.myStepFilters.addAll(CidrDebuggerSettings.getDefaultStepFilters());
    }

    public static void updateCurrentDebugSession(AnActionEvent e) {
        XDebugSession session;
        XDebuggerTree tree;
        if (DebuggerUIUtil.isInDetachedTree((AnActionEvent)e) && (tree = XDebuggerTree.getTree((AnActionEvent)e)) != null) {
            tree.rebuildAndRestore(XDebuggerTreeState.saveState((XDebuggerTree)tree));
        }
        if ((session = DebuggerUIUtil.getSession((AnActionEvent)e)) != null) {
            session.rebuildViews();
        }
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(12);
        }
        switch (category) {
            case GENERAL: {
                return this.createGeneralConfigurables();
            }
            case DATA_VIEWS: {
                if (PlatformUtils.isRustRover()) break;
                List<CidrDebuggerDataViewsConfigurable> list = Collections.singletonList(new CidrDebuggerDataViewsConfigurable(this));
                if (list == null) {
                    CidrDebuggerSettings.$$$reportNull$$$0(13);
                }
                return list;
            }
            case STEPPING: {
                if (PlatformUtils.isRustRover() || !Registry.is((String)"cidr.debugger.stepFilters")) break;
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"CIDR.Debugger.StepFiltersSettings", (String)CidrDebuggerBundle.message("debug.settings.name.c.cpp", new Object[0]), StepFiltersConfigurableUi.class, () -> this));
                if (list == null) {
                    CidrDebuggerSettings.$$$reportNull$$$0(14);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private List<Configurable> createGeneralConfigurables() {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        result.add((Configurable)new CidrDebuggerGeneralConfigurable(this));
        if (SystemInfo.isWindows && Registry.is((String)"cidr.debugger.lldb.child.process.debugging.enabled")) {
            result.add((Configurable)new ChildProcessDebuggingConfigurable(this));
        }
        ArrayList<Configurable> arrayList = result;
        if (arrayList == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(17);
        }
        String displayName = configurable.getDisplayName();
        if (PluginUtils.hasAppCode()) {
            return CidrDebuggerBundle.message("debug.settings.name.objective.c", new Object[0]).equals(displayName);
        }
        if (PlatformUtils.isCLion()) {
            return CidrDebuggerBundle.message("debug.settings.name.c.cpp", new Object[0]).equals(displayName);
        }
        return false;
    }

    public CidrDebuggerSettings getState() {
        return this;
    }

    public void loadState(@NotNull CidrDebuggerSettings state) {
        if (state == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(18);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public void addRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addValuesFilterEnabledListener(SettingListener listener, Disposable disposable) {
        this.myValuesFilterEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addShowFunctionReturnValueListener(SettingListener listener, Disposable disposable) {
        this.myShowFunctionReturnValueDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addCocoaRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myCocoaRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addStlRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myStlRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addHexFormattingSettingsListener(SettingListener listener, Disposable disposable) {
        this.myHexFormattingSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addMuteVariablesListener(SettingListener listener, Disposable disposable) {
        this.myMuteVariablesDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addNatvisSettingsListener(SettingListener listener, Disposable disposable) {
        this.myNatvisSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addFrameDecorationSettingsListener(SettingListener listener, Disposable disposable) {
        this.myFrameDecorationSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addValuePresentationSettingsListener(SettingListener listener, Disposable disposable) {
        this.myValuePresentationSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addRegistersSettingsListener(SettingListener listener, Disposable disposable) {
        this.myRegistersSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addForkSettingsListener(SettingListener listener, Disposable disposable) {
        this.myForkSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addDetachSettingsListener(SettingListener listener, Disposable disposable) {
        this.myDetachSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void fireRenderersEnabledChanged() {
        ((SettingListener)this.myRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireValuesFilterEnabledChanged() {
        ((SettingListener)this.myValuesFilterEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireShowFunctionReturnValueChanged() {
        ((SettingListener)this.myShowFunctionReturnValueDispatcher.getMulticaster()).settingChanged();
    }

    public void fireCocoaRenderersEnabledChanged() {
        ((SettingListener)this.myCocoaRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireStlRenderersEnabledChanged() {
        ((SettingListener)this.myStlRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    private void fireHexFormattingSettingsChanged() {
        ((SettingListener)this.myHexFormattingSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireMuteVariablesChanged() {
        ((SettingListener)this.myMuteVariablesDispatcher.getMulticaster()).settingChanged();
    }

    public void fireNatvisSettingsChanged() {
        ((SettingListener)this.myNatvisSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireFrameDecorationSettingsChanged() {
        ((SettingListener)this.myFrameDecorationSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireValuePresentationSettingsChanged() {
        ((SettingListener)this.myValuePresentationSettingsDispatcher.getMulticaster()).settingChanged();
    }

    private void fireRegistersSettingsChanged() {
        ((SettingListener)this.myRegistersSettingsDispatcher.getMulticaster()).settingChanged();
    }

    private void fireForkSettingsChanged() {
        ((SettingListener)this.myForkSettingsDispatcher.getMulticaster()).settingChanged();
    }

    private void fireDetachSettingsChanged() {
        ((SettingListener)this.myDetachSettingsDispatcher.getMulticaster()).settingChanged();
    }

    @OptionTag(value="QT_RENDERERS_ENABLED")
    public boolean isQtRenderersEnabled() {
        return this.myQtRenderersEnabled;
    }

    public void setQtRenderersEnabled(boolean enabled) {
        this.myQtRenderersEnabled = enabled;
    }

    public static List<StepFilterSettingsItem> getDefaultStepFilters() {
        ArrayList<StepFilterSettingsItem> stepFilters = new ArrayList<StepFilterSettingsItem>();
        stepFilters.add(new StepFilterSettingsItem(true, "std::forward<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::move<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "operator new"));
        stepFilters.add(new StepFilterSettingsItem(true, "operator delete"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?operator.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?(empty|size|max_size|capacity)(<.*>)?"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?(at|front|back|data|top)(<.*>)?"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?c?r?(begin|end)(<.*>)?"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?get(_if)?(<.*>)?"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::optional<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(c?ref|reference_wrapper)<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(unique_ptr|shared_ptr|weak_ptr|auto_ptr|make_shared|make_unique)<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::(.*::)?basic_string(_view)?<.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::allocator(::|<).*"));
        stepFilters.add(new StepFilterSettingsItem(true, "std::__.*"));
        stepFilters.add(new StepFilterSettingsItem(true, "__gnu_(cxx|debug|parallel|pbds|profile)::.*"));
        List<StepFilterSettingsItem> result = CidrDebuggerStepFiltersCustomizer.applyCustomizers(stepFilters);
        return result;
    }

    @OptionTag(value="USE_STEPPING_RULES_FROM_FILES")
    public boolean getUseSteppingRulesFromFiles() {
        return this.myUseSteppingRulesFromFiles;
    }

    public void setUseSteppingRulesFromFiles(boolean useSteppingRulesFromFiles) {
        this.myUseSteppingRulesFromFiles = useSteppingRulesFromFiles;
    }

    @OptionTag(value="USE_STEPPING_RULES_FROM_SETTINGS")
    public boolean getUseSteppingRulesFromSettings() {
        return this.myUseSteppingRulesFromSettings;
    }

    public void setUseSteppingRulesFromSettings(boolean useSteppingRulesFromSettings) {
        this.myUseSteppingRulesFromSettings = useSteppingRulesFromSettings;
    }

    @XCollection(propertyElementName="step-filters", style=XCollection.Style.v2)
    @NotNull
    public List<StepFilterSettingsItem> getStepFilters() {
        List<StepFilterSettingsItem> list = this.myStepFilters;
        if (list == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(19);
        }
        return list;
    }

    public void setStepFilters(@NotNull List<StepFilterSettingsItem> stepFilters) {
        if (stepFilters == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(20);
        }
        this.myStepFilters = stepFilters;
    }

    @OptionTag(value="STEPPING_RULES_DIAGNOSTICS_LEVEL")
    public StepFiltersDiagnosticsLevel getSteppingRulesDiagnosticsLevel() {
        return this.mySteppingRulesDiagnosticsLevel;
    }

    public void setSteppingRulesDiagnosticsLevel(StepFiltersDiagnosticsLevel steppingRulesDiagnosticsLevel) {
        this.mySteppingRulesDiagnosticsLevel = steppingRulesDiagnosticsLevel;
    }

    @OptionTag(value="PAUSE_ALL_PROCESSES")
    public boolean getPauseAllProcessesOnBreakpointHit() {
        return this.myPauseAllProcessesOnBreakpointHit;
    }

    public void setPauseAllProcessesOnBreakpointHit(boolean value) {
        this.myPauseAllProcessesOnBreakpointHit = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7, 8, 9, 10, 12, 17, 18, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archName";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerSetSelection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNtSymbolSettings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSSymbolSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildProcessDebuggingSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneralConfigurables";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNtSymbolSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMacOSSymbolSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildProcessDebuggingSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterSetSettings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRegisterSetSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setStepFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 7, 8, 9, 10, 12, 17, 18, 20 -> new IllegalArgumentException(string);
        };
    }

    public static interface SettingListener
    extends EventListener {
        public void settingChanged();
    }
}

