/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerContentProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerMemoryViewProviderKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerMemoryViewProvider;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerContentProvider;", "<init>", "()V", "registerContent", "", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "Companion", "intellij.cidr.debugger.core"})
public final class CidrDebuggerMemoryViewProvider
implements CidrDebuggerContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MEMORY_VIEW_CONTENT_ID = "CIDR_DEBUGGER_MEMORY_VIEW";

    @Override
    public void registerContent(@NotNull CidrDebugProcess debugProcess, @NotNull RunnerLayoutUi ui) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        MemoryViewPanel memoryViewPanel = MemoryViewPanel.create(debugProcess.getProject(), (VirtualFile)debugProcess.getMemory().getHexdumpDoc().getVirtualFile());
        if (memoryViewPanel == null) {
            return;
        }
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        Disposer.register((Disposable)debugProcess.getUiDisposable(), (Disposable)((Disposable)memoryViewPanel2));
        debugProcess.putUserData(CidrDebuggerMemoryViewProviderKt.access$getMEMORY_VIEW_PANEL_KEY$p(), memoryViewPanel2);
        Content content = ui.createContent(MEMORY_VIEW_CONTENT_ID, memoryViewPanel2.getComponent(), debugProcess.getMemoryViewTabName(), null, memoryViewPanel2.getPreferredFocusableComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content memoryViewContent = content;
        memoryViewContent.setCloseable(false);
        CidrDebuggerUtilKt.addContent(ui, memoryViewContent);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerMemoryViewProvider$Companion;", "", "<init>", "()V", "MEMORY_VIEW_CONTENT_ID", "", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

