/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    public static final ExtensionPointName<LanguageExtensionPoint<CidrDebuggerEditorsExtension>> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.editorsExtension");
    private static final LanguageExtension<CidrDebuggerEditorsExtension> EXTENSION = new LanguageExtension(EP_NAME);

    @NotNull
    private static LanguageExtensionPoint<CidrDebuggerEditorsExtension> getDefaultExtension() {
        LanguageExtensionPoint languageExtensionPoint = (LanguageExtensionPoint)EP_NAME.getExtensionList().stream().findFirst().orElseThrow(() -> new IllegalStateException("No default extension for " + EP_NAME.getName()));
        if (languageExtensionPoint == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return languageExtensionPoint;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType fileType = CidrDebuggerEditorsProvider.getDefaultLanguage().getAssociatedFileType();
        Object object = fileType != null ? fileType : FileTypes.UNKNOWN;
        if (object == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    private static Language getDefaultLanguage() {
        Language language = Language.findLanguageByID((String)CidrDebuggerEditorsProvider.getDefaultExtension().getKey());
        Language language2 = language != null ? language : Language.ANY;
        if (language2 == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        return language2;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        Set<Language> set = Collections.singleton(CidrDebuggerEditorsProvider.getLanguage(null, sourcePosition));
        if (set == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        String text = expression.getExpression();
        if (sourcePosition != null) {
            Document document;
            Language language = CidrDebuggerEditorsProvider.getLanguage(expression, sourcePosition);
            CidrDebuggerEditorsExtension extension = (CidrDebuggerEditorsExtension)EXTENSION.forLanguage(language);
            if (extension == null) {
                extension = (CidrDebuggerEditorsExtension)CidrDebuggerEditorsProvider.getDefaultExtension().getInstance();
            }
            if ((document = extension.createDocument(project, text, sourcePosition, mode)) != null) {
                Document document2 = document;
                if (document2 == null) {
                    CidrDebuggerEditorsProvider.$$$reportNull$$$0(8);
                }
                return document2;
            }
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)text);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
        Document document3 = Objects.requireNonNull(document, "Unable to create plain text document for expression");
        if (document3 == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(9);
        }
        return document3;
    }

    @NotNull
    private static Language getLanguage(@Nullable XExpression expression, @Nullable XSourcePosition position) {
        FileType type;
        if (expression != null && expression.getLanguage() != null) {
            Language language = expression.getLanguage();
            if (language == null) {
                CidrDebuggerEditorsProvider.$$$reportNull$$$0(10);
            }
            return language;
        }
        if (position != null && (type = position.getFile().getFileType()) instanceof LanguageFileType) {
            Language language = ((LanguageFileType)type).getLanguage();
            if (language == null) {
                CidrDebuggerEditorsProvider.$$$reportNull$$$0(11);
            }
            return language;
        }
        return CidrDebuggerEditorsProvider.getDefaultLanguage();
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return new InlineDebuggerHelper(this){

            public boolean shouldEvaluateChildrenByDefault(@NotNull XNamedTreeNode node) {
                boolean calculateThisChildren;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (calculateThisChildren = Registry.is((String)"cidr.debugger.autoExpandThisForInlinedValues", (boolean)false)) && !CidrDebuggerSettings.getInstance().isMuteVariables() && DEFAULT.shouldEvaluateChildrenByDefault(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider$1", "shouldEvaluateChildrenByDefault"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLanguage";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

