/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerConsoleProviderKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerContentProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.jetbrains.cidr.util.events.CidrEventTracerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerConsoleProvider;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerContentProvider;", "<init>", "()V", "registerContent", "", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "registerTabCompletion", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.cidr.debugger.core"})
public final class CidrDebuggerConsoleProvider
implements CidrDebuggerContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEBUGGER_CONSOLE_CONTENT_ID = "CIDR_DEBUGGER_CONSOLE_CONTENT";

    @Override
    public void registerContent(@NotNull CidrDebugProcess debugProcess, @NotNull RunnerLayoutUi ui) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        DebuggerDriverConfiguration debuggerDriverConfiguration = debugProcess.getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debuggerDriverConfiguration), (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration configuration = debuggerDriverConfiguration;
        Language language = configuration.getConsoleLanguage();
        if (language == null) {
            return;
        }
        Language debuggerConsoleLanguage = language;
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        String string = debugProcess.getBackendConsoleTabName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBackendConsoleTabName(...)");
        LanguageConsoleImpl console = new LanguageConsoleImpl(project, string, debuggerConsoleLanguage);
        Disposer.register((Disposable)debugProcess.getUiDisposable(), (Disposable)((Disposable)console));
        debugProcess.putUserData(CidrDebuggerConsoleProviderKt.access$getDEBUGGER_CONSOLE_KEY$p(), console);
        console.getConsoleEditor().getDocument().putUserData(CidrDebugProcess.DEBUG_PROCESS_KEY, (Object)debugProcess);
        console.setEditable(false);
        this.registerTabCompletion((Editor)console.getConsoleEditor());
        Filter[] filterArray = debugProcess.getBackendConsoleFilterProvider().getDefaultFilters(debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)filterArray, (String)"getDefaultFilters(...)");
        for (Filter filter : filterArray) {
            Intrinsics.checkNotNull((Object)filter);
            console.addMessageFilter(filter);
        }
        Content content = ui.createContent(DEBUGGER_CONSOLE_CONTENT_ID, console.getComponent(), debugProcess.getBackendConsoleTabName(), AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content backendConsoleContent = content;
        backendConsoleContent.setCloseable(false);
        CidrDebuggerUtilKt.addContent(ui, backendConsoleContent);
        for (BackendConsoleInjectionHelper helper : BackendConsoleInjectionHelper.EP_NAME.getExtensionList()) {
            helper.subscribeToInjection(debugProcess.getSession());
        }
        LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)((LanguageConsoleView)console), arg_0 -> CidrDebuggerConsoleProvider.registerContent$lambda$1(arg_0 -> CidrDebuggerConsoleProvider.registerContent$lambda$0(debugProcess, arg_0), arg_0), (String)"AppCode.Debug.Console", null, null);
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(debugProcess, console){
            private CidrEventSpan myStateSpan;
            final /* synthetic */ CidrDebugProcess $debugProcess;
            final /* synthetic */ LanguageConsoleImpl $console;
            {
                this.$debugProcess = $debugProcess;
                this.$console = $console;
            }

            public void sessionPaused() {
                this.traceState(null);
                CidrEventTracerKt.traceMarker$default("debug", "session paused", null, null, 8, null);
                this.enableConsole(true);
            }

            public void sessionResumed() {
                CidrEventTracerKt.traceMarker$default("debug", "session resumed", null, null, 12, null);
                this.traceState(new CidrEventSpan("debug", "session running", null, "<DebugSession>"));
                this.enableConsole(false);
            }

            public void sessionStopped() {
                this.traceState(null);
                CidrEventTracerKt.traceMarker$default("debug", "sessionStopped", null, null, 8, null);
                this.enableConsole(false);
            }

            private final void enableConsole(boolean enabled) {
                if (this.$debugProcess.getProject().isDisposed() || Disposer.isDisposed((Disposable)((Disposable)this.$console))) {
                    return;
                }
                this.$console.setEditable(enabled);
            }

            private final void traceState(CidrEventSpan eventSpan) {
                CidrEventSpan cidrEventSpan = this.myStateSpan;
                if (cidrEventSpan != null) {
                    cidrEventSpan.close();
                }
                this.myStateSpan = eventSpan;
            }
        });
    }

    private final void registerTabCompletion(Editor editor) {
        AnAction anAction = ActionManager.getInstance().getAction("CodeCompletion");
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        AnAction wrappedAction2 = (AnAction)new AnActionWrapper(action, editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super($action);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                LookupEx lookupEx = LookupManager.getActiveLookup((Editor)this.$editor);
                LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
                boolean enabled = lookup == null || !lookup.isAvailableToUser();
                e.getPresentation().setEnabled(enabled);
            }
        };
        wrappedAction2.registerCustomShortcutSet(9, 0, editor.getContentComponent());
    }

    private static final Unit registerContent$lambda$0(CidrDebugProcess $debugProcess, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $debugProcess.executeConsoleCommand(text);
        return Unit.INSTANCE;
    }

    private static final void registerContent$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerConsoleProvider$Companion;", "", "<init>", "()V", "DEBUGGER_CONSOLE_CONTENT_ID", "", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

