/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import org.jetbrains.annotations.NotNull;

public final class CidrDebugConsoleCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        CidrDebugProcess process;
        PsiFile originalFile;
        Document document;
        boolean autoPopupCompletions;
        if (parameters == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(1);
        }
        if (((autoPopupCompletions = Registry.is((String)"cidr.debugger.console.completion.autoPopup", (boolean)false)) || parameters.getInvocationCount() > 0) && (document = PsiDocumentManager.getInstance((Project)(originalFile = parameters.getOriginalFile()).getProject()).getDocument(originalFile)) != null && (process = (CidrDebugProcess)document.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY)) != null) {
            process.completeConsoleCommand(parameters, result.withPrefixMatcher(CidrDebugConsoleCompletionContributor.createPrefixMatcher(parameters)));
        }
        super.fillCompletionVariants(parameters, result);
    }

    @NotNull
    private static PrefixMatcher createPrefixMatcher(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(2);
        }
        CharSequence text = parameters.getPosition().getContainingFile().getViewProvider().getContents();
        int offset = parameters.getOffset();
        String prefix = CidrDebugConsoleCompletionContributor.getWordPrefix(text, offset).toString();
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    private static CharSequence getWordPrefix(@NotNull CharSequence text, int offset) {
        if (text == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(3);
        }
        int startOffset = CidrDebugConsoleCompletionContributor.getWordStartOffset(text, offset);
        CharSequence charSequence = text.subSequence(startOffset, offset);
        if (charSequence == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    private static int getWordStartOffset(@NotNull CharSequence text, int offset) {
        if (text == null) {
            CidrDebugConsoleCompletionContributor.$$$reportNull$$$0(5);
        }
        for (int i = offset; i > 0; --i) {
            if (!Character.isWhitespace(text.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugConsoleCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugConsoleCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWordPrefix";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWordStartOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

