/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrAggregatedFrameStatistics;", "", "<init>", "()V", "myMaxValuePresentationDurationMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "myMaxChildrenLoadingDurationMillis", "report", "", "driverName", "", "addValuePresentationTime", "durationMillis", "", "addChildrenLoadingTime", "Companion", "intellij.cidr.debugger.core"})
@ApiStatus.Internal
public final class CidrAggregatedFrameStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicLong myMaxValuePresentationDurationMillis = new AtomicLong(-1L);
    @NotNull
    private final AtomicLong myMaxChildrenLoadingDurationMillis = new AtomicLong(-1L);
    private static final long NONE = -1L;

    public final void report(@NotNull String driverName) {
        long maxChildrenLoadingTime;
        Intrinsics.checkNotNullParameter((Object)driverName, (String)"driverName");
        long maxValuePresentationTime = this.myMaxValuePresentationDurationMillis.get();
        if (maxValuePresentationTime != -1L) {
            CidrDebuggerUsagesCollector.logSlowestValuePresentationComputed(driverName, maxValuePresentationTime);
        }
        if ((maxChildrenLoadingTime = this.myMaxChildrenLoadingDurationMillis.get()) != -1L) {
            CidrDebuggerUsagesCollector.logSlowestChildrenLoaded(driverName, maxChildrenLoadingTime);
        }
    }

    public final void addValuePresentationTime(long durationMillis) {
        this.myMaxValuePresentationDurationMillis.accumulateAndGet(durationMillis, CidrAggregatedFrameStatistics::addValuePresentationTime$max__proxy);
    }

    public final void addChildrenLoadingTime(long durationMillis) {
        this.myMaxChildrenLoadingDurationMillis.accumulateAndGet(durationMillis, CidrAggregatedFrameStatistics::addChildrenLoadingTime$max__proxy);
    }

    private static final long addValuePresentationTime$max__proxy(long p0$a, long p1$b) {
        return Math.max(p0$a, p1$b);
    }

    private static final long addChildrenLoadingTime$max__proxy(long p0$a, long p1$b) {
        return Math.max(p0$a, p1$b);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrAggregatedFrameStatistics$Companion;", "", "<init>", "()V", "NONE", "", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

